/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.util.DateTimeManager;
import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.ui.monitoring.dataquery.AgentHackTypeItem;
import com.sygate.scm.console.ui.monitoring.dataquery.AgentSecuritySeverityItem;
import com.sygate.scm.console.ui.monitoring.dataquery.TableCriteriaList;
import com.sygate.scm.console.ui.monitoring.logviewer.LogUtilities;
import com.sygate.scm.console.ui.util.IDropdownItemLoader;
import com.sygate.scm.util.Utility;
import com.sygate.scm.util.query.AgentOperatingSystemTypeItem;
import com.sygate.scm.util.query.DropdownItem;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

public class TableColumnMap {
    public static final int TYPE_STRING = 0;
    public static final int TYPE_DROPDOWN = 1;
    public static final int TYPE_TIME = 2;
    public static final int TYPE_IP_FIELD = 3;
    public static final int TYPE_NUMBER = 4;
    public static final int TYPE_EVENT_LOG_ID = 5;
    public static final int TYPE_AGENT_SECURITY_SEVERITY_DROPDOWN = 6;
    public static final int TYPE_AGENT_HACK_TYPE_DROPDOWN = 7;
    public static final int TYPE_UNITED_NUMBER = 8;
    public static final int TYPE_PATTERN_VERSION_AV = 9;
    public static final int TYPE_PATTERN_VERSION_IPS = 10;
    public static final int TYPE_PATTERN_VERSION_TC_WL = 11;
    public static final int TYPE_PATTERN_VERSION_TC_CNT = 12;
    public static final int TYPE_GROUP_UPDATE_PROVIDER = 13;
    public static final int TYPE_OS_DROPDOWN = 14;
    public static final int TYPE_HYPERVISOR = 15;
    public static final int TYPE_STRING_1 = 20;
    public static final int TYPE_DROPDOWN_1 = 21;
    public static final int TYPE_TIME_1 = 22;
    public static final int TYPE_IP_FIELD_1 = 23;
    public static final int TYPE_NUMBER_1 = 24;
    public static final int TYPE_EVENT_LOG_ID_1 = 25;
    public static final int TYPE_AGENT_SECURITY_SEVERITY_DROPDOWN_1 = 26;
    public static final int TYPE_AGENT_HACK_TYPE_DROPDOWN_1 = 27;
    public static final int TYPE_UNITED_NUMBER_1 = 28;
    public static final int TYPE_GROUP_UPDATE_PROVIDER_1 = 30;
    public static final int TYPE_IP4_IP6_FIELD = 31;
    protected String tableName;
    protected String columnName;
    protected String displayName;
    protected Object optValue;
    protected int type;
    private boolean trimColumn = false;
    protected IDropdownItemLoader dropDownItemLoader = null;

    public TableColumnMap(String tableName, String columnName, String displayName) {
        this(tableName, columnName, displayName, 0, null);
    }

    public TableColumnMap(String tableName, String columnName, String displayName, int type) {
        this(tableName, columnName, displayName, type, null);
    }

    public TableColumnMap(String tableName, String columnName, String displayName, DropdownItem[] dropdown) {
        this(tableName, columnName, displayName, 1, dropdown);
    }

    public TableColumnMap(String tableName, String columnName, String displayName, int type, Object optValue) {
        this(tableName, columnName, displayName, type, optValue, false);
    }

    public TableColumnMap(String tableName, String columnName, String displayName, int type, Object optValue, boolean trimColumn) {
        this(tableName, columnName, displayName, type, optValue, trimColumn, null);
    }

    public TableColumnMap(String tableName, String columnName, String displayName, int type, Object optValue, boolean trimColumn, IDropdownItemLoader dropDownItemLoader) {
        this.tableName = tableName;
        this.columnName = columnName;
        this.displayName = displayName;
        this.type = type;
        this.optValue = optValue;
        this.dropDownItemLoader = dropDownItemLoader;
        this.trimColumn = trimColumn;
    }

    protected String getQueryName() {
        return this.tableName + "." + this.columnName;
    }

    protected void onColumnSelected() {
        if (this.dropDownItemLoader != null) {
            this.optValue = this.dropDownItemLoader.loadValues();
        }
    }

    private Object getQueryValue(Object value, boolean isLike) {
        switch (this.type) {
            case 1: {
                return ((DropdownItem)value).getValue();
            }
            case 13: 
            case 15: {
                return ((DropdownItem)value).getValue();
            }
            case 2: {
                SimpleDateFormat sdf = new SimpleDateFormat(DateTimeManager.getDateFormat() + " HH:mm:ss");
                Date sDate = null;
                try {
                    sDate = sdf.parse((String)value);
                }
                catch (Exception ex) {
                    sDate = null;
                }
                return sDate == null ? "" : String.valueOf(sDate.getTime());
            }
            case 8: {
                int index;
                String tempValue = value.toString().trim();
                if (tempValue == null || tempValue.length() <= 0) {
                    return "";
                }
                int unitPos = -1;
                for (index = 0; index < TableCriteriaList.getUnitDropdownLength() && unitPos < 0; ++index) {
                    unitPos = tempValue.toString().indexOf(TableCriteriaList.getUnitDropdownByIndex(index).toString());
                }
                long ret = Long.parseLong(tempValue.substring(0, unitPos)) * (Long)TableCriteriaList.getUnitDropdownByIndex(--index).getValue();
                return String.valueOf(ret < 0L ? Long.MAX_VALUE : ret);
            }
            case 3: {
                long ip = -1L;
                try {
                    ip = Utility.getIpLong((String)((String)value));
                }
                catch (Exception ex) {
                    ip = -1L;
                }
                return ip == -1L ? "" : String.valueOf(ip);
            }
            case 31: {
                return String.valueOf(value);
            }
            case 5: {
                return null;
            }
        }
        return value;
    }

    public int getType() {
        return this.type;
    }

    public Object getOptValue() {
        if (this.dropDownItemLoader != null) {
            this.optValue = this.dropDownItemLoader.loadValues();
        }
        return this.optValue;
    }

    public IDropdownItemLoader getDropdownItemLoader() {
        return this.dropDownItemLoader;
    }

    public String toString() {
        return this.displayName;
    }

    public void getValue(RpcData rpc, Object operator, Object value) {
        boolean isLike = operator.equals("LIKE");
        String op = (String)operator;
        switch (this.type) {
            case 4: 
            case 24: {
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)34, (String)(this.tableName + "." + this.columnName), (String)op, (String)value.toString());
                return;
            }
            case 5: 
            case 25: {
                List<String> values = LogUtilities.getIDForValue(this.columnName, op, (String)value);
                if (values.size() > 0) {
                    StringBuilder buf = new StringBuilder();
                    for (int i = 0; i < values.size(); ++i) {
                        buf.append("," + values.get(i));
                    }
                    Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)35, (String)this.getQueryName(), (String)op, (String)buf.substring(1));
                    return;
                }
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)34, (String)this.getQueryName(), (String)"=", (String)"x");
                return;
            }
            case 6: 
            case 26: {
                AgentSecuritySeverityItem secItem = (AgentSecuritySeverityItem)((Object)value);
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)36, (String)this.getQueryName(), (String)op, (String)(secItem.getLow() + "," + secItem.getHigh()));
                return;
            }
            case 7: 
            case 27: {
                AgentHackTypeItem hackItem = (AgentHackTypeItem)((Object)value);
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)37, (String)this.getQueryName(), (String)op, (String)hackItem.getEventType().toString());
                return;
            }
            case 14: {
                AgentOperatingSystemTypeItem osItem = null;
                if (value instanceof AgentOperatingSystemTypeItem) {
                    osItem = (AgentOperatingSystemTypeItem)value;
                } else if (value instanceof String) {
                    osItem = AgentOperatingSystemTypeItem.getAgentOperatingSystemTypeItem((String)((String)value));
                }
                if (osItem != null) {
                    Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)44, (String)osItem.getQueryName(), (String)op, (String)((String)osItem.getValue()));
                }
                return;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                int parType = 42;
                if (this.type == 9) {
                    parType = 39;
                } else if (this.type == 10) {
                    parType = 40;
                } else if (this.type == 11) {
                    parType = 41;
                }
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)parType, (String)op, (String)((RevisionObject)value).toDbFormatString());
                return;
            }
            case 3: 
            case 23: {
                if ("SEM_COMPUTER" != this.tableName || "IP_ADDR1" != this.columnName) {
                    Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)32, (String)this.getQueryName(), (String)op, (String)this.getQueryValue(value, isLike).toString());
                    return;
                }
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)33, (String)op, (String)this.getQueryValue(value, isLike).toString());
                return;
            }
            case 31: {
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)46, (String)op, (String)this.getQueryValue(value, isLike).toString());
                return;
            }
            case 13: {
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)43, (String)op, (String)this.getQueryValue(value, isLike).toString());
                return;
            }
            case 15: {
                Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)45, (String)op, (String)this.getQueryValue(value, isLike).toString());
                return;
            }
        }
        Utility.addSqlParameterToRpcData((RpcData)rpc, (String)"SEARCH_CRITERIA", (Integer)29, (String)this.getQueryName(), (String)op, (String)this.getQueryValue(value, isLike).toString());
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean isTrimColumn() {
        return this.trimColumn;
    }
}

