/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.util.Env;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingWorker;

public class SwingWorkerExecutor {
    private static final int MAX_WORKER_THREAD = 10;
    private static final SwingWorkerExecutor executor = new SwingWorkerExecutor();
    private ExecutorService workerThreadPool = Executors.newFixedThreadPool(10);

    private SwingWorkerExecutor() {
    }

    public static SwingWorkerExecutor getInstance() {
        return executor;
    }

    public synchronized <T, V> void execute(SwingWorker<T, V> worker) {
        if (!Env.isUnitTest()) {
            this.workerThreadPool.submit(worker);
        }
    }

    public synchronized void stopAllConsoleSwingWorkers() {
        if (this.workerThreadPool != null) {
            this.workerThreadPool.shutdownNow();
            try {
                this.workerThreadPool.awaitTermination(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.workerThreadPool = null;
        }
        this.workerThreadPool = Executors.newFixedThreadPool(10);
    }
}

