/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.IPField;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class SubnetPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int NO_ERROR = 0;
    public static final int ERR_WRONG_IP = 1;
    public static final int ERR_WRONG_MASK = 2;
    private String errorMessage = "";
    private int errorCode = 0;
    IPField ipField = new IPField();
    IPField maskField = new IPField();
    private JComponent[][] objs = new JComponent[2][4];

    public SubnetPane() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void jbInit() throws Exception {
        this.ipField.setPreferredSize(new Dimension(150, 20));
        this.maskField.setPreferredSize(new Dimension(150, 20));
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagConstraints gbCon = new GridBagConstraints();
        this.objs[0][0] = new JLabel();
        this.objs[1][0] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "SubnetPane.label.subnetExample"));
        JLabel label1 = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "SubnetPane.label.subnetAddress"));
        this.objs[0][1] = label1;
        this.objs[1][1] = this.ipField;
        this.objs[0][2] = new JLabel();
        this.objs[1][2] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "SubnetPane.label.maskExample"));
        JLabel label2 = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "SubnetPane.subnetMask"));
        int w = Math.max(label1.getPreferredSize().width, 120);
        w = Math.max(w, label2.getPreferredSize().width);
        label1.setPreferredSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        label1.setMinimumSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        label2.setPreferredSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        label2.setMinimumSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.objs[0][3] = label2;
        this.objs[1][3] = this.maskField;
        for (int i = 0; i < this.objs.length; ++i) {
            for (int j = 0; j < this.objs[i].length; ++j) {
                gbCon.gridx = i;
                gbCon.gridy = j;
                gbCon.anchor = 17;
                gbCon.weighty = 0.0;
                gbCon.insets = new Insets(0, 0, 2, 10);
                if (i == 1) {
                    gbCon.weightx = 0.5;
                    gbCon.gridwidth = 0;
                    gbCon.fill = 2;
                    gbCon.insets = new Insets(0, 10, 2, 0);
                    if (j == 0 || j == 2) {
                        gbCon.insets = new Insets(5, 10, 0, 0);
                        gbCon.anchor = 16;
                    }
                } else {
                    gbCon.gridwidth = 1;
                    gbCon.weightx = 0.0;
                }
                this.add((Component)this.objs[i][j], gbCon);
            }
        }
    }

    public String getText() {
        String ip = this.ipField.getText();
        String mask = this.maskField.getText();
        if (ip.length() == 0) {
            return mask;
        }
        if (mask.length() == 0) {
            return ip;
        }
        return ip + ";" + mask;
    }

    public JLabel getIpLabel() {
        try {
            return (JLabel)this.objs[0][1];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), "Illegal Casting, please check index", "Casting Error", 0);
            LoggerUtilities.logException((Throwable)e);
            return null;
        }
    }

    public JLabel getMaskLabel() {
        try {
            return (JLabel)this.objs[0][3];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Manager.getFrame(), "Illegal Casting, please check index", "Casting Error", 0);
            LoggerUtilities.logException((Throwable)e);
            return null;
        }
    }

    public void setLeftLabelSize(Dimension d) {
        this.getIpLabel().setPreferredSize(d);
        this.getMaskLabel().setPreferredSize(d);
        this.updateUI();
    }

    public Dimension getLeftLabelSize() {
        return this.getIpLabel().getPreferredSize();
    }

    public String getIPAddress() {
        return this.ipField.getText();
    }

    public String getMaskAddress() {
        return this.maskField.getText();
    }

    public void setIPAddress(String ip) {
        this.ipField.setText(ip);
    }

    public void setMaskAddress(String mask) {
        this.maskField.setText(mask);
    }

    public boolean isValidValue() {
        if (!this.ipField.isValid()) {
            this.errorCode = 1;
            this.errorMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "SubnetPane.msg.wrongSubnetAddress");
            return false;
        }
        if (!this.maskField.isValid()) {
            this.errorCode = 2;
            this.errorMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "SubnetPane.wrong.subnetMask");
            return false;
        }
        return true;
    }

    @Override
    public void requestFocus() {
        switch (this.errorCode) {
            case 1: {
                this.ipField.requestFocus();
                break;
            }
            case 2: {
                this.maskField.requestFocus();
                break;
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

