/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.creamtec.sepm.ajaxswing.support.components.JEditorPane;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.TextValidator;
import com.sygate.scm.util.HTMLUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;

public class StyledTextEditorDlg
extends DialogBase {
    private static final long serialVersionUID = 1L;
    protected JTextPane jTPEditor = new JTextPane();
    protected TextValidator validator;

    public StyledTextEditorDlg(String title, String instruction, TextValidator validator) {
        super(Manager.getFrame(), title, true);
        this.validator = validator;
        this.initialize(instruction);
        this.initializeData();
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    public String getDocumentText() {
        try {
            Document doc = this.jTPEditor.getDocument();
            return doc.getText(0, doc.getLength());
        }
        catch (BadLocationException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    @Override
    protected boolean isValidate() {
        if (this.validator == null) {
            return true;
        }
        return this.validator.isValidate(this.getDocumentText());
    }

    protected void initializeData() {
    }

    private void initialize(String instruction) {
        this.jTPEditor.setPreferredSize(new Dimension(400, 300));
        this.getContentPane().add((Component)this.getInnerPanel(instruction), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    private JPanel getInnerPanel(String instruction) {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        if (instruction != null && instruction.length() > 0) {
            JEditorPane instructionPanel = new JEditorPane();
            instructionPanel.setContentType("text/html");
            instructionPanel.setEditable(false);
            instructionPanel.setText(HTMLUtilities.HTML_DOCUMENT_BEGIN + instruction + "</BODY></HTML>");
            panel.add((Component)instructionPanel, "North");
        }
        panel.add((Component)new JScrollPane(this.jTPEditor), "Center");
        return panel;
    }
}

