/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.ui.CustomLookAndFeel;
import com.sygate.scm.common.ui.HtmlEnabledJTable;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ui.util.renderer.GrayedComboBoxTableCellRenderer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class StripesTable
extends HtmlEnabledJTable {
    private static final long serialVersionUID = 1L;
    private static final int DEFAULT_ROW_HEIGHT = 21;
    private static final int BIG_ROW_HEIGHT = 31;
    private static final int HEADER_HEIGHT = 25;
    private Color evenColor;
    private Color oddColor;
    private TableCellRenderer tableCellRenderer = new CustomTableCellRenderer();
    private int rowHeight = 21;
    private static final Color DEFAULT_STRIPE_COLOR = UIColorUtilities.TABLE_STRIPE;

    public StripesTable() {
        this.init(false, false);
    }

    public StripesTable(TableModel dm) {
        super(dm);
        this.init(false, false);
    }

    public StripesTable(boolean striped, boolean bigRows) {
        this.init(striped, bigRows);
    }

    public StripesTable(TableModel dm, boolean striped, boolean bigRows) {
        super(dm);
        this.init(striped, bigRows);
    }

    private void init(boolean striped, boolean bigRows) {
        this.setShowGrid(false);
        this.setIntercellSpacing(new Dimension(0, 0));
        this.rowHeight = bigRows ? 31 : 21;
        this.setTableHeader(new JTableHeader(this.getColumnModel()){
            private static final long serialVersionUID = 1L;

            @Override
            public Dimension getPreferredSize() {
                Dimension d = super.getPreferredSize();
                d.height = 25;
                return d;
            }
        });
        this.getTableHeader().setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, UIColorUtilities.CONTROL_BACKGROUND));
        ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
        this.evenColor = this.getBackground();
        this.oddColor = striped ? DEFAULT_STRIPE_COLOR : this.evenColor;
    }

    public int getRowHeight() {
        return this.rowHeight;
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.tableCellRenderer;
    }

    private Color getBackground(int row) {
        if (row % 2 == 0) {
            return this.evenColor;
        }
        return this.oddColor;
    }

    private class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        private CustomTableCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Component component = null;
            if (null == value) {
                component = super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
            } else {
                TableCellRenderer tableCellRenderer = StripesTable.this.getColumnModel().getColumn(column).getCellRenderer();
                if (null == tableCellRenderer) {
                    tableCellRenderer = StripesTable.this.getDefaultRenderer(value.getClass());
                }
                component = tableCellRenderer.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            }
            if (!(isSelected || component instanceof GrayedComboBoxTableCellRenderer && !table.isCellEditable(row, column))) {
                component.setBackground(StripesTable.this.getBackground(row));
            }
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(CustomLookAndFeel.CELL_BORDER);
            }
            return component;
        }
    }
}

