/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.logicobject.TimeTableRow;
import com.sygate.scm.console.ui.util.ArrowIcon;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.ui.util.renderer.TableHeaderRenderer;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Collator;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class SortableTableModel
extends CustomTableModel {
    private static final long serialVersionUID = 1L;
    public static final Icon upIcon = new ArrowIcon(1);
    public static final Icon downIcon = new ArrowIcon(3);
    protected int sortedColumn;
    protected boolean isAscending;
    private boolean isCaseSensitive;
    private transient Map<JTableHeader, MouseListener> tableHeaderMouseListenerMap = new HashMap<JTableHeader, MouseListener>();

    public int getSortedColumn() {
        return this.sortedColumn;
    }

    public boolean getIsAscending() {
        return this.isAscending;
    }

    public SortableTableModel() {
        this(true);
    }

    public SortableTableModel(boolean isCaseSensitive) {
        this.isCaseSensitive = isCaseSensitive;
        this.sortedColumn = -1;
    }

    public SortableTableModel(String[] columnNames, int[] columnMapping) {
        super(columnNames, columnMapping);
        this.sortedColumn = -1;
    }

    public void sortTable(int column) {
        if (column < 0) {
            column = this.sortedColumn;
        }
        this.sortTable(column, this.isAscending);
    }

    public void sortTable(int column, boolean isAscending) {
        this.sortTable(column, isAscending, this.getRowComparator(column, isAscending));
    }

    protected Comparator<Object> getRowComparator(int column, boolean isAscending) {
        return new RowComparator(this, column, isAscending, this.isCaseSensitive);
    }

    public void sortTable(int column, boolean isAscending, Comparator<Object> rowComparator) {
        if (column < 0 || this.getDataVector() == null || column > this.getColumnCount()) {
            return;
        }
        this.isAscending = isAscending;
        this.sortedColumn = column;
        Vector<TableRow> data = this.getDataVector();
        Collections.sort(data, rowComparator);
        this.setDataVector(data);
        this.fireTableDataChanged();
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        final SortableTableModel sorter = this;
        final JTable tableView = table;
        tableView.putClientProperty("cssClass", "sortableTableModeltableView");
        tableView.setColumnSelectionAllowed(false);
        JTableHeader th = tableView.getTableHeader();
        MouseAdapter mouseListener = (MouseAdapter)this.tableHeaderMouseListenerMap.get(th);
        if (mouseListener == null) {
            MouseAdapter listMouseListener = new MouseAdapter(){

                @Override
                public void mouseClicked(MouseEvent e) {
                    TableColumnModel colModel = tableView.getColumnModel();
                    int columnViewIndex = colModel.getColumnIndexAtX(e.getX());
                    int columnModelIndex = tableView.convertColumnIndexToModel(columnViewIndex);
                    if (e.getClickCount() != 1 || columnModelIndex < 0 || SortableTableModel.this.getDataVector() == null || !tableView.isEnabled()) {
                        return;
                    }
                    if (sorter.sortedColumn != -1) {
                        int oldViewCol = tableView.convertColumnIndexToView(sorter.sortedColumn);
                        TableColumn column = colModel.getColumn(oldViewCol);
                        JLabel headerLabel = (JLabel)((Object)column.getHeaderRenderer());
                        if (headerLabel == null) {
                            headerLabel = new TableHeaderRenderer();
                            column.setHeaderRenderer((TableCellRenderer)((Object)headerLabel));
                        }
                        headerLabel.putClientProperty("cssClass", "sortableTableModelheaderLabel");
                        headerLabel.setIcon(null);
                    }
                    if (sorter.sortedColumn == columnModelIndex) {
                        sorter.sortTable(columnModelIndex, !sorter.isAscending);
                    } else {
                        sorter.sortTable(columnModelIndex, sorter.isAscending);
                    }
                    TableColumn column = colModel.getColumn(columnViewIndex);
                    JLabel headerLabel = (JLabel)((Object)column.getHeaderRenderer());
                    if (headerLabel == null) {
                        headerLabel = new TableHeaderRenderer();
                        column.setHeaderRenderer((TableCellRenderer)((Object)headerLabel));
                    }
                    headerLabel.putClientProperty("cssClass", "sortableTableModelheaderLabel");
                    int[] rows = tableView.getSelectedRows();
                    ArrayList<TableRow> selectedRows = new ArrayList<TableRow>(rows.length);
                    for (int line : rows) {
                        selectedRows.add(sorter.getRow(line));
                    }
                    tableView.clearSelection();
                    for (int i = 0; i < sorter.getRowCount(); ++i) {
                        TableRow row = sorter.getRow(i);
                        if (!selectedRows.contains(row)) continue;
                        tableView.addRowSelectionInterval(i, i);
                    }
                    if (sorter.isAscending) {
                        headerLabel.setIcon(upIcon);
                    } else {
                        headerLabel.setIcon(downIcon);
                    }
                    AjaxSwingCommonUtil.executeIfWebConsoleIsRunning(() -> ClientAgent.getCurrentInstance().getHTMLPage().setComponentDirty((Component)tableView, true));
                    tableView.getTableHeader().repaint();
                    SortableTableModel.this.fireTableDataChanged();
                }
            };
            th.addMouseListener(listMouseListener);
            this.tableHeaderMouseListenerMap.put(th, listMouseListener);
        }
    }

    public static class RowComparator
    implements Comparator<Object> {
        protected CustomTableModel model;
        protected int column;
        protected boolean ascending;
        private boolean isCaseSensitive;

        public RowComparator(CustomTableModel model, int column, boolean ascending, boolean isCaseSensitive) {
            this.model = model;
            this.column = column;
            this.ascending = ascending;
            this.isCaseSensitive = isCaseSensitive;
        }

        @Override
        public int compare(Object row1, Object row2) {
            int ret = this.compareInternal(row1, row2);
            if (!this.ascending) {
                ret = -ret;
            }
            return ret;
        }

        public int compareInternal(Object row1, Object row2) {
            Object o2;
            Object o1;
            if (row1 == null && row2 == null) {
                return 0;
            }
            if (row1 == null) {
                return -1;
            }
            if (row2 == null) {
                return 1;
            }
            if (row1 instanceof TimeTableRow) {
                o1 = ((TimeTableRow)row1).getSortValueAt(this.model.convertToRowIndex(this.column));
                o2 = ((TimeTableRow)row2).getSortValueAt(this.model.convertToRowIndex(this.column));
            } else {
                o1 = ((TableRow)row1).getValueAt(this.model.convertToRowIndex(this.column));
                o2 = ((TableRow)row2).getValueAt(this.model.convertToRowIndex(this.column));
            }
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Class<?> type = row1 instanceof TimeTableRow ? o1.getClass() : this.model.getColumnValueType(this.column);
            try {
                if (type != null && type.getSuperclass() == Number.class) {
                    double v1 = 0.0;
                    double v2 = 0.0;
                    try {
                        v1 = ((Number)o1).doubleValue();
                        v2 = ((Number)o2).doubleValue();
                    }
                    catch (ClassCastException e) {
                        if (o1 instanceof String) {
                            String regex = "\\d+";
                            Matcher m1 = Pattern.compile(regex).matcher((String)o1);
                            Matcher m2 = Pattern.compile(regex).matcher((String)o2);
                            if (m1.find() && m2.find()) {
                                v1 = Double.parseDouble(m1.group());
                                v2 = Double.parseDouble(m2.group());
                            }
                            return this.compareAsDefaultType(o1, o2);
                        }
                        return this.compareAsDefaultType(o1, o2);
                    }
                    if (v1 < v2) {
                        return -1;
                    }
                    if (v1 > v2) {
                        return 1;
                    }
                    return 0;
                }
                if (type == Date.class) {
                    long v2;
                    long v1;
                    try {
                        v1 = DateFormat.getInstance().parse((String)o1).getTime();
                        v2 = DateFormat.getInstance().parse((String)o2).getTime();
                    }
                    catch (ClassCastException e) {
                        v1 = ((Date)o1).getTime();
                        v2 = ((Date)o2).getTime();
                    }
                    catch (ParseException e) {
                        v1 = UIUtilities.parseDate((String)o1).getTime();
                        v2 = UIUtilities.parseDate((String)o2).getTime();
                    }
                    if (v1 < v2) {
                        return -1;
                    }
                    if (v1 > v2) {
                        return 1;
                    }
                    return 0;
                }
                if (type == String.class) {
                    int result = 0;
                    result = this.stringCompare((String)o1, (String)o2, this.isCaseSensitive);
                    if (result < 0) {
                        return -1;
                    }
                    if (result > 0) {
                        return 1;
                    }
                    return 0;
                }
                if (type == Boolean.class) {
                    boolean v2;
                    boolean v1 = (Boolean)o1;
                    if (v1 == (v2 = ((Boolean)o2).booleanValue())) {
                        return 0;
                    }
                    if (v1) {
                        return 1;
                    }
                    return -1;
                }
                if (type == JLabel.class) {
                    String s2;
                    String s1 = ((JLabel)o1).getText();
                    int result = this.stringCompare(s1, s2 = ((JLabel)o2).getText(), this.isCaseSensitive);
                    if (result < 0) {
                        return -1;
                    }
                    if (result > 0) {
                        return 1;
                    }
                    return 0;
                }
                if (Comparable.class.isAssignableFrom(type)) {
                    return ((Comparable)o1).compareTo(o2);
                }
                return this.compareAsDefaultType(o1, o2);
            }
            catch (ClassCastException | ParseException e) {
                return this.compareAsDefaultType(o1, o2);
            }
        }

        private int compareAsDefaultType(Object o1, Object o2) {
            String v1 = o1.toString();
            String v2 = o2.toString();
            int result = 0;
            result = this.stringCompare(v1, v2, this.isCaseSensitive);
            if (result < 0) {
                return -1;
            }
            if (result > 0) {
                return 1;
            }
            return 0;
        }

        private int stringCompare(String source, String target, boolean isCaseSensitive) {
            Locale locale = Locale.getDefault();
            String language = locale.getLanguage();
            if ("en".equalsIgnoreCase(language)) {
                if (isCaseSensitive) {
                    return source.compareTo(target);
                }
                return source.compareToIgnoreCase(target);
            }
            Collator collator = Collator.getInstance();
            if (isCaseSensitive) {
                collator.setStrength(2);
            } else {
                collator.setStrength(1);
            }
            return collator.compare(source, target);
        }
    }
}

