/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.util.LoggerUtilities;
import java.io.Serializable;
import java.util.Comparator;

public class SoftwarePackageObjectComparator
implements Comparator<SoftwarePackageObject>,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final int WINPLATFORM = 1;
    public static final int MACPLATFORM = 0;
    public static final int SAV = 1;
    public static final int SNAC = 0;

    @Override
    public int compare(SoftwarePackageObject package1, SoftwarePackageObject package2) {
        int rs = this.compareMajorVersion(package1, package2);
        if (rs != 0) {
            return rs;
        }
        rs = this.comparePlatform(package1, package2);
        if (rs != 0) {
            return rs;
        }
        rs = this.comparePackageType(package1, package2);
        if (rs != 0) {
            return rs;
        }
        rs = this.compareMinorVersion(package1, package2);
        if (rs != 0) {
            return rs;
        }
        rs = package1.getName().compareTo(package2.getName());
        return rs;
    }

    private int comparePlatform(SoftwarePackageObject package1, SoftwarePackageObject package2) {
        int platform1 = this.calPlatformID(package1.getPackagePlatformString());
        int platform2 = this.calPlatformID(package2.getPackagePlatformString());
        return platform1 - platform2;
    }

    private int comparePackageType(SoftwarePackageObject package1, SoftwarePackageObject package2) {
        int packageType1 = this.calPackageType(package1.getPackageType());
        int packageType2 = this.calPackageType(package2.getPackageType());
        return packageType1 - packageType2;
    }

    private int calPackageType(int type) {
        if (105 == type || 200 == type || 201 == type) {
            return 1;
        }
        return 0;
    }

    private int calPlatformID(String platform) {
        int id = 0;
        id = platform.equalsIgnoreCase("WIN32BIT") || platform.equalsIgnoreCase("WIN64BIT") ? 1 : 0;
        return id;
    }

    private int compareMajorVersion(SoftwarePackageObject package1, SoftwarePackageObject package2) {
        int rs = 0;
        String[] version1 = package1.getVersion(true).split("\\.");
        String[] version2 = package2.getVersion(true).split("\\.");
        for (int index = 0; index < 2; ++index) {
            int v1 = 0;
            int v2 = 0;
            try {
                v1 = Integer.parseInt(version1[index]);
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            try {
                v2 = Integer.parseInt(version2[index]);
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            int n = v1 > v2 ? 1 : (rs = v1 < v2 ? -1 : 0);
            if (rs == 0) continue;
            return rs;
        }
        return rs;
    }

    private int compareMinorVersion(SoftwarePackageObject package1, SoftwarePackageObject package2) {
        int rs = 0;
        String[] version1 = package1.getVersion(true).split("\\.");
        String[] version2 = package2.getVersion(true).split("\\.");
        for (int index = 2; index < 4; ++index) {
            int v1 = 0;
            int v2 = 0;
            try {
                v1 = Integer.parseInt(version1[index]);
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            try {
                v2 = Integer.parseInt(version2[index]);
            }
            catch (Exception ex) {
                LoggerUtilities.logException((Throwable)ex);
            }
            int n = v1 > v2 ? 1 : (rs = v1 < v2 ? -1 : 0);
            if (rs == 0) continue;
            return rs;
        }
        return rs;
    }
}

