/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.logicobject.GenericTreeObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.renderer.CustomTreeCellRenderer;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class SideBarPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int BUTTON_TOP_INSETS = 0;
    PagePanel parentPanel;
    ButtonGroup buttonGroup = new ButtonGroup();
    List<SideBarButton> buttonList = new ArrayList<SideBarButton>();
    List<?> contentList;
    TreeItem currentSelection;
    SideBarButton selectedButton;
    boolean inputIsKeyBoard = false;
    int keySelectionDirection = 0;

    public SideBarPanel(PagePanel parent) {
        this.parentPanel = parent;
        this.setLayout(new GridBagLayout());
        this.putClientProperty("cssClass", "sideBarPanel");
    }

    public void setButtonList(List<?> contantList) {
        this.clearup();
        this.contentList = contantList;
        Iterator<?> it = contantList.iterator();
        this.selectedButton = null;
        this.currentSelection = null;
        while (it.hasNext()) {
            TreeItem cObj = (TreeItem)it.next();
            boolean showWinIcon = false;
            boolean showMacIcon = false;
            if (cObj instanceof GenericTreeObject) {
                showWinIcon = ((GenericTreeObject)cObj).isShowWinIcon();
                showMacIcon = ((GenericTreeObject)cObj).isShowMacIcon();
            }
            final SideBarButton button = new SideBarButton(cObj);
            button.setBackground(UIColorUtilities.SECONDARY_NAVIGATION_BACKGROUND);
            button.putClientProperty("cssClass", "sideBarPanelSideBarButton");
            button.addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    Object source = arg0.getSource();
                    SideBarPanel.this.selectedButton = (SideBarButton)source;
                    SideBarPanel.this.currentSelection = SideBarPanel.this.selectedButton.getButterItem();
                    SideBarPanel.this.parentPanel.setCurrentSelection(SideBarPanel.this.currentSelection);
                }
            });
            button.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        button.doClick();
                        if (SideBarPanel.this.inputIsKeyBoard) {
                            SideBarPanel.this.inputIsKeyBoard = false;
                        }
                    }
                }
            });
            button.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    SideBarPanel.this.inputIsKeyBoard = true;
                    if (e.getKeyCode() == 37 || e.getKeyCode() == 38) {
                        SideBarPanel.this.keySelectionDirection = -1;
                    } else if (e.getKeyCode() == 39 || e.getKeyCode() == 40) {
                        SideBarPanel.this.keySelectionDirection = 1;
                    }
                }
            });
            this.addButton(button, showWinIcon, showMacIcon);
        }
        if (this.buttonList.size() > 0) {
            if (this.buttonList.size() == 1) {
                this.buttonList.get(0).addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        if (e.getKeyCode() == 37 || e.getKeyCode() == 38 || e.getKeyCode() == 39 || e.getKeyCode() == 40) {
                            e.consume();
                        }
                    }
                });
            } else {
                this.buttonList.get(0).addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        SideBarPanel.this.inputIsKeyBoard = true;
                        if (e.getKeyCode() == 37 || e.getKeyCode() == 38) {
                            e.consume();
                        } else if (e.getKeyCode() == 39 || e.getKeyCode() == 40) {
                            SideBarPanel.this.keySelectionDirection = 1;
                        }
                    }
                });
                this.buttonList.get(this.buttonList.size() - 1).addKeyListener(new KeyAdapter(){

                    @Override
                    public void keyPressed(KeyEvent e) {
                        SideBarPanel.this.inputIsKeyBoard = true;
                        if (e.getKeyCode() == 37 || e.getKeyCode() == 38) {
                            SideBarPanel.this.keySelectionDirection = -1;
                        } else if (e.getKeyCode() == 39 || e.getKeyCode() == 40) {
                            e.consume();
                        }
                    }
                });
            }
        }
    }

    public List<?> getCurrentContentList() {
        return this.contentList;
    }

    private void clearup() {
        this.removeAll();
        this.buttonGroup = new ButtonGroup();
        this.buttonList.clear();
    }

    public TreeItem getCurrentSelection() {
        return this.currentSelection;
    }

    public SideBarButton getSelectedButton() {
        return this.selectedButton;
    }

    public void setCurrentObject(TreeItem newObj) {
        if (this.currentSelection != newObj) {
            this.selectedButton.treeItem = newObj;
        }
    }

    private void addButton(SideBarButton button, boolean showWinIcon, boolean showMacIcon) {
        this.buttonGroup.add(button);
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridheight = 1;
        cons.gridwidth = 0;
        cons.anchor = 17;
        cons.fill = 2;
        cons.insets = new Insets(0, 0, 0, 0);
        cons.weightx = 1.0;
        this.add((Component)button, cons);
        this.buttonList.add(button);
    }

    public void selectIndex(int index) {
        if (index < 0) {
            index = 0;
        }
        if (!this.isEmpty()) {
            SideBarButton button = this.buttonList.get(index);
            button.doClick();
        }
    }

    public boolean isEmpty() {
        return this.buttonList.isEmpty();
    }

    public void refreshCurrentButton() {
        this.selectedButton.setText(this.currentSelection.getName());
        this.selectedButton.setIcon(CustomTreeCellRenderer.getIcon(this.currentSelection));
    }

    public static class SideBarButton
    extends JRadioButton {
        private static final long serialVersionUID = 1L;
        TreeItem treeItem;

        SideBarButton(TreeItem item) {
            this.treeItem = item;
            Icon icon = CustomTreeCellRenderer.getIcon(this.treeItem);
            this.setIcon(icon);
            this.setIconTextGap(10);
            this.putClientProperty("cssClass", "SideBarPAnelSideBarButton");
        }

        @Override
        public String getUIClassID() {
            return "SideBarButtonUI";
        }

        TreeItem getButterItem() {
            return this.treeItem;
        }

        @Override
        public String getText() {
            if (this.treeItem != null) {
                return this.treeItem.getName();
            }
            return super.getText();
        }
    }
}

