/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.creamtec.ajaxswing.support.FileOpener;
import com.creamtec.sepm.ajaxswing.support.ComponentUtils;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.AdminObject;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.ui.admin.AdminPanel;
import com.sygate.scm.console.ui.client.EndTaskActionsPopupMenu;
import com.sygate.scm.console.ui.client.EndTaskUsersPopupMenu;
import com.sygate.scm.console.ui.policy.ScheduledScanTaskPopupMenu;
import com.sygate.scm.console.ui.server.ServersPanel;
import com.sygate.scm.console.ui.util.PagePanel;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.TaskPanel;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.StringUtilities;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JToggleButton;

public class SideBar
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static Icon actionIcon = null;
    private JLabel viewPaneTitle;
    private JLabel taskPaneTitle;
    private JPanel viewPane = new JPanel();
    private JPanel taskPane = new JPanel();
    protected PagePanel pagePanel;
    private ButtonGroup taskGroup;
    private EndTaskActionsPopupMenu endtaskPopup;
    private EndTaskUsersPopupMenu userTaskPopup;
    private ScheduledScanTaskPopupMenu scheduledScanTaskPopup;
    private JPanel serverPanel;

    public SideBar(PagePanel pagePanel, String titleView, String titleTask) {
        this(pagePanel, titleView, titleTask, true);
    }

    protected SideBar(PagePanel pagePanel, String titleView, String titleTask, boolean isInit) {
        this(pagePanel, titleView, titleTask, isInit, null);
    }

    protected SideBar(PagePanel pagePanel, String titleView, String titleTask, JPanel serverPanel) {
        this(pagePanel, titleView, titleTask, true, serverPanel);
    }

    protected SideBar(PagePanel pagePanel, String titleView, String titleTask, boolean isInit, JPanel serverPanel) {
        this.pagePanel = pagePanel;
        this.viewPaneTitle = new JLabel(titleView);
        this.taskPaneTitle = new JLabel(titleTask);
        this.serverPanel = serverPanel;
        this.setBackground(UIColorUtilities.SECONDARY_NAVIGATION_BACKGROUND);
        if (isInit) {
            this.initialize();
        }
    }

    public void updateViews(JComponent view) {
        this.viewPane.removeAll();
        this.viewPane.add((Component)view, "North");
        this.revalidate();
    }

    public void updateViews() {
    }

    public void updateTasks() {
    }

    public void updateViewsPaneTitle(String title) {
        this.viewPaneTitle.setText(title);
    }

    public void updateTasksPaneTitle(String title) {
        this.taskPaneTitle.setText(title);
    }

    public void updateTasks(String pageName, List<List<TaskObject>> tasksList) {
        this.taskGroup = new ButtonGroup();
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(this.getBackground());
        int y = 0;
        boolean hasTasks = false;
        for (int i = 0; i < tasksList.size(); ++i) {
            List<TaskObject> taskList = tasksList.get(i);
            for (int j = 0; j < taskList.size(); ++j) {
                hasTasks = true;
                TaskObject task = taskList.get(j);
                TaskButton taskButton = new TaskButton(task);
                if (task.getFileOpener() != null) {
                    ComponentUtils.setFileOpener((JComponent)taskButton, (FileOpener)task.getFileOpener());
                }
                UIUtilities.setName(taskButton, pageName, UIUtilities.ComponentType.BUTTON, "taskIndex_" + (Serializable)(StringUtilities.isEmpty((String)task.getAutomationLabel()) ? Integer.valueOf(task.getTaskIndex()) : task.getAutomationLabel()));
                panel.add((Component)taskButton, new GridBagConstraints(0, y++, 1, 1, 1.0, 0.0, 17, 2, new Insets(0, 0, 0, 0), 0, 0));
            }
        }
        this.taskPaneTitle.setVisible(hasTasks);
        this.taskPane.removeAll();
        this.taskPane.setLayout(new BorderLayout(0, 0));
        this.taskPane.add((Component)panel, "North");
        this.revalidate();
    }

    public void updateTasks(List<List<TaskObject>> tasksList) {
        this.updateTasks("", tasksList);
    }

    protected void initialize() {
        this.setLayout(new GridBagLayout());
        if (this.serverPanel == null) {
            this.add((Component)this.getViewPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.getTaskPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
        } else {
            double weightView = 0.654;
            double weightTask = 0.346;
            if (LicenseObject.getInstance().isSBProduct()) {
                AdminObject admin = AdminObject.retrieveCurrentAdminObject();
                weightView = 0.55;
                weightTask = 0.45;
                if (admin.isSysAdmin()) {
                    weightView = 0.624;
                    weightTask = 0.376;
                }
            }
            this.add((Component)this.getViewPanel(), new GridBagConstraints(0, 0, 1, 1, 1.0, weightView, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.getTaskPanel(), new GridBagConstraints(0, 1, 1, 1, 1.0, weightTask, 17, 1, new Insets(0, 0, 0, 0), 0, 0));
            this.add((Component)this.serverPanel, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 15, 1, new Insets(0, 0, -1, 0), 0, 0));
        }
    }

    protected JPanel getViewPanel() {
        this.viewPane.setLayout(new BorderLayout(0, 0));
        this.viewPane.setBackground(this.getBackground());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(this.getBackground());
        this.viewPaneTitle.setFont(this.viewPaneTitle.getFont().deriveFont(1, 14.0f));
        this.viewPaneTitle.setForeground(UIColorUtilities.SECONDARY_NAVIGATION_FOREGROUND);
        this.viewPaneTitle.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 0));
        panel.add((Component)this.viewPaneTitle, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        panel.add((Component)this.viewPane, gbc);
        return panel;
    }

    protected JPanel getTaskPanel() {
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 2, new Insets(0, 0, 0, 0), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBackground(this.getBackground());
        this.taskPane.setLayout(new BorderLayout(0, 0));
        this.taskPane.setBackground(this.getBackground());
        this.taskPaneTitle.setFont(this.viewPaneTitle.getFont().deriveFont(1, 14.0f));
        this.taskPaneTitle.setForeground(UIColorUtilities.SECONDARY_NAVIGATION_FOREGROUND);
        this.taskPaneTitle.setBorder(BorderFactory.createEmptyBorder(10, 10, 5, 0));
        panel.add((Component)this.taskPaneTitle, gbc);
        ++gbc.gridy;
        gbc.fill = 1;
        gbc.weighty = 1.0;
        gbc.weightx = 1.0;
        panel.add((Component)this.taskPane, gbc);
        return panel;
    }

    public static Icon getActionIcon() {
        if (actionIcon == null) {
            actionIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.actionURL));
        }
        return actionIcon;
    }

    public void setEndTaskPopupMenu(EndTaskActionsPopupMenu popup1) {
        this.endtaskPopup = popup1;
    }

    public void setScheduledScanTaskPopupMenu(ScheduledScanTaskPopupMenu popup1) {
        this.scheduledScanTaskPopup = popup1;
    }

    public void setEndTaskUsersPopupMenu(EndTaskUsersPopupMenu popup1) {
        this.userTaskPopup = popup1;
    }

    private class SideBarButtonModel
    extends JToggleButton.ToggleButtonModel {
        private static final long serialVersionUID = 1L;
        private int taskIndex;
        private Object userObj;

        public SideBarButtonModel(int taskIndex, Object userObj) {
            this.taskIndex = taskIndex;
            this.userObj = userObj;
        }

        public int getTaskIndex() {
            return this.taskIndex;
        }

        public Object getUserObj() {
            return this.userObj;
        }
    }

    private class TaskButton
    extends JRadioButton {
        private static final long serialVersionUID = 1L;

        public TaskButton(TaskObject taskObj) {
            super(taskObj.getDisplayName(), taskObj.getIcon());
            this.setBackground(SideBar.this.getBackground());
            this.setModel(new SideBarButtonModel(taskObj.getTaskIndex(), taskObj.getUserObject()));
            SideBar.this.taskGroup.add(this);
            this.setIconTextGap(10);
            final EndTaskActionsPopupMenu popup = SideBar.this.endtaskPopup;
            final EndTaskUsersPopupMenu userPopup = SideBar.this.userTaskPopup;
            final int taskIndexInt = taskObj.getTaskIndex();
            if (taskObj.getTaskIndex() == 38) {
                if (popup != null) {
                    popup.setTargetComponet(this);
                }
            } else if (taskObj.getTaskIndex() == 39) {
                if (userPopup != null) {
                    userPopup.setTargetComponet(this);
                }
            } else if (taskObj.getTaskIndex() == 21 && SideBar.this.scheduledScanTaskPopup != null) {
                SideBar.this.scheduledScanTaskPopup.setTargetComponet(this);
            }
            this.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SideBarButtonModel model;
                    Cursor curCursor = Manager.getFrame().getCursor();
                    Manager.getFrame().setCursor(new Cursor(3));
                    PagePanel curPagePanel = SideBar.this.pagePanel;
                    if (SideBar.this.pagePanel instanceof AdminPanel) {
                        AdminPanel adminPanel = (AdminPanel)SideBar.this.pagePanel;
                        curPagePanel = adminPanel.getCurrentOutlookPanel();
                    }
                    if ((model = (SideBarButtonModel)SideBar.this.taskGroup.getSelection()) != null) {
                        ServersPanel.ServerTaskPane serverTaskPane;
                        TaskPanel taskPanel;
                        int taskIndex = model.getTaskIndex();
                        Object userObj = model.getUserObj();
                        Component rightComp = curPagePanel.getCurrentTaskPanel();
                        if (taskIndex == 38) {
                            if (popup != null) {
                                AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> TaskButton.this.add(popup));
                                popup.setPosition(TaskButton.this, rightComp);
                            }
                        } else if (taskIndex == 39) {
                            if (userPopup != null) {
                                AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> TaskButton.this.add(userPopup));
                                userPopup.setPosition(TaskButton.this, rightComp);
                            }
                        } else if (taskIndex == 21 && SideBar.this.scheduledScanTaskPopup != null) {
                            AjaxSwingCommonUtil.executeIfWebConsoleIsNotRunning(() -> TaskButton.this.add(SideBar.this.scheduledScanTaskPopup));
                            SideBar.this.scheduledScanTaskPopup.setPosition(TaskButton.this, rightComp);
                            SideBar.this.scheduledScanTaskPopup.setTaskPanel((TaskPanel)((Object)rightComp));
                            Manager.getFrame().setCursor(curCursor);
                            return;
                        }
                        if (rightComp instanceof TaskPanel) {
                            ((TaskPanel)((Object)rightComp)).executeTask(taskIndex, userObj);
                        } else if (rightComp instanceof ServersPanel.ServerTaskPane && (taskPanel = (serverTaskPane = (ServersPanel.ServerTaskPane)rightComp).getTaskPane()) != null) {
                            serverTaskPane.getTaskPane().executeTask(taskIndex, userObj);
                        }
                    }
                    Manager.getFrame().setCursor(curCursor);
                }
            });
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseEntered(MouseEvent e) {
                    TaskButton.this.setCursor(Cursor.getPredefinedCursor(12));
                    TaskButton.this.getModel().setRollover(true);
                    TaskButton.this.repaint();
                }

                @Override
                public void mouseExited(MouseEvent e) {
                    TaskButton.this.getModel().setRollover(false);
                    TaskButton.this.repaint();
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (taskIndexInt == 38) {
                        if (popup != null) {
                            popup.setPosition(e);
                        }
                    } else if (taskIndexInt == 39) {
                        if (userPopup != null) {
                            userPopup.setPosition(e);
                        }
                    } else if (taskIndexInt == 21 && SideBar.this.scheduledScanTaskPopup != null) {
                        SideBar.this.scheduledScanTaskPopup.setPosition(e);
                    }
                }
            });
            this.setEnabled(taskObj.isEnable());
            this.setToolTipText(taskObj.getToolTipText());
        }

        @Override
        public String getUIClassID() {
            return "SideBarTaskButtonUI";
        }
    }
}

