/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.schema.PrivateInsightServer;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.StringUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.Arrays;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ServerPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final String HTTPS_PREFIX = "https://";
    private static final String HTTP_PREFIX = "http://";
    private static final int DEFAULT_HTTP_PORT = 80;
    private static final int DEFAULT_HTTPS_PORT = 443;
    private static final String[] PROTOCOLS = new String[]{"https://", "http://"};
    private JComboBox<String> insightServerProtocol;
    private JTextField insightServerURL;
    private JTextField insightServerPort;
    private JCheckBox legacyClientSupportChk;
    private PrivateInsightServer privateInsightServer;

    public ServerPanel() {
        this.initialize();
    }

    private void initialize() {
        this.insightServerProtocol = new JComboBox<String>(PROTOCOLS);
        this.insightServerProtocol.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String selectedProtocol = (String)ServerPanel.this.insightServerProtocol.getSelectedItem();
                ServerPanel.this.updateDefaultPort(selectedProtocol);
            }
        });
        this.insightServerURL = new JTextField(new RestrictedPlainDocument(255), "", 30);
        this.insightServerPort = new JTextField(new NumberPlainDocument(1L, 65535L, true), "", 5);
        this.insightServerPort.setText(Integer.toString(443));
        this.legacyClientSupportChk = new JCheckBox(ServerPanel.getString("PrivateCloudPanel.legacyPrivateInsightServer"));
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        JLabel serverUrlLabel = new JLabel(ServerPanel.getString("ServerPanel.label.serverURL"));
        JLabel portLabel = new JLabel(ServerPanel.getString("ServerPanel.label.port"));
        GridBagConstraints gcd = new GridBagConstraints();
        gcd.insets = new Insets(5, 0, 5, 5);
        this.add((Component)serverUrlLabel, gcd);
        gcd.gridx = 1;
        this.add(this.insightServerProtocol, gcd);
        ++gcd.gridx;
        gcd.fill = 2;
        this.add((Component)this.insightServerURL, gcd);
        gcd.gridx = 0;
        gcd.gridy = 1;
        this.add((Component)portLabel, gcd);
        ++gcd.gridx;
        gcd.gridwidth = 2;
        this.add((Component)this.insightServerPort, gcd);
        ++gcd.gridy;
        this.add((Component)this.legacyClientSupportChk, gcd);
    }

    public void setObject(PrivateInsightServer server) {
        this.privateInsightServer = server;
        if (server == null) {
            server = new PrivateInsightServer();
        }
        this.insightServerURL.setText(server.getAddress());
        int protocol = server.getOptProtocol() == null ? server.getDefProtocol().intValue() : server.getOptProtocol().intValue();
        if (protocol == PrivateInsightServer.HTTPS) {
            this.insightServerProtocol.setSelectedIndex(Arrays.asList(PROTOCOLS).indexOf(HTTPS_PREFIX));
        } else {
            this.insightServerProtocol.setSelectedIndex(Arrays.asList(PROTOCOLS).indexOf(HTTP_PREFIX));
        }
        if (server.getPort() == null) {
            if (protocol == PrivateInsightServer.HTTPS) {
                this.insightServerPort.setText(Integer.toString(443));
            } else {
                this.insightServerPort.setText(Integer.toString(80));
            }
        } else {
            this.insightServerPort.setText(Integer.toString(server.getPort()));
        }
        if (server.getOptLegacyClientSupport() == null) {
            this.legacyClientSupportChk.setSelected(server.getDefLegacyClientSupport());
        } else {
            this.legacyClientSupportChk.setSelected(server.getOptLegacyClientSupport());
        }
    }

    public void save() {
        this.updateObject(this.privateInsightServer);
    }

    public void updateObject(PrivateInsightServer object) {
        String protocol = (String)this.insightServerProtocol.getSelectedItem();
        if (protocol.equals(HTTPS_PREFIX)) {
            object.setOptProtocol(PrivateInsightServer.HTTPS);
        } else if (protocol.equals(HTTP_PREFIX)) {
            object.setOptProtocol(PrivateInsightServer.HTTP);
        }
        String url = this.insightServerURL.getText();
        if (Utility.isValidIpv6Address((String)url)) {
            url = Utility.checkAndAddBrackets((String)url);
        }
        object.setAddress(url);
        object.setPort(Integer.valueOf(this.insightServerPort.getText()));
        object.setOptLegacyClientSupport(Boolean.valueOf(this.legacyClientSupportChk.isSelected()));
    }

    private static String getString(String propertyKey) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.policy.dialog.policydialog", propertyKey);
    }

    public void toggleServerForm(boolean enable) {
        this.insightServerProtocol.setEnabled(enable);
        this.insightServerURL.setEnabled(enable);
        this.insightServerPort.setEnabled(enable);
    }

    public void updateDefaultPort(String selectedProtocol) {
        if (selectedProtocol.equals(HTTPS_PREFIX)) {
            this.insightServerPort.setText(Integer.toString(443));
        } else {
            this.insightServerPort.setText(Integer.toString(80));
        }
    }

    public boolean isValidate() {
        if (this.insightServerURL.isEnabled() && this.insightServerPort.isEnabled()) {
            String serverAddress = this.insightServerURL.getText().trim();
            String port = this.insightServerPort.getText().trim();
            if (StringUtilities.isEmpty((String)serverAddress)) {
                UIUtilities.showErrorDialog(ServerPanel.getString("ServerPanel.error.serverSettingServerCannotBeEmpty"));
                this.insightServerURL.requestFocus();
                return false;
            }
            if (StringUtilities.isEmpty((String)port)) {
                UIUtilities.showErrorDialog(ServerPanel.getString("ServerPanel.error.serverSettingPortCannotBeEmpty"));
                this.insightServerURL.requestFocus();
                return false;
            }
            if (!StringUtilities.isEmpty((String)serverAddress) && StringUtilities.isEmpty((String)port)) {
                UIUtilities.showErrorDialog(ServerPanel.getString("ServerPanel.error.PortCannotBeEmpty"));
                this.insightServerPort.requestFocus();
                return false;
            }
            if (serverAddress.startsWith(HTTP_PREFIX) || serverAddress.startsWith(HTTPS_PREFIX)) {
                UIUtilities.showErrorDialog(ServerPanel.getString("ServerPanel.error.InvalidURL"));
                this.insightServerURL.requestFocus();
                return false;
            }
            if (!Utility.isValidIPAddressOrHostName((String)serverAddress, (boolean)false)) {
                UIUtilities.showErrorDialog(ServerPanel.getString("ServerPanel.error.invalidIPorServerAddress"));
                this.insightServerURL.requestFocus();
                return false;
            }
            if (StringUtilities.isLocalHostAddress((String)serverAddress)) {
                String msg = MessageFormat.format(ServerPanel.getString("HostAddressDlg.cannotAddLocalHost"), serverAddress);
                JOptionPane.showMessageDialog(Manager.getFrame(), msg, ServerPanel.getString("HostAddressDlg.error"), 0);
                return false;
            }
        }
        return true;
    }

    public String getServerAddress() {
        return this.insightServerURL.getText().trim();
    }
}

