/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.schema.SemServerList;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.SoftwarePackageHandler;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.util.ArrayList;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class ServerListComboBox
extends JComboBox<Object> {
    private static final long serialVersionUID = 1L;

    public ServerListComboBox() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setRenderer(new ServerListRenderer(this));
    }

    public void initWithDefaultSL() throws Exception {
        ArrayList<SemServerList> listServerLists = SoftwarePackageHandler.getServerList(true);
        this.init(listServerLists, true);
    }

    public void init(ArrayList<SemServerList> listSemServerLists, boolean allowEmptyServerList) {
        int len = listSemServerLists == null ? 0 : listSemServerLists.size();
        for (int i = 0; i < len; ++i) {
            SemServerList list = listSemServerLists.get(i);
            if (list == null) continue;
            this.addItem(list);
        }
        if (allowEmptyServerList) {
            this.addItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ServerListComboBox.donotConnectServer"));
        }
    }

    public SemServerList getSelectedSemServerList() {
        Object o = this.getSelectedItem();
        if (o == null || !(o instanceof SemServerList)) {
            return null;
        }
        return (SemServerList)o;
    }

    public boolean setSelectedServerListId(String id) {
        ComboBoxModel model = this.getModel();
        if (id != null && id.length() > 0) {
            for (int i = 0; i < model.getSize(); ++i) {
                Object o = model.getElementAt(i);
                if (o == null) continue;
                if (!(o instanceof SemServerList)) {
                    System.out.println("ServerListComboBox>> setSelectedServerListId: i=" + i + ", class=" + o.getClass().getName());
                    continue;
                }
                SemServerList serverList = (SemServerList)o;
                if (!serverList.getId().equals(id)) continue;
                this.setSelectedIndex(i);
                return true;
            }
        }
        return true;
    }

    private static class ServerListRenderer
    implements ListCellRenderer<Object> {
        JComboBox<Object> box = null;
        private BasicComboBoxRenderer renderer = new BasicComboBoxRenderer();

        public ServerListRenderer(JComboBox<Object> box) {
            this.box = box;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean hasFocus) {
            boolean listEnabled = this.box.isEnabled();
            this.renderer.setEnabled(listEnabled);
            String text = "";
            if (value != null) {
                if (value instanceof String) {
                    text = (String)value;
                } else if (value instanceof SemServerList) {
                    SemServerList semServerList = (SemServerList)value;
                    text = semServerList.getName();
                }
            }
            this.renderer.setText(text);
            this.renderer.setBackground(isSelected ? UIManager.getColor("List.selectionBackground") : list.getBackground());
            return this.renderer;
        }
    }
}

