/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.util.ConsoleLogger;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;

public class SearchableComboBox<E>
extends JComboBox<E> {
    private static final long serialVersionUID = 1L;
    private boolean isUpdating = false;
    private boolean isCaseSensetive = false;
    private boolean isFilterEnabled = false;
    private transient Vector<E> allData = new Vector();

    public SearchableComboBox(Vector<E> data) {
        this(data, false, false);
    }

    public SearchableComboBox(Vector<E> data, boolean isCaseSensetive, boolean isFilterEnabled) {
        this.allData.addAll(data);
        this.setModel(new SearchableComboBoxModel(data));
        this.isCaseSensetive = isCaseSensetive;
        this.isFilterEnabled = isFilterEnabled;
        this.setEditable(true);
        this.initActions();
    }

    private void initActions() {
        this.getEditor().getEditorComponent().addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent e) {
                if (e.getKeyCode() != 40 && e.getKeyCode() != 38 && e.getKeyCode() != 10 && e.getKeyCode() != 27 && e.getKeyCode() != 37 && e.getKeyCode() != 39) {
                    ConsoleLogger.log("SearchableComboBox >> keyReleased, Key: " + KeyEvent.getKeyText(e.getKeyCode()));
                    SearchableComboBox.this.isUpdating = true;
                    SearchableComboBox.this.setPopupVisible(false);
                    if (SearchableComboBox.this.isFilterEnabled) {
                        ConsoleLogger.log("SearchableComboBox >> keyReleased, filterItems...");
                        SearchableComboBox.this.filterItems(SearchableComboBox.this.getEditor().getItem());
                    }
                    SearchableComboBox.this.setPopupVisible(true);
                    SearchableComboBox.this.isUpdating = false;
                }
            }
        });
    }

    @Override
    public void setEditable(boolean b) {
        super.setEditable(true);
    }

    public void resetFilter() {
        SearchableComboBoxModel model = (SearchableComboBoxModel)this.getModel();
        model.removeAllElements();
        model.addAll(this.allData);
    }

    protected void filterItems(Object itemObj) {
        SearchableComboBoxModel model = (SearchableComboBoxModel)this.getModel();
        if (null != itemObj) {
            model.removeAllElements();
            Object matchedItem = null;
            ConsoleLogger.log("SearchableComboBox >> filterItems, itemObj: " + itemObj.toString());
            for (E anObject : this.allData) {
                boolean matched;
                boolean toAdd;
                String anObjectStr = anObject.toString();
                String objStr = itemObj.toString().trim();
                if (!this.isCaseSensetive) {
                    anObjectStr = anObjectStr.toLowerCase();
                    objStr = objStr.toLowerCase();
                }
                boolean bl = toAdd = anObjectStr.indexOf(objStr) > -1;
                if (toAdd) {
                    model.addElement(anObject);
                }
                if (matched = anObjectStr.equals(objStr)) {
                    matchedItem = anObject;
                }
                ConsoleLogger.log("SearchableComboBox >> anObjectStr: " + anObjectStr + ", toAdd: " + toAdd + ", matched: " + matched);
            }
            model.setSelectedItem(matchedItem);
        }
    }

    @Override
    public void configureEditor(ComboBoxEditor anEditor, Object anItem) {
        if (this.isUpdating) {
            super.configureEditor(anEditor, anEditor.getItem());
        } else {
            super.configureEditor(anEditor, anItem);
        }
    }

    private class SearchableComboBoxModel
    extends DefaultComboBoxModel<E> {
        private static final long serialVersionUID = 1L;

        public SearchableComboBoxModel(Vector<E> data) {
            super(data);
        }

        @Override
        public void setSelectedItem(Object anObject) {
            if (SearchableComboBox.this.isUpdating) {
                super.setSelectedItem(null);
            } else {
                super.setSelectedItem(anObject);
            }
        }
    }
}

