/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.i18n.MessageResourcesFile;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ui.monitoring.dataquery.AgentHackTypeItem;
import com.sygate.scm.console.ui.monitoring.dataquery.AgentSecuritySeverityItem;
import com.sygate.scm.console.ui.monitoring.dataquery.TableCriteriaList;
import com.sygate.scm.console.ui.util.QueryPanelBase;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.TableColumnMap;
import com.sygate.scm.console.ui.util.renderer.DateCellEditor;
import com.sygate.scm.console.ui.util.renderer.IPCellEditor;
import com.sygate.scm.console.ui.util.renderer.NumberCellEditor;
import com.sygate.scm.console.ui.util.renderer.RevisionCellEditor;
import com.sygate.scm.console.ui.util.renderer.ToolTipComboBoxRenderer;
import com.sygate.scm.console.ui.util.renderer.UnitedNumberCellEditor;
import com.sygate.scm.util.query.DropdownItem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractCellEditor;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.PlainDocument;

public class SearchTable
extends StripesTable
implements ActionListener {
    private static final MessageResourcesFile MSGRES = new MessageResourcesFile("com.sygate.scm.console.ui.util.uiutil");
    private static final String strLIKE = MSGRES.getString("SearchTable.queryConditionLIKE");
    private static final long serialVersionUID = -2275496472271076631L;
    private static final String[] OP_COMMANDS = new String[]{" ", "=", "!=", ">", "<", ">=", "<=", strLIKE};
    private static final String[] ID_OP_COMMANDS = new String[]{" ", "=", "!=", strLIKE};
    private static final String[] DROPDOWN_COMMANDS = new String[]{" ", "=", "!="};
    private static final String[] OS_DROPDOWN_COMMANDS = new String[]{" ", "=", "!=", strLIKE};
    private static final String[] REVISION_TYPE_COMMANDS = new String[]{" ", "=", "!=", ">", "<", ">=", "<="};
    protected DefaultCellEditor searchCellEditor;
    private static final String[] GUP_TYPE_COMMANDS = new String[]{" ", "="};
    private static final String[] HV_TYPE_COMMANDS = new String[]{" ", "=", "!="};
    protected JComboBox<Object> searchFieldComboBox;
    protected JComboBox<String> opFieldComboBox;
    private final String[] EMPTY_ROW = new String[]{"", "", ""};
    private final List<String> searchFieldNameMap = new ArrayList<String>();

    public static String getOP_COMMANDSByIndex(int index) {
        int count_OP_COMMANDS = OP_COMMANDS.length;
        if (index < 0 || index > count_OP_COMMANDS - 1) {
            return null;
        }
        return OP_COMMANDS[index];
    }

    public static String getID_OP_COMMANDSByIndex(int index) {
        int count_ID_OP_COMMANDS = ID_OP_COMMANDS.length;
        if (index < 0 || index > count_ID_OP_COMMANDS - 1) {
            return null;
        }
        return ID_OP_COMMANDS[index];
    }

    public SearchTable(DefaultTableModel tableModel) {
        Dimension dimension = this.getPreferredScrollableViewportSize();
        dimension.height /= 8;
        this.setPreferredScrollableViewportSize(dimension);
        this.setModel(tableModel);
        tableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent ev) {
                if (ev.getColumn() == 0) {
                    SearchTable.this.actionPerformed(null);
                }
            }
        });
    }

    @Override
    public TableCellRenderer getCellRenderer(int row, int column) {
        return new TableCellRenderer(){

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                String columnName = SearchTable.this.getColumnName(column);
                JComponent box = QueryPanelBase.SEARCH_COLUMN_NAME.equals(columnName) ? new JComboBox<Object>(new Object[]{value}) : new JTextField(null == value ? "" : value.toString());
                if (isSelected) {
                    box.setBackground(UIColorUtilities.DEFAULT_SELECTION_BACKGROUND);
                } else {
                    box.setBackground(UIColorUtilities.DEFAULT_BACKGROUND);
                }
                return box;
            }
        };
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public int[] validateRows() {
        int[] result = new int[]{-1, -1};
        int row = this.getRowCount();
        Object objValue = null;
        Object objSearch = null;
        Object objOp = null;
        for (int i = 0; i < row; ++i) {
            boolean valueNotFilled;
            objSearch = this.getModel().getValueAt(i, 0);
            objOp = this.getModel().getValueAt(i, 1);
            objValue = this.getModel().getValueAt(i, 2);
            boolean searchNotFilled = String.valueOf(objSearch).trim().length() == 0 || "null".equalsIgnoreCase(String.valueOf(objSearch));
            boolean opNotFilled = String.valueOf(objOp).trim().length() == 0 || "null".equalsIgnoreCase(String.valueOf(objOp));
            boolean bl = valueNotFilled = String.valueOf(objValue).trim().length() == 0 || "null".equalsIgnoreCase(String.valueOf(objValue));
            if (!(!searchNotFilled || searchNotFilled && opNotFilled && valueNotFilled)) {
                result[0] = 0;
                result[1] = i;
                return result;
            }
            if (!(!opNotFilled || searchNotFilled && opNotFilled && valueNotFilled)) {
                result[0] = 1;
                result[1] = i;
                return result;
            }
            if (!valueNotFilled || searchNotFilled && opNotFilled && valueNotFilled) continue;
            result[0] = 2;
            result[1] = i;
            return result;
        }
        return result;
    }

    public RpcData getCriteria() {
        RpcData rpc = new RpcData();
        int row = this.getRowCount();
        Object objValue = null;
        Object objSearch = null;
        Object objOp = null;
        for (int i = 0; i < row; ++i) {
            objSearch = this.getModel().getValueAt(i, 0);
            objOp = this.getModel().getValueAt(i, 1);
            objValue = this.getModel().getValueAt(i, 2);
            if (objOp.equals(strLIKE)) {
                objOp = "LIKE";
            }
            if (objSearch.toString().trim().length() == 0 || objOp.toString().trim().length() == 0 || objValue.toString().trim().length() == 0) continue;
            ((TableColumnMap)objSearch).getValue(rpc, objOp, objValue);
        }
        return rpc;
    }

    public TableCellEditor getCellEditor(int row, int column) {
        this.setRowSelectionInterval(row, row);
        TableCellEditor eidtor = null;
        String columnName = this.getColumnName(column);
        if (QueryPanelBase.SEARCH_COLUMN_NAME.equals(columnName)) {
            eidtor = this.getSearchFieldCellEditor();
        } else if (QueryPanelBase.COMPARISON_COLUMN_NAME.equals(columnName)) {
            eidtor = this.getOpFieldCellEditor(row);
        } else if (QueryPanelBase.VALUE_COLUMN_NAME.equals(columnName)) {
            eidtor = this.getValueFieldCellEditor(row);
        }
        if (eidtor == null) {
            eidtor = this.getDefaultEditor(this.getColumnClass(column));
        }
        return eidtor;
    }

    public JComboBox<Object> getSearchFieldComboBox() {
        if (this.searchFieldComboBox == null) {
            this.searchFieldComboBox = new JComboBox();
            this.searchFieldComboBox.putClientProperty("dynamicEventsEnabled", true);
            this.searchFieldComboBox.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent ev) {
                    Object obj = SearchTable.this.searchFieldComboBox.getSelectedItem();
                    if (obj != null && obj instanceof TableColumnMap) {
                        TableColumnMap tcMap = (TableColumnMap)obj;
                        tcMap.onColumnSelected();
                    }
                }
            });
        }
        return this.searchFieldComboBox;
    }

    public void appendComboBoxItem(JComboBox<Object> comboBox, Object[] itemList) {
        if (comboBox != null) {
            for (int i = 0; i < itemList.length; ++i) {
                comboBox.addItem(itemList[i]);
            }
        }
    }

    protected DefaultCellEditor getSearchFieldCellEditor() {
        if (this.searchCellEditor == null) {
            this.searchCellEditor = new DefaultCellEditor(this.getSearchFieldComboBox());
        }
        return this.searchCellEditor;
    }

    protected DefaultCellEditor getOpFieldCellEditor(int row) {
        DefaultCellEditor opFieldCellEditor = null;
        Object obj = this.getModel().getValueAt(row, 0);
        if (obj != null && obj instanceof TableColumnMap) {
            switch (((TableColumnMap)obj).getType()) {
                case 5: {
                    this.opFieldComboBox = new JComboBox<String>(ID_OP_COMMANDS);
                    break;
                }
                case 13: {
                    this.opFieldComboBox = new JComboBox<String>(GUP_TYPE_COMMANDS);
                    break;
                }
                case 1: 
                case 7: {
                    this.opFieldComboBox = new JComboBox<String>(DROPDOWN_COMMANDS);
                    break;
                }
                case 14: {
                    this.opFieldComboBox = new JComboBox<String>(OS_DROPDOWN_COMMANDS);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    this.opFieldComboBox = new JComboBox<String>(REVISION_TYPE_COMMANDS);
                    break;
                }
                case 15: {
                    this.opFieldComboBox = new JComboBox<String>(HV_TYPE_COMMANDS);
                    break;
                }
                default: {
                    this.opFieldComboBox = new JComboBox<String>(OP_COMMANDS);
                }
            }
            this.opFieldComboBox.putClientProperty("dynamicEventsEnabled", true);
            opFieldCellEditor = new DefaultCellEditor(this.opFieldComboBox);
        }
        return opFieldCellEditor;
    }

    protected TableCellEditor getValueFieldCellEditor(int row) {
        Component com;
        AbstractCellEditor valueFieldCellEditor = null;
        JComboBox<Object> valComboBox = null;
        Object obj = this.getModel().getValueAt(row, 0);
        if (obj != null && obj instanceof TableColumnMap) {
            switch (((TableColumnMap)obj).getType()) {
                case 1: 
                case 15: 
                case 21: {
                    valComboBox = new JComboBox<DropdownItem>((DropdownItem[])((TableColumnMap)obj).getOptValue());
                    valComboBox.putClientProperty("dynamicEventsEnabled", true);
                    valueFieldCellEditor = new DefaultCellEditor(valComboBox);
                    break;
                }
                case 13: 
                case 30: {
                    valComboBox = new JComboBox<DropdownItem>((DropdownItem[])((TableColumnMap)obj).getOptValue());
                    valComboBox.putClientProperty("dynamicEventsEnabled", true);
                    valueFieldCellEditor = new DefaultCellEditor(valComboBox);
                    break;
                }
                case 6: 
                case 26: {
                    valComboBox = new JComboBox<AgentSecuritySeverityItem>((AgentSecuritySeverityItem[])((TableColumnMap)obj).getOptValue());
                    valComboBox.putClientProperty("dynamicEventsEnabled", true);
                    valueFieldCellEditor = new DefaultCellEditor(valComboBox);
                    break;
                }
                case 14: {
                    valComboBox = new JComboBox<Object>((Object[])((TableColumnMap)obj).getOptValue());
                    valComboBox.putClientProperty("dynamicEventsEnabled", true);
                    valComboBox.setEditable(true);
                    valueFieldCellEditor = new DefaultCellEditor(valComboBox);
                    break;
                }
                case 7: 
                case 27: {
                    valComboBox = new JComboBox<AgentHackTypeItem>((AgentHackTypeItem[])((TableColumnMap)obj).getOptValue());
                    valComboBox.putClientProperty("dynamicEventsEnabled", true);
                    valueFieldCellEditor = new DefaultCellEditor(valComboBox);
                    break;
                }
                case 3: 
                case 23: {
                    valueFieldCellEditor = new IPCellEditor();
                    break;
                }
                case 31: {
                    valueFieldCellEditor = new IPCellEditor();
                    break;
                }
                case 2: 
                case 22: {
                    valueFieldCellEditor = new DateCellEditor();
                    break;
                }
                case 8: 
                case 28: {
                    valueFieldCellEditor = new UnitedNumberCellEditor(TableCriteriaList.getUnitDropdown(), 1, (PlainDocument)((TableColumnMap)obj).getOptValue());
                    break;
                }
                case 4: 
                case 24: {
                    valueFieldCellEditor = new NumberCellEditor((PlainDocument)((TableColumnMap)obj).getOptValue());
                    break;
                }
                case 0: 
                case 5: 
                case 20: 
                case 25: {
                    valueFieldCellEditor = new DefaultCellEditor(new JTextField());
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    valueFieldCellEditor = new RevisionCellEditor();
                    break;
                }
                default: {
                    super.getCellEditor(row, 2);
                }
            }
            if (valComboBox != null) {
                valComboBox.setRenderer(new ToolTipComboBoxRenderer());
            }
        } else {
            valueFieldCellEditor = new DefaultCellEditor(new JTextField());
        }
        if (valueFieldCellEditor instanceof DefaultCellEditor && (com = ((DefaultCellEditor)valueFieldCellEditor).getComponent()) instanceof JTextField) {
            final JTextField tf = (JTextField)com;
            com.addFocusListener(new FocusListener(){
                private int selectedRow = 0;

                @Override
                public void focusGained(FocusEvent ev) {
                    this.selectedRow = SearchTable.this.getSelectedRow();
                }

                @Override
                public void focusLost(FocusEvent ev) {
                    SearchTable.this.getModel().setValueAt(tf.getText(), this.selectedRow, 2);
                }
            });
        }
        return valueFieldCellEditor;
    }

    public void mouseReleased(MouseEvent ev) {
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        int row;
        if (this.isEditing() && ev != null) {
            this.getCellEditor().stopCellEditing();
        }
        if ((row = this.getSelectedRow()) >= 0) {
            String searchFieldNewName;
            Object obj;
            String searchFieldName = null;
            if (row < this.searchFieldNameMap.size()) {
                searchFieldName = this.searchFieldNameMap.get(row);
            }
            if (this.getModel() != null && (obj = this.getModel().getValueAt(row, 0)) != null && (searchFieldNewName = obj.toString()) != null && !searchFieldNewName.equals(searchFieldName)) {
                this.getModel().setValueAt("", row, 1);
                this.getModel().setValueAt("", row, 2);
                this.searchFieldNameMap.add(row, searchFieldNewName);
            }
        }
        if (this.dataModel != null && this.dataModel instanceof QueryPanelBase.SearchTableModel) {
            this.searchFieldComboBox = this.getSearchFieldComboBox();
            int selectedIndex = this.searchFieldComboBox.getSelectedIndex();
            if (selectedIndex == 0 && row >= 0 && row != this.getRowCount() - 1) {
                ((QueryPanelBase.SearchTableModel)this.dataModel).removeRow(row);
                if (row < this.searchFieldNameMap.size()) {
                    this.searchFieldNameMap.remove(row);
                }
            } else if (selectedIndex != 0 && row >= 0 && row == this.getRowCount() - 1) {
                ((QueryPanelBase.SearchTableModel)this.dataModel).addRow(this.EMPTY_ROW);
            }
        }
    }
}

