/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.SGridBagConstraints;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class SGridBagLayoutPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    protected int m_Row = 0;
    protected GridBagLayout bag = new GridBagLayout();
    protected SGridBagConstraints constraints = new SGridBagConstraints();

    public SGridBagLayoutPanel() {
        this.setLayout(this.bag);
    }

    public void addComponent(Component comp) {
        if (comp == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
    }

    public void addComponentIndent(Component comp, int indentation) {
        this.addHorizontalComponents(Box.createHorizontalStrut(indentation), comp);
    }

    public void addComponent(Component comp, Insets insets) {
        if (comp == null || insets == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.constraints.insets = insets;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
    }

    public void addComponentEx(Component comp, Insets insets, int fill, int anchor, double weighty) {
        if (comp == null || insets == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.fill = fill;
        this.constraints.anchor = anchor;
        this.constraints.weightx = 1.0;
        this.constraints.weighty = weighty;
        this.constraints.insets = insets;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
    }

    public void addComponentFillHoriz(Component comp) {
        if (comp == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
    }

    public void addComponentFillBoth(Component comp) {
        if (comp == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
    }

    public void addComponentFillHoriz(Component comp, Insets insets) {
        if (comp == null || insets == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.constraints.insets = insets;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
    }

    public void addLabelAndComponent(String label, Component comp) {
        if (label == null || comp == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.fill = 3;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.weightx = 1.0;
        JLabel jlabel = new JLabel(label, 2);
        this.bag.setConstraints(jlabel, this.constraints);
        this.add(jlabel);
        this.constraints.gridx = 1;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
    }

    public JLabel addLabelAndComponent(String label, Component comp, char mnemonic) {
        if (label == null || comp == null) {
            return null;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.fill = 1;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.weightx = 1.0;
        JLabel jlabel = new JLabel(label, 2);
        jlabel.setVerticalAlignment(1);
        jlabel.setDisplayedMnemonic(mnemonic);
        jlabel.setLabelFor(comp);
        this.bag.setConstraints(jlabel, this.constraints);
        this.add(jlabel);
        this.constraints.gridx = 1;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
        return jlabel;
    }

    public JLabel addLabelAndComponentFillHoriz(String label, Component comp, String mnemonic) {
        if (mnemonic == null) {
            throw new IllegalArgumentException("Mnuemonic was null");
        }
        return this.addLabelAndComponentFillHoriz(label, comp, mnemonic.charAt(0));
    }

    public JLabel addLabelAndComponentFillHorizDisabled(String label, Component comp, String mnemonic) {
        if (mnemonic == null) {
            throw new IllegalArgumentException("Mnuemonic was null");
        }
        return this.addLabelAndComponentFillHorizDisabled(label, comp, mnemonic.charAt(0));
    }

    public JLabel addLabelAndComponentFillHoriz(String label, Component comp, char mnemonic) {
        if (label == null || comp == null) {
            return null;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.weightx = 1.0;
        JLabel jlabel = new JLabel(label, 2);
        jlabel.setDisplayedMnemonic(mnemonic);
        jlabel.setLabelFor(comp);
        this.bag.setConstraints(jlabel, this.constraints);
        this.add(jlabel);
        this.constraints.gridx = 1;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
        return jlabel;
    }

    public JLabel addLabelAndComponentFillHorizDisabled(String label, Component comp, char mnemonic) {
        if (label == null || comp == null) {
            return null;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.weightx = 1.0;
        JLabel jlabel = new JLabel(label, 2);
        jlabel.setDisplayedMnemonic(mnemonic);
        jlabel.setLabelFor(comp);
        jlabel.setEnabled(false);
        this.bag.setConstraints(jlabel, this.constraints);
        this.add(jlabel);
        this.constraints.gridx = 1;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
        return jlabel;
    }

    public JLabel addEmptyRow() {
        this.constraints.reset();
        this.constraints.gridx = 0;
        this.constraints.gridy = this.m_Row++;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        JLabel jlabel = new JLabel("           ", 2);
        this.bag.setConstraints(jlabel, this.constraints);
        this.add(jlabel);
        return jlabel;
    }

    public JLabel addEmptyRemainder() {
        this.constraints.reset();
        this.constraints.gridx = 0;
        this.constraints.gridy = this.m_Row++;
        this.constraints.gridwidth = 1;
        this.constraints.gridheight = 1;
        this.constraints.weighty = 1.0;
        this.constraints.fill = 1;
        this.constraints.anchor = 10;
        JLabel jlabel = new JLabel("           ", 2);
        this.bag.setConstraints(jlabel, this.constraints);
        this.add(jlabel);
        return jlabel;
    }

    public void addHorizontalComponents(Component comp1, Component comp2) {
        if (comp1 == null || comp2 == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.fill = 3;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.bag.setConstraints(comp1, this.constraints);
        this.add(comp1);
        this.constraints.gridx = 1;
        this.bag.setConstraints(comp2, this.constraints);
        this.add(comp2);
    }

    public void addHorizontalComponents(Component comp1) {
        if (comp1 == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row;
        this.constraints.fill = 3;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.bag.setConstraints(comp1, this.constraints);
        this.add(comp1);
    }

    public void addHorizontalComponentFillHoriz(Component comp) {
        if (comp == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
    }

    public void addHorizontalComponentInPrevRow(Component comp) {
        if (comp == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row > 0 ? --this.m_Row : 0;
        this.constraints.gridheight = 1;
        this.constraints.gridwidth = 0;
        this.constraints.anchor = 17;
        this.constraints.weightx = 1.0;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.bag.setConstraints(comp, this.constraints);
        this.add(comp);
        ++this.m_Row;
    }

    public void addComponents(Component comp1, Component comp2) {
        if (comp1 == null || comp2 == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.fill = 0;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.bag.setConstraints(comp1, this.constraints);
        this.add(comp1);
        this.constraints.gridx = 1;
        this.bag.setConstraints(comp2, this.constraints);
        this.add(comp2);
    }

    public void addComponentsFillHoriz(Component comp1, Component comp2) {
        if (comp1 == null || comp2 == null) {
            return;
        }
        this.constraints.reset();
        this.constraints.gridy = this.m_Row++;
        this.constraints.fill = 2;
        this.constraints.anchor = 17;
        this.constraints.insets = new Insets(2, 2, 2, 2);
        this.constraints.gridx = 0;
        this.bag.setConstraints(comp1, this.constraints);
        this.add(comp1);
        this.constraints.gridx = 1;
        this.bag.setConstraints(comp2, this.constraints);
        this.add(comp2);
    }
}

