/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.logicobject.RevisionObject;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import java.awt.Color;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class RevisionTextField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private static final String DATA_SEPARATOR = "/";
    private static final String REV_SEPARATOR = " r";
    private static final int YEAR_DEFAULT = 1;
    private static final int MONTH_DEFAULT = 1;
    private static final int DAY_DEFAULT = 1;
    private static final int REV_DEFAULT = 0;
    private JTextField monthField = new JTextField();
    private JTextField dayField = new JTextField();
    private JTextField yearField = new JTextField();
    private JTextField revField = new JTextField();
    private JLabel dot1 = new JLabel("/");
    private JLabel dot2 = new JLabel("/");
    private JLabel dot3 = new JLabel(" r");
    private RevisionObject revObj = null;

    public RevisionTextField() {
        this.monthField.setDocument(new NumberPlainDocument(1L, 12L, false));
        this.dayField.setDocument(new NumberPlainDocument(1L, 31L, false));
        this.yearField.setDocument(new NumberPlainDocument(1L, 9999L, false));
        this.revField.setDocument(new NumberPlainDocument(0L, 999L, false));
        this.monthField.setHorizontalAlignment(4);
        this.dayField.setHorizontalAlignment(4);
        this.yearField.setHorizontalAlignment(4);
        this.revField.setHorizontalAlignment(4);
        this.monthField.setBorder(null);
        this.dayField.setBorder(null);
        this.yearField.setBorder(null);
        this.revField.setBorder(null);
        this.setLayout(new BoxLayout(this, 2));
        this.setBorder(BorderFactory.createLoweredBevelBorder());
        this.setBackground(Color.white);
        this.add(this.monthField);
        this.add(this.dot1);
        this.add(this.dayField);
        this.add(this.dot2);
        this.add(this.yearField);
        this.add(this.dot3);
        this.add(this.revField);
        this.loadDefault();
    }

    @Override
    public void setToolTipText(String text) {
        super.setToolTipText(text);
        this.dayField.setToolTipText(text);
        this.monthField.setToolTipText(text);
        this.yearField.setToolTipText(text);
        this.revField.setToolTipText(text);
    }

    public RevisionObject getObject() {
        this.saveModel();
        return this.revObj;
    }

    public void setObject(RevisionObject obj) {
        if (obj != null) {
            this.revObj = obj;
            this.updateModel();
        }
    }

    private void loadDefault() {
        this.dayField.setText("  ");
        this.monthField.setText("  ");
        this.yearField.setText("    ");
        this.revField.setText("   ");
    }

    @Override
    public void setEnabled(boolean enable) {
        super.setEnabled(enable);
        this.dayField.setEnabled(enable);
        this.monthField.setEnabled(enable);
        this.yearField.setEnabled(enable);
        this.revField.setEnabled(enable);
        if (enable) {
            this.setBorder(BorderFactory.createLoweredBevelBorder());
        } else {
            this.setBorder(BorderFactory.createBevelBorder(1, Color.gray, Color.gray));
        }
    }

    @Override
    public void setBackground(Color newBackground) {
        super.setBackground(newBackground);
        if (this.monthField != null) {
            this.monthField.setBackground(newBackground);
        }
        if (this.dayField != null) {
            this.dayField.setBackground(newBackground);
        }
        if (this.yearField != null) {
            this.yearField.setBackground(newBackground);
        }
        if (this.revField != null) {
            this.revField.setBackground(newBackground);
        }
    }

    private void saveModel() {
        if (this.revObj == null) {
            this.revObj = new RevisionObject(this.getYear(), this.getMonth(), this.getDay(), this.getRev());
        } else {
            this.revObj.setValue(this.getYear(), this.getMonth(), this.getDay(), this.getRev());
        }
    }

    private void updateModel() {
        if (this.revObj != null) {
            this.yearField.setText(String.valueOf(this.revObj.getYear()));
            this.monthField.setText(String.valueOf(this.revObj.getMonth()));
            this.dayField.setText(String.valueOf(this.revObj.getDayOfMonth()));
            this.revField.setText(String.valueOf(this.revObj.getRev()));
        }
    }

    private int getYear() {
        return RevisionTextField.getIntegerField(this.yearField, 4, 1);
    }

    private int getMonth() {
        return RevisionTextField.getIntegerField(this.monthField, 2, 1);
    }

    private int getDay() {
        return RevisionTextField.getIntegerField(this.dayField, 2, 1);
    }

    private int getRev() {
        return RevisionTextField.getIntegerField(this.revField, 3, 0);
    }

    private static int getIntegerField(JTextField field, int maxdigit, int defaultValue) {
        String value = field.getText().trim();
        if (value.length() != 0) {
            if (value.length() > maxdigit) {
                value = value.substring(0, maxdigit);
            }
            try {
                return Integer.parseInt(value, 10);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }
}

