/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.monitoring.dialog.ResultTableExportDlg;
import com.sygate.scm.console.ui.util.NumberPlainDocument;
import com.sygate.scm.console.ui.util.ResultTableModel;
import com.sygate.scm.console.ui.util.StripesTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.UIText;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.SwingWorker;
import com.sygate.scm.util.TimeCounter;
import com.sygate.scm.util.Utility;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Observable;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ResultTablePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int PAGE_ROW_COUNT = 30;
    protected static final String CANT_EXPORT = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ResultTablePanel.msg.cantExport");
    private static final String CANT_DISPLAY_LOG = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ResultTablePanel.msg.cantDisplayLog");
    protected static final int PREVIOUS = 0;
    protected static final int NEXT = 1;
    protected static final int SELECT = 2;
    protected static final int FIRST = 3;
    protected static final int LAST = 4;
    protected JButton jBPrevious = new JButton(UIText.get(3844));
    protected JButton jBNext = new JButton(UIText.get(3332));
    protected JButton jBLast = new JButton();
    protected final JButton jBFirst = new JButton();
    protected final JTextField jTFPage = new JTextField();
    protected JLabel jLPage = new JLabel();
    protected JPanel southButtonPanel;
    protected ResultTableModel tableModel;
    protected JTable jTResult = new StripesTable(true, true);
    protected JScrollPane panel;
    protected Component glassPane;
    private boolean isTableHeaderListenerAdded = false;
    protected JPanel progressPanel = null;
    protected JPanel headerPanel = null;
    private transient Observable refreshHanlder;

    public ResultTablePanel(ResultTableModel model) {
        this(model, false);
    }

    protected ResultTablePanel(ResultTableModel model, boolean isInitialize) {
        this.tableModel = model;
        if (this.tableModel != null) {
            this.tableModel.addMouseListenerToHeaderInTable(this.jTResult);
            this.isTableHeaderListenerAdded = true;
        }
        if (isInitialize) {
            this.initialize();
        }
        this.glassPane = Manager.getFrame().getGlassPane();
        this.glassPane.setCursor(Cursor.getPredefinedCursor(3));
    }

    public void export() {
        int totalPage = this.getTableModel().getTotalPages();
        if (totalPage == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), CANT_EXPORT, MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ResultTablePanel.msg.error"), 0);
            return;
        }
        new ResultTableExportDlg(this.getTableModel());
    }

    public void clear() {
        if (this.tableModel != null) {
            this.tableModel.clearData();
        }
        this.resetPanel();
        this.disableProgressPanel();
    }

    public Observable getRefreshHanlder() {
        if (this.refreshHanlder == null) {
            this.refreshHanlder = new RefreshHandler();
        }
        return this.refreshHanlder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(String queryTable, String queryFilter) {
        try {
            int i;
            TimeCounter counter = new TimeCounter();
            TableColumnModel columnModel = this.jTResult.getColumnModel();
            int colNum = columnModel.getColumnCount();
            TableColumn[] columns = new TableColumn[colNum];
            for (i = 0; i < colNum; ++i) {
                columns[i] = columnModel.getColumn(i);
            }
            this.getTableModel().refresh(queryTable, queryFilter);
            ConsoleLogger.log("ResultTablePanel.refresh: " + counter.toStringEx2(true));
            this.resetPanel();
            if (colNum == columns.length) {
                for (i = 0; i < colNum; ++i) {
                    TableCellEditor editor;
                    TableCellRenderer renderer = columns[i].getCellRenderer();
                    if (renderer != null) {
                        columnModel.getColumn(i).setCellRenderer(renderer);
                    }
                    if ((editor = columns[i].getCellEditor()) == null) continue;
                    columnModel.getColumn(i).setCellEditor(editor);
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException exception) {
            ConsoleLogger.log("Warning: Omitted a ArrayIndexOutOfBoundsException");
        }
        catch (Exception ex) {
            ConsoleLogger.log("ResultTablePanel.refresh() got exception, e = ");
            LoggerUtilities.logException((Throwable)ex);
            String message = CANT_DISPLAY_LOG + ex.getMessage();
            if (!Env.isUnitTest()) {
                JOptionPane.showMessageDialog(Manager.getFrame(), message, MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ResultTablePanel.msg.error"), 0);
            }
        }
        finally {
            ((RefreshHandler)this.getRefreshHanlder()).handlerRefresh();
        }
    }

    protected void initialize() {
        this.setLayout(new BorderLayout());
        JPanel jp = new JPanel(new BorderLayout());
        this.add((Component)this.getPageHandlerPanel(), "North");
        jp.add(this.getResultTablePane());
        this.add((Component)jp, "Center");
        this.add((Component)this.getSouthButtonPane(), "South");
    }

    protected void setWestSide(JPanel panel) {
    }

    public void setTableMouseListener(MouseListener mouseListener) {
        if (this.jTResult != null) {
            this.jTResult.addMouseListener(mouseListener);
        }
    }

    protected void setSouthSide(JPanel southButtonPanel) {
    }

    protected void updateModelPage(int pageNumber) throws Exception {
        this.getTableModel().getPage(pageNumber, "", "");
    }

    protected ResultTableModel getTableModel() {
        return this.tableModel;
    }

    public JTable getTable() {
        return this.jTResult;
    }

    public void setTableModel(ResultTableModel newModel) {
        if (!this.isTableHeaderListenerAdded || this.tableModel != newModel) {
            this.tableModel = newModel;
            if (this.tableModel != null) {
                this.tableModel.addMouseListenerToHeaderInTable(this.jTResult);
                this.isTableHeaderListenerAdded = true;
            }
        }
        this.tableModel = newModel;
        this.jTResult.setModel(this.tableModel);
    }

    protected void resetPanel() {
        this.resetPanel(true);
    }

    protected void resetPanel(boolean resizeColumn) {
        if (resizeColumn) {
            this.resizeTableColumns();
        }
        this.setControls();
        this.setDisplayOfPageNumbers();
    }

    protected void jTResult_valueChanged() {
    }

    protected JPanel getSouthButtonPane() {
        if (this.southButtonPanel == null) {
            this.southButtonPanel = new JPanel();
            this.setSouthSide(this.southButtonPanel);
        }
        return this.southButtonPanel;
    }

    protected JPanel getPageHandlerPanel() {
        if (this.headerPanel == null) {
            this.headerPanel = new JPanel();
            this.headerPanel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
            this.headerPanel.setLayout(new BoxLayout(this.headerPanel, 1));
            this.headerPanel.add(this.getProgressPanel());
            this.headerPanel.add(Box.createVerticalStrut(2));
            this.headerPanel.add(this.getControlHandlerPanel());
            this.getProgressPanel().setVisible(false);
        }
        return this.headerPanel;
    }

    private JPanel getProgressPanel() {
        if (this.progressPanel == null) {
            this.progressPanel = new JPanel();
            this.progressPanel.setBorder(BorderFactory.createEmptyBorder(0, 0, 5, 0));
            this.progressPanel.setLayout(new BorderLayout());
            JProgressBar progressBar = new JProgressBar();
            progressBar.setIndeterminate(true);
            progressBar.setMinimum(0);
            progressBar.setMaximum(100);
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ResultTablePanel.msg.retrieveData");
            progressBar.setString(title);
            progressBar.setStringPainted(true);
            this.progressPanel.add((Component)progressBar, "Center");
        }
        return this.progressPanel;
    }

    private JPanel getControlHandlerPanel() {
        UIUtilities.fitJComponent(new JButton[]{this.jBPrevious, this.jBNext});
        this.jBPrevious.setEnabled(false);
        this.jBPrevious.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultTablePanel.this.glassPane.setVisible(true);
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        ResultTablePanel.this.getPage(0);
                        return null;
                    }

                    public void finished() {
                        ResultTablePanel.this.glassPane.setVisible(false);
                    }
                };
                worker.start();
            }
        });
        int height = this.jBPrevious.getPreferredSize().height;
        this.jTFPage.setEnabled(false);
        this.jTFPage.putClientProperty("ajaxswing.textfield.documentListener", Boolean.TRUE);
        this.jTFPage.setDocument(new NumberPlainDocument(Integer.MAX_VALUE, true));
        this.jTFPage.setPreferredSize(new Dimension(30, height));
        this.jTFPage.setMinimumSize(new Dimension(30, height));
        this.jTFPage.setMaximumSize(new Dimension(30, height));
        this.jTFPage.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultTablePanel.this.setCursor(Cursor.getPredefinedCursor(3));
                String pageNumber = ResultTablePanel.this.jTFPage.getText();
                if (pageNumber != null && pageNumber.trim().length() > 0) {
                    ResultTablePanel.this.getPage(2);
                }
                ResultTablePanel.this.setCursor(Cursor.getDefaultCursor());
            }
        });
        this.jBNext.setEnabled(false);
        this.jBNext.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                ResultTablePanel.this.glassPane.setVisible(true);
                SwingWorker worker = new SwingWorker(){

                    public Object construct() {
                        ResultTablePanel.this.getPage(1);
                        return null;
                    }

                    public void finished() {
                        ResultTablePanel.this.glassPane.setVisible(false);
                    }
                };
                worker.start();
            }
        });
        JPanel panel = new JPanel();
        panel.setBorder(BorderFactory.createEmptyBorder(5, 0, 5, 0));
        panel.setLayout(new BoxLayout(panel, 0));
        this.setWestSide(panel);
        panel.add(Box.createGlue());
        panel.add(this.jLPage);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.jBPrevious);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.jTFPage);
        panel.add(Box.createHorizontalStrut(5));
        panel.add(this.jBNext);
        return panel;
    }

    protected JScrollPane getResultTablePane() {
        Dimension size = this.jTResult.getPreferredScrollableViewportSize();
        this.jTResult.setPreferredScrollableViewportSize(new Dimension(size.width, (this.jTResult.getRowHeight() + this.jTResult.getRowMargin()) * 5 * 2));
        this.jTResult.setAutoResizeMode(0);
        this.jTResult.setSelectionMode(0);
        this.jTResult.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                ResultTablePanel.this.jTResult_valueChanged();
            }
        });
        this.jTResult.setModel(this.getTableModel());
        this.panel = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)this.panel, (JTable)this.jTResult);
        this.panel.setOpaque(false);
        this.panel.setPreferredSize(this.panel.getPreferredSize());
        return this.panel;
    }

    public JScrollPane getScrollPanel() {
        return this.panel;
    }

    protected void setControls() {
        int currentPage = this.getTableModel().getCurrentPage();
        ++currentPage;
        if (this.getTableModel() != null) {
            int pageCount = this.getTableModel().getTotalPages();
            this.jTFPage.setEnabled(pageCount > 1);
            this.jBPrevious.setEnabled(pageCount > 1 && currentPage > 1);
            this.jBNext.setEnabled(currentPage < pageCount);
            this.jTFPage.setText("");
        }
    }

    public void setDisplayWhenCountExceeds() {
        this.jBNext.setEnabled(true);
        this.jBPrevious.setEnabled(false);
        this.jBFirst.setEnabled(false);
        this.jBLast.setEnabled(false);
        this.jTFPage.setText("");
        this.jTFPage.setEnabled(false);
    }

    public void enableNext_PrevAndPage(boolean nextEnable, boolean prevEnable, boolean enablePage) {
        this.jBNext.setEnabled(nextEnable);
        this.jTFPage.setEnabled(enablePage);
        this.jBPrevious.setEnabled(prevEnable);
    }

    public void resizeTableColumns() {
        int prefferedWidth = 200;
        TableColumnModel columnModel = this.jTResult.getColumnModel();
        Enumeration<TableColumn> e = columnModel.getColumns();
        while (e.hasMoreElements()) {
            TableColumn col = e.nextElement();
            col.setPreferredWidth(prefferedWidth);
        }
    }

    protected int getPageNumberToDisplay(int action) {
        String enteredPageNumberString;
        int newPageNumber = this.getTableModel().getCurrentPage();
        int pageCount = this.getTableModel().getTotalPages();
        if (action == 2 && (enteredPageNumberString = this.jTFPage.getText()).trim().length() > 0) {
            return this.getSelectedPage(enteredPageNumberString);
        }
        if (action == 1) {
            ++newPageNumber;
        } else if (action == 0) {
            --newPageNumber;
        } else if (action == 4) {
            newPageNumber = this.getSelectedPage(String.valueOf(pageCount));
        } else if (action == 3) {
            newPageNumber = this.getSelectedPage("1");
        }
        return newPageNumber;
    }

    protected int getSelectedPage(String enteredPageNumberString) {
        int enteredPageNumber = Integer.parseInt(enteredPageNumberString);
        int newPageNumber = this.getTableModel().getCurrentPage();
        int pageCount = this.getTableModel().getTotalPages();
        if (enteredPageNumber <= 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ResultTablePanel.msg.invalidPageNumber"));
            return newPageNumber;
        }
        if (enteredPageNumber > pageCount) {
            enteredPageNumber = pageCount;
        }
        return --enteredPageNumber;
    }

    protected void clearPageNumberDisplay() {
        this.jLPage.setText("");
    }

    protected void setDisplayOfPageNumbers() {
        int currentPage = this.getTableModel().getCurrentPage() + 1;
        int totalPages = this.getTableModel().getTotalPages();
        if (totalPages == 0) {
            this.jLPage.setText("");
        } else {
            Object[] obj = new Object[]{Integer.toString(currentPage), Integer.toString(totalPages)};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ResultTablePanel.msg.pageOf");
            String fm = MessageFormat.format(str, obj);
            this.jLPage.setText(fm);
        }
    }

    protected void getPage(int action) {
        int pageNumber = 0;
        this.getTableModel().setIsFixedColumns(true);
        try {
            pageNumber = this.getPageNumberToDisplay(action);
            if (pageNumber < -1) {
                pageNumber = -1;
                this.getTableModel().setCurrentPage(pageNumber);
                this.jBPrevious.setEnabled(false);
                return;
            }
            this.updateModelPage(pageNumber);
            this.setDisplayOfPageNumbers();
            this.setControls();
            ConsoleLogger.log("Page Displayed" + Utility.getCalendarInstance().getTime());
        }
        catch (Exception ex) {
            Object[] obj = new Object[]{this.getDisplayedPageNumber(pageNumber), this.jTFPage.getText()};
            String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ResultTablePanel.msg.failedToDisplayTheData");
            String message = MessageFormat.format(str, obj);
            JOptionPane.showMessageDialog(Manager.getFrame(), message, "", 0);
            Object[] obj2 = new Object[]{Integer.toString(this.getTableModel().currentPage + 1), Integer.toString(this.getTableModel().getTotalPages())};
            String str2 = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ClientSearchResultPanel.msg.pageOf");
            String fm = MessageFormat.format(str2, obj2);
            if (this.getTableModel().currentPage == 0 && this.getTableModel().getTotalPages() == 0) {
                fm = "";
            }
            this.jTFPage.setText(fm);
        }
        this.getTableModel().setIsFixedColumns(false);
    }

    protected String getDisplayedPageNumber(int pageNumber) {
        return Integer.toString(pageNumber);
    }

    public void enableProgressPanel() {
        this.getProgressPanel().setVisible(true);
        this.refreshUI();
    }

    public void disableProgressPanel() {
        this.getProgressPanel().setVisible(false);
        this.refreshUI();
    }

    private void refreshUI() {
        for (Container parent = this.getParent(); parent != null; parent = parent.getParent()) {
            if (!(parent instanceof JDialog)) continue;
            ((JDialog)parent).pack();
            break;
        }
    }

    private class RefreshHandler
    extends Observable {
        private RefreshHandler() {
        }

        public void handlerRefresh() {
            this.setChanged();
            this.notifyObservers(ResultTablePanel.this);
        }
    }
}

