/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.util.ConsoleException;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class ResultTableModel
extends AbstractTableModel {
    private static final long serialVersionUID = 1L;
    protected String[] columnNames;
    protected CustomTableModel model;
    protected int currentPage = 0;
    public static final int MAX_PAGE_ROW_NUMBER = 30;
    private int maxPageRowNumber = 30;
    protected int totalPages;
    private boolean isFixedColumns = false;

    public ResultTableModel(CustomTableModel model) {
        this.model = model;
    }

    protected ResultTableModel() {
    }

    public void addMouseListenerToHeaderInTable(JTable table) {
        if (this.model != null && this.model instanceof SortableTableModel) {
            ((SortableTableModel)this.model).addMouseListenerToHeaderInTable(table);
        }
    }

    public void setColumnNames(String[] columnNames) {
        this.setColumnNames(columnNames, false);
    }

    public void setColumnNames(String[] columnNames, boolean showColumn) {
        String[] stringArray = this.columnNames = columnNames == null ? null : (String[])columnNames.clone();
        if (showColumn) {
            this.model.setColumnNames(this.columnNames);
            this.fireTableStructureChanged();
        }
    }

    public String[] getColumnNames() {
        return this.columnNames == null ? null : (String[])this.columnNames.clone();
    }

    @Override
    public int getColumnCount() {
        return this.model == null ? 0 : this.model.getColumnCount();
    }

    @Override
    public int getRowCount() {
        return this.model == null ? 0 : this.model.getRowCount();
    }

    @Override
    public Object getValueAt(int row, int column) {
        return this.model == null ? new Object() : this.model.getValueAt(row, column);
    }

    public Object getValueAt(Vector<TableRow> data, int row, int column) {
        return this.model == null ? new Object() : this.model.getValueAt(data, row, column);
    }

    @Override
    public String getColumnName(int column) {
        return this.model == null ? "" : this.model.getColumnName(column);
    }

    public void refresh(String queryTable, String queryFilter) throws ConsoleException {
        this.getPage(0, queryTable, queryFilter);
    }

    public void getPage(int pageNumber, String queryTable, String queryFilter) throws ConsoleException {
        this.getPage(pageNumber, queryTable, queryFilter, -1);
    }

    public void getPage(int pageNumber, String queryTable, String queryFilter, int calTotalPages) throws ConsoleException {
        this.currentPage = pageNumber;
        this.totalPages = calTotalPages < 0 ? this.calculateTotalPages(queryTable, queryFilter) : calTotalPages;
        this.resetData(this.getCurrentPage() * this.maxPageRowNumber, this.maxPageRowNumber, queryTable, queryFilter);
        if (this.isFixedColumns) {
            this.fireTableDataChanged();
        } else {
            this.fireTableStructureChanged();
        }
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public int getTotalPages() {
        return this.totalPages;
    }

    public Vector<TableRow> getData(int startRow, int count) {
        return this.getData(startRow, count, false);
    }

    public Vector<TableRow> getData(int startRow, int count, boolean isForExport) {
        return new Vector<TableRow>(0);
    }

    public void clearData() {
        if (this.model != null) {
            this.model.setDataVector(null);
        }
        this.totalPages = 0;
        this.fireTableDataChanged();
    }

    public void removeRow(int index) {
        if (this.model != null) {
            this.model.removeRow(index);
        }
    }

    public TableRow getRow(int index) {
        return this.model == null ? null : this.model.getRow(index);
    }

    public void setIsFixedColumns(boolean isFixedColumns) {
        this.isFixedColumns = isFixedColumns;
    }

    public synchronized int getMaxPageRowNumber() {
        return this.maxPageRowNumber;
    }

    public synchronized void setMaxPageRowNumber(int num) {
        this.maxPageRowNumber = num;
    }

    protected void resetData(int startRow, int count, String queryTable, String queryFilter) throws ConsoleException {
    }

    protected int getModelRowCount(String queryTable, String queryFilter) {
        return this.getRowCount();
    }

    protected int calculateTotalPages(String queryTable, String queryFilter) {
        int noOfPages = 0;
        int rowCount = this.getModelRowCount(queryTable, queryFilter);
        if (rowCount == 0) {
            return 0;
        }
        if (rowCount < this.maxPageRowNumber) {
            noOfPages = 1;
        } else {
            double fractionPages = (double)rowCount / (double)this.maxPageRowNumber;
            noOfPages = (int)Math.ceil(fractionPages);
            if (fractionPages > (double)noOfPages) {
                ++noOfPages;
            }
        }
        return noOfPages;
    }
}

