/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.creamtec.ajaxswing.support.validation.AjaxSwingDocumentValidator;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class RestrictedPlainDocument
extends PlainDocument
implements AjaxSwingDocumentValidator {
    private static final long serialVersionUID = 1L;
    public static final int MAX_CHAR = 255;
    private int maxCharacters;
    private boolean isAllDigit;
    private boolean allowChar = false;
    private String validator = null;
    private boolean isAllowHiAscii = true;

    public RestrictedPlainDocument(int maxChars) {
        this(maxChars, false);
    }

    public RestrictedPlainDocument(int maxChars, boolean isAllDigit) {
        this.maxCharacters = maxChars;
        this.isAllDigit = isAllDigit;
    }

    public RestrictedPlainDocument(int maxChars, String validator, boolean allowChar) {
        this.maxCharacters = maxChars;
        this.setValidator(validator, allowChar);
    }

    public void setValidator(String validator, boolean allowChar) {
        this.validator = validator;
        this.allowChar = allowChar;
    }

    public int getMaxCharNumber() {
        return this.maxCharacters;
    }

    public String getValidator() {
        return this.validator;
    }

    public boolean isAllowChar() {
        return this.allowChar;
    }

    public boolean isAllowHiAscii() {
        return this.isAllowHiAscii;
    }

    public void setAllowHiAscii(boolean isAllowHiAscii) {
        this.isAllowHiAscii = isAllowHiAscii;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null) {
            super.insertString(offs, null, a);
            return;
        }
        if (this.validator != null) {
            int i;
            char[] chars;
            if (this.allowChar) {
                chars = str.toCharArray();
                for (i = 0; i < chars.length; ++i) {
                    if (this.validator.indexOf(chars[i]) != -1) continue;
                    Toolkit.getDefaultToolkit().beep();
                    throw new BadLocationException(str, offs);
                }
            } else {
                chars = this.validator.toCharArray();
                for (i = 0; i < chars.length; ++i) {
                    if (str.indexOf(chars[i]) == -1) continue;
                    Toolkit.getDefaultToolkit().beep();
                    throw new BadLocationException(str, offs);
                }
            }
        }
        if (this.isAllDigit) {
            char[] source = str.toCharArray();
            char[] result = new char[source.length];
            int j = 0;
            for (int i = 0; i < result.length; ++i) {
                if (Character.isDigit(source[i])) {
                    result[j++] = source[i];
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
            }
            str = new String(result, 0, j);
        }
        if (!this.isAllowHiAscii) {
            // empty if block
        }
        if (this.getLength() + str.length() <= this.maxCharacters) {
            super.insertString(offs, str, a);
        } else {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public HashMap<String, Object> getParams() {
        HashMap<String, Object> validatorParams = new HashMap<String, Object>();
        validatorParams.put("name", "RestrictedPlainDocument");
        validatorParams.put("maxCharacters", this.maxCharacters);
        validatorParams.put("isAllDigit", this.isAllDigit);
        return validatorParams;
    }
}

