/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import java.awt.Toolkit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DocumentFilter;

public class RegexDocumentFilter
extends DocumentFilter {
    private Pattern pattern;

    public RegexDocumentFilter(String regex) {
        this.pattern = Pattern.compile(regex);
    }

    @Override
    public void insertString(DocumentFilter.FilterBypass fb, int offset, String text, AttributeSet attr) throws BadLocationException {
        if (!this.regexMatch(text)) {
            Toolkit.getDefaultToolkit().beep();
            throw new BadLocationException(text, offset);
        }
        fb.insertString(offset, text, attr);
    }

    @Override
    public void replace(DocumentFilter.FilterBypass fb, int offset, int length, String text, AttributeSet attr) throws BadLocationException {
        if (!this.regexMatch(text)) {
            Toolkit.getDefaultToolkit().beep();
            throw new BadLocationException(text, offset);
        }
        fb.replace(offset, length, text, attr);
    }

    private boolean regexMatch(String text) {
        Matcher matcher = this.pattern.matcher(text);
        return matcher.matches();
    }
}

