/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.policy.dialog.AbsPolicyEditorDlg;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.ComponentFilter;
import com.sygate.scm.console.ui.util.EnabledComponentFilter;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JDialog;

public class ReadOnlyUtils {
    public static void disableAllComponents(Container ... containers) {
        if (containers == null) {
            return;
        }
        for (Container container : containers) {
            ReadOnlyUtils.setEnabled(container, false);
        }
    }

    public static void disableAllComponents(ComponentFilter filter, Container ... containers) {
        if (containers == null || filter == null) {
            return;
        }
        for (Container container : containers) {
            ReadOnlyUtils.setEnabled(container, false, filter);
        }
    }

    public static void disableAbsPolicyEditorDlgIfNeeded(AbsPolicyEditorDlg dialog) {
        if (dialog instanceof JDialog && dialog.isReadOnly()) {
            ReadOnlyUtils.disableDialog((JDialog)((Object)dialog));
        }
    }

    public static void disableDialogIfNeeded(AlwaysEnabledButton button, JDialog dialog) {
        if (button == null || dialog == null) {
            return;
        }
        if (button.isChildWindowReadOnly()) {
            ReadOnlyUtils.disableDialog(dialog);
        }
    }

    public static void disableDialog(JDialog dialog) {
        ReadOnlyUtils.disableAllComponents(dialog);
    }

    public static void setEnabled(Container container, boolean on, ComponentFilter ... filters) {
        if (container == null || filters == null) {
            return;
        }
        for (ComponentFilter filter : filters) {
            filter.doFilter(container, !on);
        }
        for (Component c : container.getComponents()) {
            for (ComponentFilter filter : filters) {
                filter.doFilter(c, !on);
            }
            if (!(c instanceof Container)) continue;
            ReadOnlyUtils.setEnabled((Container)c, on, filters);
        }
    }

    public static void setEnabled(Container container, boolean on) {
        ReadOnlyUtils.setEnabled(container, on, ComponentFilterFactory.getFilters());
    }

    public static void setEnabledAndHighlight(Component c, boolean enabled) {
        if (c == null) {
            return;
        }
        if (c.isEnabled() && enabled || !c.isEnabled() && !enabled) {
            return;
        }
        c.setEnabled(enabled);
    }

    private static class ComponentFilterFactory {
        private ComponentFilterFactory() {
        }

        public static ComponentFilter[] getFilters() {
            return new ComponentFilter[]{new EnabledComponentFilter.AlwaysEnabledComponentFilter(), new EnabledComponentFilter.AlwaysEnabledButtonFilter(), new EnabledComponentFilter.AlwaysEnabledJComboBoxFilter(), new EnabledComponentFilter.HighlightReadOnlyComponentFilter(), new EnabledComponentFilter.JListFilter()};
        }
    }
}

