/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.AbstractSchema;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableColumnHeader;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.common.configobject.table.SemTableValue;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.CustomTableModel;
import com.sygate.scm.console.ui.util.ResultTableModel;
import com.sygate.scm.console.ui.util.SortableTableModel;
import com.sygate.scm.console.ui.util.VectorTableRowAdapter;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.util.Vector;
import javax.swing.JOptionPane;
import org.w3c.dom.Document;

public class QueryTableModel
extends ResultTableModel {
    private static final long serialVersionUID = 1L;
    protected Vector<TableRow> data = new Vector();
    protected Vector<TableRow> exportData = new Vector();
    protected String queryString;
    protected int rowCount = 0;
    protected boolean isDynamicHeaders = true;
    protected RpcData rpc;

    public QueryTableModel() {
        this(true);
    }

    public QueryTableModel(boolean isDynamicHeaders) {
        this(isDynamicHeaders, true);
    }

    public QueryTableModel(boolean isDynamicHeaders, boolean isSorting) {
        super(isSorting ? new SortableTableModel(false) : new CustomTableModel());
        this.isDynamicHeaders = isDynamicHeaders;
    }

    public QueryTableModel(CustomTableModel model) {
        super(model);
        this.isDynamicHeaders = true;
    }

    @Override
    public Vector<TableRow> getData(int startRow, int count, boolean isForExport) {
        this.doQuery(startRow, count, isForExport);
        return isForExport ? this.exportData : this.data;
    }

    @Override
    protected int getModelRowCount(String queryTable, String queryFilter) {
        return this.rowCount;
    }

    @Override
    protected void resetData(int startRow, int count, String queryTable, String queryFilter) {
        Vector<TableRow> modelData = this.model.getDataVector();
        if (modelData == null) {
            modelData = new Vector(count);
        } else {
            modelData.clear();
        }
        this.doQuery(startRow, count);
        this.model.setColumnNames(this.columnNames);
        for (int i = 0; i < this.data.size(); ++i) {
            modelData.addElement(this.data.get(i));
        }
        this.model.setDataVector(modelData);
    }

    @Override
    public TableRow getRow(int index) {
        return this.model == null ? null : this.model.getRow(index);
    }

    public void setDataVector(Vector<TableRow> data) {
        this.data = data;
    }

    public boolean setQueryString(String queryString) {
        return this.setQueryString(queryString, false);
    }

    public boolean setQueryString(String queryString, boolean isBuildCountQuery) {
        if (queryString == null || queryString.trim().length() == 0) {
            this.rowCount = 0;
            return false;
        }
        this.queryString = queryString;
        if (isBuildCountQuery) {
            String queryCountString = this.buildCountQuery(queryString);
            this.rowCount = this.getRowCount(queryCountString, true);
        } else {
            this.rowCount = this.getRowCount(queryString);
        }
        boolean isValidQuery = this.rowCount != -1;
        this.rowCount = this.rowCount < 0 ? 0 : this.rowCount;
        return isValidQuery;
    }

    protected int getRowCount(String queryString) {
        return this.getRowCount(queryString, false);
    }

    protected int getRowCount(String queryString, boolean isQueryCountString) {
        int[] aTotalRow = new int[1];
        return aTotalRow[0];
    }

    protected void setPageData(SemTable semTable) {
        this.setPageData(semTable, 0, this.getMaxPageRowNumber());
    }

    protected void setPageData(SemTable semTable, int start, int size) {
        this.setData(semTable, start, size, false);
    }

    protected void setData(SemTable semTable, int start, int size, boolean isForExport) {
        Vector<TableRow> queryData = isForExport ? this.exportData : this.data;
        queryData.clear();
        if (semTable != null) {
            int rows = semTable.getSemTableRowCount();
            if (this.isDynamicHeaders) {
                Vector columnHeaders = semTable.getOptSemTableHeader().getSemTableColumnHeader();
                int columns = columnHeaders.size();
                this.columnNames = new String[columns];
                for (int i = 0; i < columns; ++i) {
                    this.columnNames[i] = ((SemTableColumnHeader)columnHeaders.get(i)).getColumnName();
                }
            }
            for (int i = 0; i < Math.min(size, rows); ++i) {
                SemTableRow tableRow = semTable.getSemTableRow(i);
                Vector semTableValues = tableRow.getSemTableValue();
                Vector<Object> actualValues = new Vector<Object>();
                for (int c = 0; c < this.columnNames.length; ++c) {
                    SemTableValue tableValue = (SemTableValue)semTableValues.get(c);
                    Object value = this.getActualValue(c, tableValue.getValue());
                    actualValues.add(c, value);
                }
                VectorTableRowAdapter row = new VectorTableRowAdapter(actualValues);
                queryData.add(row);
            }
        }
    }

    protected Object getActualValue(int columnIndex, Object value) {
        return value;
    }

    protected void doQuery(int start, int size) {
        this.doQuery(start, size, false);
    }

    protected void doQuery(int start, int size, boolean isForExport) {
        SemTable semTable;
        block3: {
            semTable = null;
            try {
                semTable = this.getSemTable(this.queryString, start, size);
            }
            catch (ConsoleException ex) {
                JOptionPane.showMessageDialog(Manager.getFrame(), ex.getMessage(), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryTableModel.msg.consoleError"), 0);
                if (!ex.needRelogin()) break block3;
                Manager.getFrame().showLoginPanel();
                return;
            }
        }
        if (semTable == null) {
            return;
        }
        this.setData(semTable, start, size, isForExport);
    }

    protected SemTable getSemTable(String queryString, int start, int size) throws ConsoleException {
        return null;
    }

    public String buildCountQuery(String queryString) {
        String queryCountString = null;
        String sqlInput = queryString.trim().toUpperCase();
        int fromIndex = sqlInput.indexOf("FROM");
        int orderbyIndex = sqlInput.indexOf("ORDER BY");
        queryCountString = "SELECT COUNT(*) " + sqlInput.substring(fromIndex, orderbyIndex);
        return queryCountString;
    }

    protected RpcData getUnmodifiedRpcData() {
        RpcData uRpc = null;
        try {
            uRpc = (RpcData)AbstractSchema.readXML((Document)this.rpc.getDocument());
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
        return uRpc;
    }
}

