/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIFontUtilities;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.logicobject.TableRow;
import com.sygate.scm.console.ui.util.ResultTablePanel;
import com.sygate.scm.console.ui.util.SearchResultPanel;
import com.sygate.scm.console.ui.util.SearchTable;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.UIText;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseListener;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;

public class QueryPanelBase
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final String SEARCH_COLUMN_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.7");
    public static final String COMPARISON_COLUMN_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.column.comparisonOperator");
    public static final String VALUE_COLUMN_NAME = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.column.value");
    protected JLabel jLTitle = new JLabel();
    protected JLabel jLCriteria = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.label.searchCriteria"));
    protected JButton jBSearch = new JButton(UIText.get(4610));
    protected JButton jBStop = new JButton(UIText.get(4621));
    protected SearchTableModel searchModel = new SearchTableModel();
    protected SearchTable jTSearch = new SearchTable(this.searchModel);
    protected JPanel titlePanel;
    protected JPanel searchPanel;
    protected JPanel queryPanel;
    protected JPanel buttonPanel;
    protected ResultTablePanel resultPanel;

    protected QueryPanelBase(String title) {
        this.jLTitle.setText(title);
    }

    protected void initialize() {
        this.jLTitle.setHorizontalAlignment(2);
        this.setLayout(new BorderLayout());
        this.add((Component)this.getQueryPane(), "Center");
    }

    protected void setSearchTable(SearchTable searchTable) {
        this.jTSearch = searchTable;
    }

    protected JPanel getTitlePanel() {
        if (this.titlePanel == null) {
            this.titlePanel = new JPanel();
        }
        this.titlePanel.add(this.jLTitle);
        return this.titlePanel;
    }

    protected void setTitlePanel(JPanel panel) {
        this.initialQueryPanel();
        this.titlePanel = panel;
        this.updateUI();
    }

    protected JPanel initialQueryPanel() {
        this.setSearchTable();
        this.titlePanel = this.getTitlePanel();
        this.titlePanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.searchPanel = this.getSearchPanel();
        if (this.queryPanel == null) {
            this.queryPanel = new JPanel(new BorderLayout());
        }
        this.queryPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5), BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.title.query"))));
        this.queryPanel.add((Component)this.titlePanel, "North");
        this.queryPanel.add((Component)this.searchPanel, "Center");
        this.buttonPanel = new JPanel();
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.add((Component)this.jBSearch, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 2, new Insets(2, 2, 10, 2), 0, 0));
        this.buttonPanel.add((Component)this.jBStop, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(2, 2, 10, 2), 0, 0));
        UIUtilities.fitJComponent(new JButton[]{this.jBSearch, this.jBStop});
        this.queryPanel.add((Component)this.buttonPanel, "South");
        return this.queryPanel;
    }

    protected JPanel getSearchPanel() {
        if (this.searchPanel == null) {
            this.searchPanel = new JPanel(new BorderLayout());
            this.searchPanel.add((Component)this.getCriteriaPanel(), "North");
            JScrollPane scrollPane = new JScrollPane();
            UiUtilities.setupScrollPane((JScrollPane)scrollPane, (JTable)((Object)this.jTSearch));
            this.searchPanel.add((Component)scrollPane, "Center");
        }
        return this.searchPanel;
    }

    protected void setSearchTable() {
    }

    protected JPanel getCriteriaPanel() {
        this.initialCriteriaLabelAndSearchButton();
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)this.jLCriteria, "West");
        return panel;
    }

    protected void initialCriteriaLabelAndSearchButton() {
        this.jLCriteria.setFont(UIFontUtilities.SUBTITLE_FONT);
        this.jBSearch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (QueryPanelBase.this.jTSearch.editCellAt(QueryPanelBase.this.jTSearch.getRowCount() - 1, QueryPanelBase.this.jTSearch.convertColumnIndexToView(0))) {
                    int[] validateResult = QueryPanelBase.this.jTSearch.validateRows();
                    if (validateResult[0] != -1) {
                        String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.title.IncompleteCriteria");
                        String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.message.MissingSearchField");
                        if (validateResult[0] == 0) {
                            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.message.MissingSearchField");
                        } else if (validateResult[0] == 1) {
                            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.message.MissingComparisonOperator");
                        } else if (validateResult[0] == 2) {
                            msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.message.MissingValue");
                        }
                        QueryPanelBase.this.jTSearch.editCellAt(validateResult[1], validateResult[0]);
                        JOptionPane.showMessageDialog(QueryPanelBase.this, msg, title, 0);
                    } else {
                        QueryPanelBase.this.search();
                    }
                }
            }
        });
        this.jBStop.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                QueryPanelBase.this.stop();
            }
        });
        this.jLCriteria.setBackground(Color.WHITE);
    }

    protected ResultTablePanel getResultTablePanel() {
        return new SearchResultPanel();
    }

    protected void search() {
        if (this.jTSearch.isEditing()) {
            this.jTSearch.getCellEditor().stopCellEditing();
        }
    }

    protected void stop() {
        this.resultPanel.disableProgressPanel();
    }

    protected String getSQLString() {
        return "";
    }

    protected void updateResultTableModel(String[] columnNames, Vector<TableRow> data) {
    }

    private JSplitPane getQueryPane() {
        this.queryPanel = this.initialQueryPanel();
        this.resultPanel = this.getResultTablePanel();
        this.resultPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 5, 5, 5), BorderFactory.createTitledBorder(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "QueryPanelBase.title.queryResult"))));
        JSplitPane pane = new JSplitPane();
        pane.setOrientation(0);
        pane.setResizeWeight(0.3);
        pane.setTopComponent(this.queryPanel);
        pane.setBottomComponent(this.resultPanel);
        return pane;
    }

    public void setResultTableMouseListener(MouseListener mouseListener) {
        if (this.resultPanel != null) {
            this.resultPanel.setTableMouseListener(mouseListener);
        }
    }

    protected static class SearchTableModel
    extends DefaultTableModel {
        private static final long serialVersionUID = 1L;
        private String[] COL_NAMES = new String[]{SEARCH_COLUMN_NAME, COMPARISON_COLUMN_NAME, VALUE_COLUMN_NAME};
        private String[][] ROWS = new String[][]{{"", "", ""}};

        public SearchTableModel() {
            this.reset();
        }

        public void reset() {
            this.setDataVector(this.ROWS, this.COL_NAMES);
        }
    }
}

