/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.util.ProportionalLayoutConstraints;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.util.Hashtable;
import java.util.Vector;

public class ProportionalLayout
implements LayoutManager2 {
    private Vector<Component> components = new Vector();
    private Hashtable<Component, Object> table = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLayoutComponent(Component comp, Object constraints) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            if (constraints == null || !(constraints instanceof ProportionalLayoutConstraints)) {
                throw new IllegalArgumentException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ProportionalLayout.msg.cannotAddToLayout"));
            }
            this.components.add(comp);
            this.table.put(comp, constraints);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLayoutComponent(Component comp) {
        Object object = comp.getTreeLock();
        synchronized (object) {
            this.components.remove(comp);
            this.table.remove(comp);
        }
    }

    @Override
    public Dimension maximumLayoutSize(Container target) {
        return new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    @Override
    public float getLayoutAlignmentX(Container target) {
        return 0.0f;
    }

    @Override
    public float getLayoutAlignmentY(Container target) {
        return 0.0f;
    }

    @Override
    public void invalidateLayout(Container target) {
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
        throw new IllegalArgumentException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "ProportionalLayout.msg.cannotAddToLayout"));
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        return parent.getSize();
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return parent.getSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            Insets insets = parent.getInsets();
            Dimension dimension = parent.getSize();
            dimension.width -= insets.left + insets.right;
            dimension.height -= insets.top + insets.bottom;
            for (int i = 0; i < this.components.size(); ++i) {
                Component thisComponent = this.components.get(i);
                ProportionalLayoutConstraints constraints = (ProportionalLayoutConstraints)this.table.get(thisComponent);
                int x = (int)(constraints.getHStartRatio() * dimension.getWidth() + (double)constraints.getHStartPixels());
                int y = (int)(constraints.getVStartRatio() * dimension.getHeight() + (double)constraints.getVStartPixels());
                int endX = (int)(constraints.getHEndRatio() * dimension.getWidth() + (double)constraints.getHEndPixels());
                int endY = (int)(constraints.getVEndRatio() * dimension.getHeight() + (double)constraints.getVEndPixels());
                int width = endX - x;
                int height = endY - y;
                if (!parent.getComponentOrientation().isLeftToRight()) {
                    x = (int)(dimension.getWidth() - (double)endX);
                }
                thisComponent.setBounds(x, y, width, height);
            }
        }
    }
}

