/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatform;
import com.sygate.scm.console.logicobject.PlatformObject;
import java.util.ArrayList;

public class PlatformUtil {
    private static ArrayList<String> checkDuplicatePlatforms(ArrayList<String> platformContents, ArrayList<PlatformObject> validPlatforms, ArrayList<String> duplicateInfo, boolean canSelectMac) {
        platformContents = PlatformUtil.checkPlatform(platformContents, duplicateInfo);
        for (String content : platformContents) {
            if (validPlatforms == null) continue;
            validPlatforms.add(PlatformUtil.getPlatformObjectByContent(canSelectMac, content));
        }
        return duplicateInfo;
    }

    private static ArrayList<String> checkPlatform(ArrayList<String> platformContents, ArrayList<String> duplicateInfo) {
        ArrayList<String> validContents = new ArrayList<String>();
        for (String platformContent : platformContents) {
            if (validContents.contains(platformContent)) {
                duplicateInfo.add(platformContent);
                continue;
            }
            validContents.add(platformContent);
        }
        return validContents;
    }

    public static boolean validPlatformForLuConfig(String clientPlatform, ArrayList<PlatformObject> validPlatforms, ArrayList<String> invalidPlatforms, ArrayList<String> checkInfo, boolean canSelectMac) {
        boolean isValid = true;
        ArrayList<String> platformContents = new ArrayList<String>();
        isValid = PlatformUtil.isPlatformValid(clientPlatform, invalidPlatforms, platformContents, canSelectMac);
        if (platformContents.size() > 0) {
            PlatformUtil.checkDuplicatePlatforms(platformContents, validPlatforms, checkInfo, canSelectMac);
        }
        return isValid;
    }

    private static boolean isPlatformValid(String clientPlatform, ArrayList<String> invalidPlatforms, ArrayList<String> validPlatforms, boolean canSelectMac) {
        String[] platforms;
        boolean isValid = true;
        if (null == clientPlatform || clientPlatform.equals("")) {
            return isValid;
        }
        for (String platform : platforms = clientPlatform.split(",")) {
            if (PlatformUtil.getPlatformObjectByContent(canSelectMac, platform.trim()) == null) {
                isValid = false;
                if (invalidPlatforms == null) continue;
                invalidPlatforms.add(platform);
                continue;
            }
            if (validPlatforms == null) continue;
            validPlatforms.add(platform.trim());
        }
        return isValid;
    }

    private static ArrayList<PlatformObject> getAllSubPlatform(PlatformObject platformObj, ArrayList<PlatformObject> platforms) {
        if (platforms == null) {
            platforms = new ArrayList();
        }
        if (platformObj.getSubs() != null) {
            for (PlatformObject sub : platformObj.getSubs()) {
                PlatformUtil.getAllSubPlatform(sub, platforms);
            }
        } else {
            platforms.add(platformObj);
        }
        return platforms;
    }

    private static ArrayList<PlatformObject> getAllPlatforms(boolean canSelectMac) {
        return PlatformUtil.getAllSubPlatform(PlatformUtil.getTheAllPlatformObj(), new ArrayList<PlatformObject>());
    }

    private static PlatformObject getPlatformObjectByContent(boolean canSelectMac, String content) {
        ArrayList<PlatformObject> platforms = PlatformUtil.getAllPlatforms(canSelectMac);
        for (PlatformObject platform : platforms) {
            if (!platform.getContent().equals(content)) continue;
            return platform;
        }
        return null;
    }

    public static PlatformObject getTheAllPlatformObj() {
        LuSupportedClientPlatform allPlatform = new LuSupportedClientPlatform();
        allPlatform.setContent("All");
        PlatformObject allPlatformObj = new PlatformObject(allPlatform);
        LuSupportedClientPlatform macPlatform = new LuSupportedClientPlatform();
        macPlatform.setContent("Mac");
        PlatformObject macPlatformObj = new PlatformObject(macPlatform);
        allPlatformObj.addSub(macPlatformObj);
        LuSupportedClientPlatform linuxPlatform = new LuSupportedClientPlatform();
        linuxPlatform.setContent("Linux");
        PlatformObject linuxPlatformObj = new PlatformObject(linuxPlatform);
        allPlatformObj.addSub(linuxPlatformObj);
        LuSupportedClientPlatform windowsPlatform = new LuSupportedClientPlatform();
        windowsPlatform.setContent("Windows");
        PlatformObject windowsPlatformObj = new PlatformObject(windowsPlatform);
        allPlatformObj.addSub(windowsPlatformObj);
        LuSupportedClientPlatform windows32Platform = new LuSupportedClientPlatform();
        windows32Platform.setContent("Win32");
        PlatformObject windows32PlatformObj = new PlatformObject(windows32Platform);
        windowsPlatformObj.addSub(windows32PlatformObj);
        LuSupportedClientPlatform windows64Platform = new LuSupportedClientPlatform();
        windows64Platform.setContent("Win64");
        PlatformObject windows64PlatformObj = new PlatformObject(windows64Platform);
        windowsPlatformObj.addSub(windows64PlatformObj);
        return allPlatformObj;
    }

    public static boolean isSamePlatform(LuSupportedClientPlatform platform1, LuSupportedClientPlatform platform2) {
        return platform1.getContent().equals(platform2.getContent());
    }
}

