/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.schema.LuSupportedClientPlatform;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.logicobject.PlatformObject;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class PlatformTree
extends JTree {
    private static final long serialVersionUID = 4033714480196213224L;
    private PlatformObject allPlatformObj = null;

    public PlatformTree(PlatformObject allPlatformObj, ArrayList<LuSupportedClientPlatform> platforms) {
        this.allPlatformObj = allPlatformObj;
        this.initTree();
        this.initAction();
        this.setSelectedPlatforms(platforms);
    }

    private void initTree() {
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setCellRenderer(new PlatformTreeCellRender());
        this.constructTree();
        this.expandAll();
    }

    public void expandAll() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.expandNodeAndChildren(node);
    }

    private void constructTree() {
        PlatformTreeNode rootNode = new PlatformTreeNode(this.allPlatformObj);
        this.constructSubTree(this.allPlatformObj, rootNode);
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.setModel(treeModel);
    }

    private void constructSubTree(PlatformObject platform, PlatformTreeNode parent) {
        if (platform.getSubs() != null) {
            for (PlatformObject sub : platform.getSubs()) {
                PlatformTreeNode subNode = new PlatformTreeNode(sub);
                parent.add(subNode);
                this.constructSubTree(sub, subNode);
            }
        }
    }

    private void expandNodeAndChildren(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.expandPath(path);
        if (node.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            this.expandNodeAndChildren(nodeChild);
        }
    }

    private void initAction() {
        this.addMouseListener(new PlatformCellListner(this));
    }

    public void setSelectedPlatforms(ArrayList<LuSupportedClientPlatform> platforms) {
        if (platforms != null && platforms.size() > 0) {
            DefaultTreeModel treeModel = (DefaultTreeModel)this.getModel();
            PlatformTreeNode node = (PlatformTreeNode)treeModel.getRoot();
            for (int index = 0; index < platforms.size(); ++index) {
                LuSupportedClientPlatform platform = platforms.get(index);
                this.setSelectedTreeNode(node, platform);
            }
        }
    }

    private void setSelectedTreeNode(PlatformTreeNode node, LuSupportedClientPlatform selPlatform) {
        PlatformObject platform = (PlatformObject)node.getUserObject();
        if (platform.getContent().equals(selPlatform.getContent())) {
            this.doClick(node, true);
        } else {
            for (int index = 0; index < node.getChildCount(); ++index) {
                PlatformTreeNode child = (PlatformTreeNode)node.getChildAt(index);
                this.setSelectedTreeNode(child, selPlatform);
            }
        }
    }

    private void doClick(PlatformTreeNode node, boolean isSelected) {
        node.setSelected(isSelected);
    }

    public ArrayList<LuSupportedClientPlatform> getSelectedPlatforms() {
        ArrayList<LuSupportedClientPlatform> selectedPlatforms = new ArrayList<LuSupportedClientPlatform>();
        selectedPlatforms.clear();
        PlatformTreeNode node = (PlatformTreeNode)this.getModel().getRoot();
        this.checkSelectedPlatform(node, selectedPlatforms);
        return selectedPlatforms;
    }

    private void checkSelectedPlatform(PlatformTreeNode node, ArrayList<LuSupportedClientPlatform> selectedPlatforms) {
        if (node.isSelected() && node.isLeaf()) {
            selectedPlatforms.add(((PlatformObject)node.getUserObject()).getPlatform());
        } else if (!node.isLeaf()) {
            for (int index = 0; index < node.getChildCount(); ++index) {
                PlatformTreeNode child = (PlatformTreeNode)node.getChildAt(index);
                this.checkSelectedPlatform(child, selectedPlatforms);
            }
        }
    }

    public static class PlatformComparator
    implements Comparator<LuSupportedClientPlatform>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(LuSupportedClientPlatform o1, LuSupportedClientPlatform o2) {
            return o1.getContent().compareTo(o2.getContent());
        }
    }

    public static class PlatformTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = 1L;
        private boolean isSelected = false;

        public PlatformTreeNode(PlatformObject platform) {
            super(platform);
        }

        public boolean isSelected() {
            return this.isSelected;
        }

        public void setSelected(boolean isSelected) {
            this.setSelected(this, isSelected);
        }

        private void setSelected(PlatformTreeNode source, boolean isSourceSelected) {
            if (this.isSelected == isSourceSelected) {
                return;
            }
            if (source.equals(this)) {
                this.isSelected = isSourceSelected;
                this.notifyAllNodes();
                return;
            }
            if (this.isNodeChild(source)) {
                boolean currentStatus = this.isSelected;
                currentStatus = !isSourceSelected ? this.isAnyChildrenSelected() : isSourceSelected;
                if (currentStatus != this.isSelected) {
                    this.isSelected = currentStatus;
                    this.notifyParent();
                }
            } else {
                this.isSelected = isSourceSelected;
                this.notifyChidren();
            }
        }

        private boolean isAnyChildrenSelected() {
            boolean isSelected = false;
            for (int index = 0; index < this.getChildCount(); ++index) {
                PlatformTreeNode child = (PlatformTreeNode)this.getChildAt(index);
                if (!child.isSelected()) continue;
                isSelected = true;
                break;
            }
            return isSelected;
        }

        private void notifyParent() {
            PlatformTreeNode parent = (PlatformTreeNode)this.getParent();
            if (parent != null) {
                parent.setSelected(this, this.isSelected);
            }
        }

        private void notifyChidren() {
            for (int index = 0; index < this.getChildCount(); ++index) {
                PlatformTreeNode child = (PlatformTreeNode)this.getChildAt(index);
                child.setSelected(this, this.isSelected);
            }
        }

        private void notifyAllNodes() {
            this.notifyParent();
            this.notifyChidren();
        }
    }

    private static class PlatformTreeCellRender
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private JLabel label;
        private JCheckBox checkBox = new JCheckBox();

        public PlatformTreeCellRender() {
            this.add(this.checkBox);
            this.label = new JLabel();
            this.add(this.label);
        }

        public int getCheckBoxWidth() {
            return this.checkBox != null ? this.checkBox.getWidth() : 0;
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
            this.setEnabled(tree.isEnabled());
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            Object o = node.getUserObject();
            if (node instanceof PlatformTreeNode) {
                PlatformTreeNode treeNode = (PlatformTreeNode)node;
                PlatformObject os = (PlatformObject)o;
                this.label.setText(this.getRes("label." + os.getContent().toLowerCase()));
                if (!tree.isEnabled()) {
                    this.label.setForeground(UIManager.getColor("TextField.inactiveForeground"));
                    this.label.setIcon(this.label.getDisabledIcon());
                } else if (this.selected) {
                    this.label.setForeground(UIManager.getColor("Tree.textSelectionColor"));
                } else {
                    this.label.setForeground(UIManager.getColor("Tree.textNonSelectionColor"));
                }
                if (this.checkBox == null) {
                    this.checkBox = new JCheckBox();
                    this.add(this.checkBox);
                }
                this.checkBox.setSelected(treeNode.isSelected());
                this.checkBox.setBackground(tree.getBackground());
                if (this.selected) {
                    this.checkBox.setForeground(UIManager.getColor("Tree.textSelectionColor"));
                } else {
                    this.checkBox.setForeground(UIManager.getColor("Tree.textNonSelectionColor"));
                }
                this.checkBox.setEnabled(tree.isEnabled());
            }
            this.setText("");
            this.doLayout();
            return this;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d_check = this.checkBox == null ? new Dimension() : this.checkBox.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            return new Dimension(d_check.width + d_label.width + 10, d_check.height < d_label.height ? d_label.height : d_check.height);
        }

        private String getRes(String key) {
            return MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PlatformTree." + key);
        }

        @Override
        public void doLayout() {
            super.doLayout();
            Dimension d_check = this.checkBox == null ? new Dimension() : this.checkBox.getPreferredSize();
            Dimension d_label = this.label.getPreferredSize();
            int y_check = 0;
            int y_label = 0;
            if (d_check.height < d_label.height) {
                y_check = (d_label.height - d_check.height) / 2;
            } else {
                y_label = (d_check.height - d_label.height) / 2;
            }
            if (this.checkBox != null) {
                this.checkBox.setBounds(0, y_check, d_check.width - 3, d_check.height);
            }
            this.label.setBounds(d_check.width + 5, y_label, d_label.width, d_label.height);
        }
    }

    private class PlatformCellListner
    extends MouseAdapter {
        JTree tree;

        PlatformCellListner(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            PlatformTreeNode node;
            int y;
            if (!this.tree.isEnabled()) {
                return;
            }
            int x = e.getX();
            int row = this.tree.getRowForLocation(x, y = e.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path == null) {
                return;
            }
            Rectangle rectangle = this.tree.getRowBounds(row);
            int startX = rectangle.x;
            PlatformTreeCellRender renderer = (PlatformTreeCellRender)this.tree.getCellRenderer();
            int width = renderer.getCheckBoxWidth();
            int endX = startX + width;
            if (x < startX || x > endX) {
                return;
            }
            PlatformTree.this.doClick(node, !(node = (PlatformTreeNode)path.getLastPathComponent()).isSelected());
            this.tree.revalidate();
            this.tree.repaint();
        }
    }
}

