/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.logicobject.LicenseObject;
import com.sygate.scm.console.logicobject.TreeItem;
import com.sygate.scm.console.ui.util.OutlookButton;
import com.sygate.scm.console.ui.util.SideBar;
import com.sygate.scm.console.ui.util.TaskObject;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ServerSystemLogMonitor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;

public abstract class PagePanel
extends JPanel
implements ListSelectionListener {
    private static final long serialVersionUID = -7705347285675470374L;
    protected SideBar sideBar;
    private Component currentTaskPanel;
    protected JPanel rightComponent = new JPanel(new BorderLayout());
    protected List<OutlookButtonObject> outlookButtonItemList = new ArrayList<OutlookButtonObject>();
    protected List<OutlookButton> outlookButtonList = new ArrayList<OutlookButton>();
    protected String currentOutlookButtonKey;
    protected int currentOutlookButtonIndex = 0;
    protected boolean isInitialized;
    private static final String PAGE_NAME = "admintab";

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (this.sideBar != null) {
            this.sideBar.updateTasks();
        }
    }

    public void setCurrentTaskPanel(TreeItem item) {
    }

    public Component getCurrentTaskPanel() {
        return this.currentTaskPanel;
    }

    public void selectItemIndex(int index) {
    }

    public void switchOut() {
        ServerSystemLogMonitor.getServerMonitor().setMonitoring(false, null);
    }

    public void switchIn() {
    }

    public int getItemIndex(int id) {
        return 0;
    }

    public void refreshTaskBarViews() {
        if (this.sideBar != null) {
            this.sideBar.updateViews();
        }
    }

    protected void initialize() {
        JSplitPane splitPane = new JSplitPane();
        splitPane.setOneTouchExpandable(true);
        splitPane.setDividerLocation(this.getDefaultDividerLocation());
        JScrollPane scrollPane = new JScrollPane(20, 31);
        scrollPane.setBorder(null);
        if (this.outlookButtonItemList.size() > 0) {
            JPanel serverPanel = (JPanel)this.getOutlookButtonPanel();
            this.sideBar = this.createSideBar(serverPanel);
        } else {
            this.sideBar = this.createSideBar();
        }
        this.sideBar.setBorder(null);
        scrollPane.setViewportView(this.sideBar);
        splitPane.setLeftComponent(scrollPane);
        splitPane.setRightComponent(this.rightComponent);
        this.rightComponent.setBorder(BorderFactory.createMatteBorder(15, 15, 15, 15, UIColorUtilities.CONTENT_PANE_BACKGROUND));
        splitPane.getLeftComponent().setMinimumSize(new Dimension(0, 30));
        splitPane.getRightComponent().setMinimumSize(new Dimension(0, 30));
        this.setLayout(new BorderLayout());
        this.add((Component)splitPane, "Center");
    }

    protected int getDefaultDividerLocation() {
        return 203;
    }

    private Component getOutlookButtonPanel() {
        JPanel outpanel = new JPanel();
        outpanel.putClientProperty("cssClass", "pagePaneloutPanel");
        outpanel.setLayout(new BorderLayout());
        JPanel bottomPanel = new JPanel();
        bottomPanel.putClientProperty("cssClass", "pagePanelbottomPanel");
        bottomPanel.setLayout(new GridBagLayout());
        ButtonGroup bg = new ButtonGroup();
        Iterator<OutlookButtonObject> it = this.outlookButtonItemList.iterator();
        int i = 0;
        JComponent tb = null;
        while (it.hasNext()) {
            OutlookButtonObject oObj = it.next();
            tb = new OutlookButton(oObj.description);
            UIUtilities.setName(tb, PAGE_NAME, UIUtilities.ComponentType.BUTTON, oObj.description + "subtab");
            ((AbstractButton)tb).setActionCommand(oObj.key);
            ((AbstractButton)tb).addActionListener(new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    PagePanel.this.outlookButtonChanged(arg0);
                }
            });
            bg.add((AbstractButton)tb);
            this.outlookButtonList.add((OutlookButton)tb);
            bottomPanel.add((Component)tb, new GridBagConstraints(0, i, 1, 1, 1.0, 0.0, 14, 2, new Insets(-1, 0, -1, 0), 0, 0));
            if (i == this.currentOutlookButtonIndex) {
                ((AbstractButton)tb).setSelected(true);
                this.currentOutlookButtonKey = oObj.key;
            }
            ++i;
        }
        if (i == 1 && tb != null) {
            tb.setVisible(false);
        }
        outpanel.add((Component)bottomPanel, "North");
        return bottomPanel;
    }

    protected void outlookButtonChanged(ActionEvent arg0) {
        this.currentOutlookButtonKey = arg0.getActionCommand();
        this.resetSideBar(this.currentOutlookButtonKey);
    }

    protected String getCurrentOutlookButtonKey() {
        return this.currentOutlookButtonKey;
    }

    protected void resetSideBar(String actionCommand) {
    }

    protected SideBar createSideBar() {
        return new SideBar(this, this.getSideBarViewPaneTitle(), this.getSideBarTaskPaneTitle());
    }

    protected SideBar createSideBar(JPanel serverPanel) {
        return new SideBar(this, this.getSideBarViewPaneTitle(), this.getSideBarTaskPaneTitle(), serverPanel);
    }

    protected String getSideBarViewPaneTitle() {
        String key = LicenseObject.getInstance().isSBProduct() ? "PagePanel.title.view.sbe" : "PagePanel.title.view.ee";
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", key);
    }

    protected String getSideBarTaskPaneTitle() {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.title.tasks");
    }

    protected void setSideBarViews(JComponent component) {
        this.sideBar.updateViews(component);
    }

    protected void setSideBarTasks(List<List<TaskObject>> task) {
        if (task == null) {
            task = this.getDefaultTaskList();
        }
        this.sideBar.updateTasks(task);
    }

    protected void setSideBarTasks(String pageName, List<List<TaskObject>> task) {
        if (task == null) {
            task = this.getDefaultTaskList();
        }
        this.sideBar.updateTasks(pageName, task);
    }

    protected void setImageButton(JButton[] buttons) {
    }

    protected void setCurrentTaskPanel(Component c) {
        this.currentTaskPanel = c;
        this.rightComponent.removeAll();
        this.rightComponent.add(c, "Center");
        this.rightComponent.updateUI();
    }

    protected int getRowIndex(JTree tree, String prefix, int startingRow) {
        int index = -1;
        TreePath path = tree.getNextMatch(prefix, startingRow, Position.Bias.Forward);
        if (path != null) {
            tree.expandPath(path);
            index = tree.getRowForPath(path);
        }
        return index;
    }

    private List<List<TaskObject>> getDefaultTaskList() {
        ImageIcon action = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.actionURL));
        ArrayList<TaskObject> tasks = new ArrayList<TaskObject>();
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.addGroup"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.addComputer"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.addUser"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.importActiveDirectoryOr"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.lable.deleteComputerOr"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.moveComputerOr"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.enableLANSensor"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.disableLANSensor"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.configureLANSensor"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.searchComputerOr"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.setDisplayFilter"), -1, action));
        tasks.add(new TaskObject(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "PagePanel.label.editProperties"), -1, action));
        ArrayList<List<TaskObject>> list = new ArrayList<List<TaskObject>>();
        list.add(tasks);
        return list;
    }

    protected void setViewPaneTitle(String title) {
        this.sideBar.updateViewsPaneTitle(title);
    }

    protected void setTaskPaneTitle(String title) {
        this.sideBar.updateTasksPaneTitle(title);
    }

    public void setCurrentSelection(TreeItem buttonContainer) {
    }

    public void selectOutlookButton(String key) {
        Iterator<OutlookButtonObject> it = this.outlookButtonItemList.iterator();
        int index = 0;
        while (it.hasNext()) {
            OutlookButtonObject buttonObj = it.next();
            if (buttonObj.key.equals(key)) {
                OutlookButton button = this.outlookButtonList.get(index);
                button.doClick();
            }
            ++index;
        }
    }

    public void initPanel() {
    }

    public synchronized boolean hasInitialized() {
        return this.isInitialized;
    }

    public void refresh() {
    }

    public void setOutlookButtonPanel(String key) {
        this.currentOutlookButtonIndex = 0;
        if (!this.hasInitialized()) {
            Iterator<OutlookButtonObject> it1 = this.outlookButtonItemList.iterator();
            int index = 0;
            while (it1.hasNext()) {
                OutlookButtonObject oObj = it1.next();
                if (oObj.key.equals(key)) {
                    this.currentOutlookButtonKey = oObj.key;
                    this.currentOutlookButtonIndex = index;
                    break;
                }
                ++index;
            }
        } else {
            Iterator<OutlookButton> it = this.outlookButtonList.iterator();
            int i = 0;
            while (it.hasNext()) {
                OutlookButton tb = it.next();
                if (tb.getActionCommand().equals(key)) {
                    tb.setSelected(true);
                    this.currentOutlookButtonKey = tb.getActionCommand();
                    this.currentOutlookButtonIndex = i;
                    break;
                }
                ++i;
            }
        }
    }

    public static class OutlookButtonObject {
        String description;
        String key;

        public OutlookButtonObject(String desc, String k) {
            this.description = desc;
            this.key = k;
        }
    }
}

