/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.schema.SoftwarePackage;
import com.sygate.scm.console.logicobject.CurrentPackageObject;
import com.sygate.scm.console.logicobject.SoftwarePackageObject;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.Utility;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.plaf.basic.BasicComboBoxRenderer;

public class PackageListComboBox
extends JComboBox<Object> {
    private static final long serialVersionUID = 1L;
    private static final Pattern versionPattern = Pattern.compile("(\\d+\\.\\d+\\.\\d+\\.\\d+)");

    public PackageListComboBox() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setRenderer(new PackageListRenderer(this));
        this.setEditable(false);
    }

    public void init(ArrayList<CurrentPackageObject> list, HashMap<String, Object> packageMap) {
        if (list == null) {
            return;
        }
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            CurrentPackageObject currObj = list.get(i);
            String formattedVersion = this.formatClientVersion(currObj.getSoftwarePackageObject().getName(), false);
            packageMap.put(formattedVersion, currObj);
            this.addItem(formattedVersion);
        }
    }

    private String formatClientVersion(String key, boolean ignoreBuildNumber) {
        Matcher m = versionPattern.matcher(key);
        Object version = "";
        while (m.find()) {
            version = (String)version + m.group();
        }
        String formattedVersion = Utility.getFormattedClientVersion((String)version, (boolean)ignoreBuildNumber);
        if (formattedVersion != null) {
            key = key.replace((CharSequence)version, formattedVersion);
        }
        key = key.replace("  ", " ");
        return key;
    }

    public void init(Object o, Map<String, Object> packageMap) {
        SoftwarePackage sp = this.getSoftwarePackage(o);
        if (sp == null) {
            return;
        }
        String formattedVersion = this.formatClientVersion(sp.getName(), false);
        packageMap.put(formattedVersion, sp);
        this.addItem(formattedVersion);
    }

    public SoftwarePackage getSoftwarePackage() {
        Object obj = this.getSelectedItem();
        return this.getSoftwarePackage(obj);
    }

    public SoftwarePackage getSoftwarePackage(Object obj) {
        if (obj == null) {
            return null;
        }
        if (obj instanceof SoftwarePackage) {
            return (SoftwarePackage)obj;
        }
        if (obj instanceof CurrentPackageObject) {
            return ((CurrentPackageObject)obj).getSoftwarePackage();
        }
        if (obj instanceof SoftwarePackageObject) {
            return ((SoftwarePackageObject)obj).getSoftwarePackage();
        }
        return null;
    }

    private static class PackageListRenderer
    implements ListCellRenderer<Object> {
        JComboBox<Object> box = null;
        private BasicComboBoxRenderer renderer = new BasicComboBoxRenderer();

        public PackageListRenderer(JComboBox<Object> box) {
            this.box = box;
        }

        @Override
        public Component getListCellRendererComponent(JList<? extends Object> list, Object value, int index, boolean isSelected, boolean hasFocus) {
            boolean listEnabled = this.box.isEnabled();
            this.renderer.setEnabled(listEnabled);
            String text = "";
            if (value != null) {
                if (value instanceof String) {
                    text = (String)value;
                } else if (value instanceof SoftwarePackage) {
                    SoftwarePackage sp = (SoftwarePackage)value;
                    text = sp.getName();
                } else if (value instanceof SoftwarePackageObject) {
                    SoftwarePackageObject spo = (SoftwarePackageObject)value;
                    text = spo.getName();
                } else if (value instanceof CurrentPackageObject) {
                    CurrentPackageObject cpo = (CurrentPackageObject)value;
                    text = cpo.getPackageName();
                }
            }
            this.renderer.setText(text);
            this.renderer.setBackground(isSelected ? UIManager.getColor("List.selectionBackground") : list.getBackground());
            return this.renderer;
        }
    }
}

