/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.creamtec.core.StringUtilities;
import com.sygate.scm.common.configobject.rpc.RpcData;
import com.sygate.scm.common.configobject.table.SemTable;
import com.sygate.scm.common.configobject.table.SemTableRow;
import com.sygate.scm.console.ui.util.IDropdownItemLoader;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.GUIManager;
import com.sygate.scm.util.LoggerUtilities;
import com.sygate.scm.util.query.AgentOperatingSystemTypeItem;
import com.sygate.scm.util.query.DropdownItem;
import java.util.ArrayList;
import java.util.Vector;

public class OSDropdownItemLoader
implements IDropdownItemLoader {
    private static long EXPIRATION = 900000L;
    private static long cacheLoadTime = 0L;
    private static OSDropdownItemLoader _inst = new OSDropdownItemLoader();
    DropdownItem[] cachedItems = null;

    private OSDropdownItemLoader() {
    }

    public static OSDropdownItemLoader getInstance() {
        return _inst;
    }

    @Override
    public synchronized DropdownItem[] loadValues() {
        DropdownItem[] items = this.getCachedItems();
        if (items == null) {
            RpcData rpc = new RpcData();
            try {
                SemTable semtable = GUIManager.getSemTable(1103, rpc, 0, -1);
                Vector vRow = semtable.getSemTableRow();
                ArrayList<AgentOperatingSystemTypeItem> itemlist = new ArrayList<AgentOperatingSystemTypeItem>();
                for (SemTableRow row : vRow) {
                    String os = row.getSemTableValue(0).getValue();
                    if (StringUtilities.isEmpty((String)os)) continue;
                    os = os.trim();
                    itemlist.add(AgentOperatingSystemTypeItem.getAgentOperatingSystemTypeItem((String)os));
                }
                items = itemlist.toArray(new DropdownItem[0]);
                this.setCachedItems(items);
            }
            catch (ConsoleException e) {
                LoggerUtilities.logException((Throwable)e);
                items = new DropdownItem[]{};
            }
        }
        return items;
    }

    private DropdownItem[] getCachedItems() {
        if (this.cachedItems != null && System.currentTimeMillis() - cacheLoadTime > EXPIRATION) {
            this.cachedItems = null;
        }
        return this.cachedItems;
    }

    private void setCachedItems(DropdownItem[] items) {
        this.cachedItems = items;
        cacheLoadTime = System.currentTimeMillis();
    }
}

