/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.creamtec.ajaxswing.support.validation.AjaxSwingDocumentValidator;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class NumberPlainDocument
extends PlainDocument
implements AjaxSwingDocumentValidator {
    private static final long serialVersionUID = 1L;
    private long max;
    private boolean isPositive;
    private long min = 0L;

    public NumberPlainDocument() {
        this(Integer.MAX_VALUE, false);
    }

    public NumberPlainDocument(long max) {
        this(max, false);
    }

    public NumberPlainDocument(long max, boolean isPositive) {
        this.max = max;
        this.isPositive = isPositive;
    }

    public NumberPlainDocument(long min, long max, boolean isPositive) {
        this.min = min;
        this.max = max;
        this.isPositive = isPositive;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null || str.length() == 0) {
            super.insertString(offs, str, a);
            return;
        }
        if (this.isPositive && str.charAt(0) == '-') {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        try {
            int pos;
            String text = this.getText(0, this.getLength());
            long i = Long.parseLong(text.substring(0, offs) + str + text.substring(offs));
            if (i <= this.max && i >= this.min) {
                super.insertString(offs, str, a);
                text = this.getText(0, this.getLength());
                for (pos = 0; pos < this.getLength() - 1 && '0' == text.charAt(pos); ++pos) {
                }
            } else {
                Toolkit.getDefaultToolkit().beep();
                throw new BadLocationException(str, offs);
            }
            this.remove(0, pos);
        }
        catch (RuntimeException e) {
            Toolkit.getDefaultToolkit().beep();
            throw new BadLocationException(str, offs);
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
            throw new BadLocationException(str, offs);
        }
    }

    public long getMax() {
        return this.max;
    }

    public HashMap<String, Object> getParams() {
        HashMap<String, Object> validatorParams = new HashMap<String, Object>();
        validatorParams.put("name", "NumberPlainDocument");
        validatorParams.put("min", this.min);
        validatorParams.put("max", this.max);
        validatorParams.put("isPositive", this.isPositive);
        return validatorParams;
    }
}

