/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import javax.swing.JOptionPane;

public class NotificationConverter {
    public static final int MAX_AGENT_MESSAGE_CHARS = 514;
    public static final String UI_LEFT_SEPARATOR = "[";
    public static final String UI_RIGHT_SEPARATOR = "]";
    public static final String AGENT_PREFIX = "~";
    public static final String NEW_LINE = "\n";
    public static final int TYPE_AV_SCAN = 0;
    public static final int TYPE_TAMPER_PROTECT = 1;
    public static final int UI_KEYWORD = 0;
    public static final int AGENT_KEYWORD = 1;
    public static final int UI_TO_AGENT = 0;
    public static final int AGENT_TO_UI = 1;
    public static final String ACTION_TAKEN = NotificationConverter.getRes("NotificationConverter.variable.ActionTaken");
    public static final String STORAGE_NAME = NotificationConverter.getRes("NotificationConverter.variable.StorageName");
    public static final String LOCATION = NotificationConverter.getRes("NotificationConverter.variable.Location");
    public static final String SENDERE_MAIL = NotificationConverter.getRes("NotificationConverter.variable.SenderEmail");
    public static final String EVENT = NotificationConverter.getRes("NotificationConverter.variable.Event");
    public static final String FILENAME = NotificationConverter.getRes("NotificationConverter.variable.Filename");
    public static final String RECIPIENTS = NotificationConverter.getRes("NotificationConverter.variable.Recipients");
    public static final String LOGGED_BY = NotificationConverter.getRes("NotificationConverter.variable.LoggedBy");
    public static final String USER = NotificationConverter.getRes("NotificationConverter.variable.User");
    public static final String ATTACHMENT = NotificationConverter.getRes("NotificationConverter.variable.Attachment");
    public static final String PATH_AND_FILENAME = NotificationConverter.getRes("NotificationConverter.variable.PathAndFilename");
    public static final String COMPUTER = NotificationConverter.getRes("NotificationConverter.variable.Computer");
    public static final String DATE_FOUND = NotificationConverter.getRes("NotificationConverter.variable.DateFound");
    public static final String SUBJECT = NotificationConverter.getRes("NotificationConverter.variable.Subject");
    public static final String SECURITY_RISK_NAME = NotificationConverter.getRes("NotificationConverter.variable.SecurityRiskName");
    public static final String FILE_REPUTATION = NotificationConverter.getRes("NotificationConverter.variable.FileReputation");
    public static final String ACTION_DESCRIPTION = NotificationConverter.getRes("NotificationConverter.variable.ActionDescription");
    public static final String STATUS = NotificationConverter.getRes("NotificationConverter.variable.Status");
    public static final String TP_TARGET_PATHNAME = NotificationConverter.getRes("NotificationConverter.variable.TPTargetPathname");
    public static final String TP_SYSTEM_EVENT = NotificationConverter.getRes("NotificationConverter.variable.TPSystemEvent");
    public static final String TP_ENTITY_TYPE = NotificationConverter.getRes("NotificationConverter.variable.TPEntityType");
    public static final String TP_ACTION_TAKEN = NotificationConverter.getRes("NotificationConverter.variable.TPActionTaken");
    public static final String TP_ACTOR_PROCESS_NAME = NotificationConverter.getRes("NotificationConverter.variable.TPActorProcessName");
    public static final String TP_ACTOR_PROCESSID = NotificationConverter.getRes("NotificationConverter.variable.TPActorProcessID");
    public static final String TP_DATE_FOUND = NotificationConverter.getRes("NotificationConverter.variable.TPDateFound");
    static final String[][] AV_SCAN_MAPPING = new String[][]{{ACTION_TAKEN, "~A"}, {STORAGE_NAME, "~B"}, {LOCATION, "~C"}, {SENDERE_MAIL, "~D"}, {EVENT, "~E"}, {FILENAME, "~F"}, {RECIPIENTS, "~I"}, {LOGGED_BY, "~L"}, {USER, "~N"}, {ATTACHMENT, "~O"}, {PATH_AND_FILENAME, "~P"}, {COMPUTER, "~S"}, {DATE_FOUND, "~T"}, {SUBJECT, "~U"}, {SECURITY_RISK_NAME, "~V"}, {FILE_REPUTATION, "~Q"}, {ACTION_DESCRIPTION, "~Y"}, {STATUS, "~Z"}};
    static final String[][] TAMPER_PROTECT_MAPPING = new String[][]{{TP_TARGET_PATHNAME, "~Q"}, {TP_SYSTEM_EVENT, "~H"}, {TP_ENTITY_TYPE, "~J"}, {TP_ACTION_TAKEN, "~G"}, {TP_ACTOR_PROCESS_NAME, "~M"}, {TP_ACTOR_PROCESSID, "~K"}, {TP_DATE_FOUND, "~T"}};
    int notifType = -1;
    String[][] mapping = null;

    public NotificationConverter(int notifType) {
        this.notifType = notifType;
        if (this.notifType == 0) {
            this.mapping = AV_SCAN_MAPPING;
        } else if (this.notifType == 1) {
            this.mapping = TAMPER_PROTECT_MAPPING;
        }
    }

    private static String getRes(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", key);
    }

    public String convertNotificationFormat(int direction, String srcMsg) {
        if (srcMsg == null || srcMsg.trim().length() == 0) {
            return "";
        }
        StringBuffer destMsgBuf = new StringBuffer();
        boolean firstLine = true;
        BufferedReader reader = new BufferedReader(new StringReader(srcMsg));
        try {
            String line = reader.readLine();
            while (line != null) {
                if (firstLine) {
                    firstLine = false;
                } else {
                    destMsgBuf.append(NEW_LINE);
                }
                String newLine = "";
                newLine = direction == 0 ? this.convertUiToAgentLine(line) : this.convertAgentToUiLine(line);
                destMsgBuf.append(newLine);
                line = reader.readLine();
            }
        }
        catch (IOException ex) {
            String msg = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "NotificationConverter.conversionError");
            String title = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "NotificationConverter.errorTitle");
            JOptionPane.showMessageDialog(Manager.getFrame(), msg, title, 0);
        }
        return destMsgBuf.toString();
    }

    public static boolean isConvertedAgentMessageLengthValid(String key, int type, String uiMessage, boolean showErrorDialog, Component parentComponent) {
        NotificationConverter converter = new NotificationConverter(type);
        String agentMessage = converter.convertNotificationFormat(0, uiMessage);
        if (agentMessage.length() > 514) {
            if (showErrorDialog) {
                MessageResources msgRes = MessageResources.getInstance();
                String uiUtilprop = "com.sygate.scm.console.ui.util.uiutil";
                JOptionPane.showMessageDialog(parentComponent, key + "\n\n" + msgRes.getString(uiUtilprop, "NotificationConverter.error.longMessage"), msgRes.getString(uiUtilprop, "NotificationConverter.error.messageTitle"), 0);
            }
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertUiToAgentLine(String uiLine) {
        int index;
        StringBuffer newLineBuf = new StringBuffer();
        while ((index = uiLine.indexOf(UI_LEFT_SEPARATOR)) != -1) {
            newLineBuf.append(uiLine.substring(0, index));
            uiLine = uiLine.substring(index, uiLine.length());
            index = uiLine.indexOf(UI_RIGHT_SEPARATOR);
            if (index != -1) {
                String word = uiLine.substring(1, index);
                if (this.isKeyword(0, word)) {
                    String newWord = this.convertToken(0, word);
                    newLineBuf.append(newWord);
                    if (index >= uiLine.length() - 1) return newLineBuf.toString();
                    uiLine = uiLine.substring(index + 1, uiLine.length());
                    continue;
                }
                newLineBuf.append(uiLine.substring(0, index + 1));
                uiLine = uiLine.substring(index + 1, uiLine.length());
                continue;
            }
            newLineBuf.append(uiLine);
            return newLineBuf.toString();
        }
        newLineBuf.append(uiLine);
        return newLineBuf.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private String convertAgentToUiLine(String agentLine) {
        int index;
        StringBuffer newLineBuf = new StringBuffer();
        while ((index = agentLine.indexOf(AGENT_PREFIX)) != -1) {
            newLineBuf.append(agentLine.substring(0, index));
            agentLine = agentLine.substring(index, agentLine.length());
            if (agentLine.length() > 1) {
                String word = agentLine.substring(0, 2);
                if (this.isKeyword(1, word)) {
                    String newWord = this.convertToken(1, word);
                    newLineBuf.append(UI_LEFT_SEPARATOR);
                    newLineBuf.append(newWord);
                    newLineBuf.append(UI_RIGHT_SEPARATOR);
                    if (agentLine.length() <= 2) return newLineBuf.toString();
                    agentLine = agentLine.substring(2, agentLine.length());
                    continue;
                }
                index = agentLine.indexOf(AGENT_PREFIX);
                newLineBuf.append(agentLine.substring(0, index + 1));
                agentLine = agentLine.substring(index + 2, agentLine.length());
                continue;
            }
            newLineBuf.append(agentLine);
            return newLineBuf.toString();
        }
        newLineBuf.append(agentLine);
        return newLineBuf.toString();
    }

    public String convertToken(int direction, String srcToken) {
        String destToken = srcToken;
        if (this.mapping == null) {
            return destToken;
        }
        boolean found = false;
        for (int i = 0; i < this.mapping.length; ++i) {
            String uiToken = this.mapping[i][0];
            String agentToken = this.mapping[i][1];
            switch (direction) {
                case 0: {
                    if (!srcToken.equalsIgnoreCase(uiToken)) break;
                    destToken = agentToken;
                    found = true;
                    break;
                }
                case 1: {
                    if (!srcToken.equalsIgnoreCase(agentToken)) break;
                    destToken = uiToken;
                    found = true;
                    break;
                }
            }
            if (found) break;
        }
        return destToken;
    }

    public boolean isKeyword(int keywordType, String word) {
        if (this.mapping == null) {
            return false;
        }
        for (int i = 0; i < this.mapping.length; ++i) {
            boolean match = false;
            if (this.notifType == 0) {
                match = this.mapping[i][keywordType].equalsIgnoreCase(word);
            } else if (this.notifType == 1) {
                match = this.mapping[i][keywordType].equals(word);
            }
            if (!match) continue;
            return true;
        }
        return false;
    }
}

