/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.ui.util.IPField;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class NetworkPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int NO_ERROR = 0;
    public static final int ERR_WRONG_IP = 1;
    public static final int ERR_WRONG_MASK = 2;
    private String errorMessage = "";
    private int errorCode = 0;
    IPField ipField = new IPField();
    IPField maskField = new IPField();

    public NetworkPane() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    void jbInit() throws Exception {
        this.ipField.setPreferredSize(new Dimension(150, 20));
        this.maskField.setPreferredSize(new Dimension(150, 20));
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        GridBagConstraints gbCon = new GridBagConstraints();
        JComponent[][] objs = new JComponent[2][4];
        objs[0][0] = new JLabel();
        objs[1][0] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "NetworkPane.label.subnetExample"));
        objs[0][1] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "NetworkPane.label.subnetAddress"));
        objs[1][1] = this.ipField;
        objs[0][2] = new JLabel();
        objs[1][2] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "NetworkPane.label.maskExample"));
        objs[0][3] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "NetworkPane.lable.subnetMask"));
        objs[1][3] = this.maskField;
        for (int i = 0; i < objs.length; ++i) {
            for (int j = 0; j < objs[i].length; ++j) {
                gbCon.gridx = i;
                gbCon.gridy = j;
                gbCon.anchor = 17;
                gbCon.insets = new Insets(0, 3, 2, 2);
                gbCon.weightx = 0.5;
                gbCon.weighty = 0.0;
                if (i == 1 && (j == 0 || j == 2)) {
                    gbCon.insets = new Insets(5, 3, 0, 10);
                    gbCon.anchor = 16;
                }
                this.add((Component)objs[i][j], gbCon);
            }
        }
    }

    public String getText() {
        String ip = this.ipField.getText();
        String mask = this.maskField.getText();
        if (ip.length() == 0) {
            return mask;
        }
        if (mask.length() == 0) {
            return ip;
        }
        return ip + ";" + mask;
    }

    public String getIPAddress() {
        return this.ipField.getText();
    }

    public String getMaskAddress() {
        return this.maskField.getText();
    }

    public void setIPAddress(String ip) {
        this.ipField.setText(ip);
    }

    public void setMaskAddress(String mask) {
        this.maskField.setText(mask);
    }

    public boolean isValidValue() {
        if (!this.ipField.isValid()) {
            this.errorCode = 1;
            this.errorMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "NetworkPane.msg.wrongNetworkAddress");
            return false;
        }
        if (!this.maskField.isValid()) {
            this.errorCode = 2;
            this.errorMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "NetworkPane.msg.wrongNetworkMask");
            return false;
        }
        return true;
    }

    @Override
    public void requestFocus() {
        switch (this.errorCode) {
            case 1: {
                this.ipField.requestFocus();
                break;
            }
            case 2: {
                this.maskField.requestFocus();
                break;
            }
        }
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

