/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.RestrictedPlainDocument;
import com.sygate.scm.console.ui.util.UIUtilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class NamePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField nameTxtField;
    private JTextArea descTxtArea;
    private JLabel nameLbl;
    private JLabel descLbl;
    private boolean readOnly = false;

    public NamePanel() {
        this(255);
    }

    public NamePanel(boolean readOnly) {
        this(255, readOnly);
    }

    public NamePanel(int nameFieldSize) {
        this(nameFieldSize, false);
    }

    public NamePanel(int nameFieldSize, boolean readOnly) {
        this.readOnly = readOnly;
        this.initialize(nameFieldSize);
        this.setReadOnly();
    }

    private void initialize(int nameFieldSize) {
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getNameLbl(), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.getNameField(nameFieldSize), new GridBagConstraints(1, 0, 1, 1, 1.0, 0.0, 18, 2, new Insets(3, 3, 3, 3), 0, 0));
        this.add((Component)this.getDescLbl(), new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 18, 0, new Insets(3, 3, 3, 3), 0, 0));
        JScrollPane sPane = new JScrollPane();
        UiUtilities.setupScrollPane((JScrollPane)sPane, (JTextArea)this.getDescArea());
        this.add((Component)sPane, new GridBagConstraints(1, 1, 1, 1, 1.0, 1.0, 18, 1, new Insets(3, 3, 3, 3), 0, 0));
    }

    private JLabel getNameLbl() {
        if (this.nameLbl == null) {
            this.nameLbl = new JLabel();
            this.nameLbl.setText(NamePanel.getString("NamePanel.Name"));
        }
        return this.nameLbl;
    }

    private JLabel getDescLbl() {
        if (this.descLbl == null) {
            this.descLbl = new JLabel(NamePanel.getString("NamePanel.Description"));
        }
        return this.descLbl;
    }

    public JTextArea getDescArea() {
        if (this.descTxtArea == null) {
            this.descTxtArea = new JTextArea(2, 40);
            RestrictedPlainDocument doc = new RestrictedPlainDocument(1023);
            this.descTxtArea.setDocument(doc);
            this.descTxtArea.setLineWrap(true);
            this.descTxtArea.setWrapStyleWord(true);
        }
        return this.descTxtArea;
    }

    public JTextField getNameField() {
        return this.getNameField(255);
    }

    public JTextField getNameField(int maxLength) {
        if (this.nameTxtField == null) {
            this.nameTxtField = new JTextField();
            RestrictedPlainDocument doc = new RestrictedPlainDocument(maxLength);
            doc.setValidator("/\\*?<>|:\"", false);
            this.nameTxtField.setDocument(doc);
        }
        return this.nameTxtField;
    }

    private static String getString(String key) {
        return MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", key);
    }

    public boolean isValidate(List<String> existNames) {
        String strName = this.getNameField().getText().trim();
        if (strName.length() == 0) {
            JOptionPane.showMessageDialog(Manager.getFrame(), NamePanel.getString("NamePanel.empty_name"), NamePanel.getString("NamePanel.invalidName"), 0);
            this.getNameField().requestFocusInWindow();
            return false;
        }
        if (existNames.contains(strName)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), NamePanel.getString("NamePanel.name_exist"), NamePanel.getString("NamePanel.invalidName"), 0);
            this.getNameField().requestFocusInWindow();
            return false;
        }
        String strDes = this.getDescription();
        if (!UIUtilities.validateNoHtmlParams(strDes) || !UIUtilities.validateNoScriptParams(strDes)) {
            JOptionPane.showMessageDialog(Manager.getFrame(), NamePanel.getString("NamePanel.invalid_description"), NamePanel.getString("NamePanel.description_error"), 0);
            this.getDescArea().requestFocusInWindow();
            return false;
        }
        return true;
    }

    public void setEnablePanel(boolean enabled) {
        this.getNameLbl().setEnabled(enabled);
        this.getNameField().setEnabled(enabled);
        this.getDescLbl().setEnabled(enabled);
        this.getDescArea().setEnabled(enabled);
    }

    public void setData(String name, String desc) {
        this.getNameField().setText(name);
        this.getDescArea().setText(desc);
    }

    @Override
    public String getName() {
        return this.getNameField().getText().trim();
    }

    public String getDescription() {
        return this.getDescArea().getText().trim();
    }

    public void setReadOnly() {
        this.nameTxtField.setEditable(!this.readOnly);
        if (!this.getNameField().isEditable()) {
            this.nameTxtField.setForeground(Color.GRAY);
        }
        this.descTxtArea.setEditable(!this.readOnly);
        if (!this.getDescArea().isEditable()) {
            this.descTxtArea.setForeground(Color.GRAY);
        }
        this.setEnablePanel(!this.readOnly);
    }
}

