/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.InputFocusAdapter;
import com.sygate.scm.console.ui.util.TimeSpinner;
import com.sygate.scm.console.ui.util.TimeTextField;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

class MyTimePanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    int m_insetX = 1;
    int m_insetY = 1;
    int m_insetMiddle = 1;
    TimeTextField m_tfHour = new TimeTextField(1, 12);
    JLabel m_lbSeparatorHM = new JLabel();
    TimeTextField m_tfMinute = new TimeTextField(0, 59);
    JLabel m_lbSeparatorMS = new JLabel();
    TimeTextField m_tfSecond = new TimeTextField(0, 59);
    JLabel m_lbSeparatorSAP = new JLabel();
    JTextField m_tfAmPm = new JTextField();
    TimeSpinner m_spinner = null;
    boolean is24 = false;

    public JTextField getFocusField() {
        if (this.m_tfHour.isFocusOwner()) {
            return this.m_tfHour;
        }
        if (this.m_tfMinute.isFocusOwner()) {
            return this.m_tfMinute;
        }
        if (this.m_tfSecond.isFocusOwner()) {
            return this.m_tfSecond;
        }
        if (this.m_tfAmPm.isFocusOwner()) {
            return this.m_tfAmPm;
        }
        return null;
    }

    public MyTimePanel() {
        try {
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public MyTimePanel(boolean is24) {
        try {
            this.is24 = is24;
            if (is24) {
                this.m_tfHour = new TimeTextField(0, 23);
            }
            this.jbInit();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
        Color background = this.m_tfHour.getBackground();
        this.setBackground(background);
        this.m_tfHour.setText("12");
        this.m_lbSeparatorHM.setText(":");
        this.m_lbSeparatorHM.setBackground(background);
        this.m_lbSeparatorHM.setOpaque(true);
        this.m_tfMinute.setText("00");
        this.m_lbSeparatorMS.setText(":");
        this.m_lbSeparatorMS.setBackground(background);
        this.m_lbSeparatorMS.setOpaque(true);
        this.m_tfSecond.setText("00");
        this.m_lbSeparatorSAP.setText(" ");
        this.m_lbSeparatorSAP.setBackground(background);
        this.m_lbSeparatorSAP.setOpaque(true);
        this.m_tfAmPm.addFocusListener(new InputFocusAdapter(this.m_tfAmPm));
        this.m_tfAmPm.setText(" AM");
        this.m_tfAmPm.setBorder(null);
        this.m_tfAmPm.setEditable(false);
        this.m_tfAmPm.setBackground(background);
        this.m_tfAmPm.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                MyTimePanel.this.m_tfAmPm.setSelectionStart(0);
                MyTimePanel.this.m_tfAmPm.setSelectionEnd(MyTimePanel.this.m_tfAmPm.getText().length());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    MyTimePanel.this.changeAmPm();
                }
            }
        });
        this.m_tfAmPm.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 38 || e.getKeyCode() == 40 || e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                    MyTimePanel.this.changeAmPm();
                    if (e.getKeyCode() == 37 || e.getKeyCode() == 39) {
                        e.setKeyCode(38);
                    }
                }
            }
        });
        this.add(this.m_tfHour);
        this.add(this.m_lbSeparatorHM);
        this.add(this.m_tfMinute);
        this.add(this.m_lbSeparatorMS);
        this.add(this.m_tfSecond);
        this.add(this.m_lbSeparatorSAP);
        if (!this.is24) {
            this.add(this.m_tfAmPm);
        }
    }

    public void changeAmPm() {
        this.m_tfAmPm.setText(this.isAm() ? " PM" : " AM");
        this.m_tfAmPm.setSelectionStart(0);
        this.m_tfAmPm.setSelectionEnd(this.m_tfAmPm.getText().length());
    }

    public void init(TimeSpinner spinner) {
        this.m_spinner = spinner;
    }

    public void doLayout_bak() {
        super.doLayout();
        Dimension d_spinner = this.m_spinner.getSize();
        Dimension d_editor = this.m_spinner.getEditor().getSize();
        System.out.println("d_spinner=" + d_spinner.width + ", " + d_spinner.height);
        System.out.println("d_editor=" + d_editor.width + ", " + d_editor.height);
        Dimension d_hour = this.m_tfHour.getSize();
        Dimension d_separator_hm = this.m_lbSeparatorHM.getSize();
        Dimension d_minute = this.m_tfMinute.getSize();
        Dimension d_separator_ms = this.m_lbSeparatorMS.getSize();
        Dimension d_second = this.m_tfSecond.getSize();
        Dimension d_separator_sap = this.m_lbSeparatorSAP.getSize();
        Dimension d_ampm = this.m_tfAmPm.getSize();
        Insets insets = this.m_spinner.getBorder().getBorderInsets(this);
        int top = insets.top + this.m_insetY;
        int left = insets.left + this.m_insetX;
        this.m_tfHour.setBounds(left, top, d_hour.width, d_hour.height);
        this.m_lbSeparatorHM.setBounds(left += this.m_tfHour.getWidth() + this.m_insetMiddle, top, d_separator_hm.width, d_separator_hm.height);
        this.m_tfMinute.setBounds(left += this.m_lbSeparatorHM.getWidth() + this.m_insetMiddle, top, d_minute.width, d_minute.height);
        this.m_lbSeparatorMS.setBounds(left += this.m_tfMinute.getWidth() + this.m_insetMiddle, top, d_separator_ms.width, d_separator_ms.height);
        this.m_tfSecond.setBounds(left += this.m_lbSeparatorMS.getWidth() + this.m_insetMiddle, top, d_second.width, d_second.height);
        this.m_lbSeparatorSAP.setBounds(left += this.m_tfSecond.getWidth() + this.m_insetMiddle, top, d_separator_sap.width, d_separator_sap.height);
        this.m_tfAmPm.setBounds(left += this.m_lbSeparatorSAP.getWidth() + this.m_insetMiddle, top, d_ampm.width, d_ampm.height);
        int w = (left += this.m_tfAmPm.getWidth() + this.m_insetX) + insets.right + insets.right;
        int h = d_hour.height + insets.top + insets.bottom + this.m_insetY + this.m_insetY;
        System.out.println("w=" + w + ", h=" + h);
        this.setSize(w, h);
        this.setPreferredSize(new Dimension(w, h));
    }

    public boolean isAm() {
        return this.m_tfAmPm.getText().equals(" AM");
    }

    public int getHour(boolean ampm_format) {
        int value = this.m_tfHour.getValue();
        if (this.is24) {
            return value;
        }
        if (ampm_format) {
            return value;
        }
        if (this.isAm()) {
            if (value == 12) {
                value = 0;
            }
        } else if (value != 12) {
            value += 12;
        }
        return value;
    }

    public int getMinute() {
        return this.m_tfMinute.getValue();
    }

    public int getSecond() {
        return this.m_tfSecond.getValue();
    }

    public void setAmPm(boolean am) {
        this.m_tfAmPm.setText(am ? " AM" : " PM");
    }

    public void setHour(int hour, int hour_format) {
        if (hour > 12) {
            this.m_tfHour.setValue(hour);
            this.setAmPm(false);
        } else {
            this.m_tfHour.setValue(hour);
            this.setAmPm(hour_format != 1);
        }
    }

    public void setMinute(int minute) {
        if (minute < 0 || minute > 59) {
            return;
        }
        this.m_tfMinute.setValue(minute);
    }

    public void setSecond(int second) {
        if (second < 0 || second > 59) {
            return;
        }
        this.m_tfSecond.setValue(second);
    }

    public void setTime(int hour, int minute, int second, int hour_format) {
        this.setHour(hour, hour_format);
        this.setMinute(minute);
        this.setSecond(second);
    }

    public void setTime(int[] time) {
        if (time == null || time.length < 4) {
            return;
        }
        this.setHour(time[0], time[3]);
        this.setMinute(time[1]);
        this.setSecond(time[2]);
    }
}

