/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class MacField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField[] fields;
    private JLabel[] dots;
    private boolean acceptWildChar = false;
    private boolean onlyWildCharAllowed = false;
    private boolean[] isWildChar = new boolean[6];

    public MacField() {
        this(false);
    }

    public MacField(boolean acceptWildChar) {
        this.acceptWildChar = acceptWildChar;
        this.initialize();
    }

    private void initialize() {
        this.setLayout(null);
        this.setBorder(new JTextField().getBorder());
        this.setBackground(Color.white);
        this.initFields();
        for (int i = 0; i < 6; ++i) {
            this.isWildChar[i] = false;
            this.add(this.getField(i));
            if (i == 5) continue;
            this.add(this.getDot(i));
        }
    }

    @Override
    public void requestFocus() {
        this.getField(0).requestFocus();
    }

    protected void IPValueChanged(int part, DocumentEvent e) {
        if (part < 5) {
            Document doc = e.getDocument();
            int docLength = doc.getLength();
            if (docLength < 1) {
                this.isWildChar[part] = false;
                return;
            }
            String text = null;
            try {
                text = doc.getText(0, 1);
            }
            catch (Exception ex) {
                text = null;
            }
            boolean bl = this.isWildChar[part] = this.acceptWildChar && part > 2 && docLength == 1 && "*".equals(text);
            if (docLength == 2 || this.isWildChar[part]) {
                this.tabToNextPart(part);
            }
        }
    }

    protected void tabToPreviousPart(int focussedPart) {
        if (focussedPart != 0) {
            this.getField(focussedPart - 1).requestFocus(false);
        }
    }

    private DocumentListener getDocumentListener(final int i) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                MacField.this.IPValueChanged(i, e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                MacField.this.IPValueChanged(i, e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                MacField.this.IPValueChanged(i, e);
            }
        };
    }

    private void tabToNextPart(int focussedPart) {
        if (focussedPart < 5) {
            this.getField(focussedPart + 1).requestFocus(false);
        }
    }

    private JTextField getField(int position) {
        if (this.fields == null) {
            this.initFields();
        }
        return this.fields[position];
    }

    private void initFields() {
        this.fields = new JTextField[6];
        for (int i = 0; i < 6; ++i) {
            final int fieldPosition = i;
            this.fields[i] = new JTextField(this.acceptWildChar && i > 2 ? new IPWildPartDocument() : new IPPartDocument(), null, 3){
                private static final long serialVersionUID = 1L;

                @Override
                public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
                    char key = e.getKeyChar();
                    if (key != '\b' || fieldPosition == 0) {
                        return super.processKeyBinding(ks, e, condition, pressed);
                    }
                    JTextField field = (JTextField)e.getSource();
                    Caret caret = field.getCaret();
                    if (caret.getDot() == 0 && caret.getMark() == 0) {
                        if (!pressed) {
                            return false;
                        }
                        MacField.this.tabToPreviousPart(fieldPosition);
                        return false;
                    }
                    return super.processKeyBinding(ks, e, condition, pressed);
                }
            };
            this.fields[i].setHorizontalAlignment(0);
            this.fields[i].getDocument().addDocumentListener(this.getDocumentListener(i));
            this.fields[i].setOpaque(false);
            this.fields[i].setBorder(null);
        }
    }

    private JLabel getDot(int position) {
        if (this.dots == null) {
            this.dots = new JLabel[5];
            for (int i = 0; i < 5; ++i) {
                this.dots[i] = this.createNewDot();
            }
        }
        return this.dots[position];
    }

    private JLabel createNewDot() {
        JLabel dot = new JLabel("-");
        dot.setVerticalAlignment(3);
        return dot;
    }

    private boolean isValidIPPart(String valueAsString) {
        if (valueAsString == null || valueAsString.length() == 0) {
            return false;
        }
        if (this.acceptWildChar && valueAsString.equals("*")) {
            return true;
        }
        if (valueAsString.length() != 2) {
            return false;
        }
        try {
            Integer.parseInt(valueAsString, 16);
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void setText(String address) throws IllegalArgumentException {
        StringTokenizer tokenizer;
        int tokens;
        if (address == null || address.trim().length() == 0) {
            for (int i = 0; i < 6; ++i) {
                this.getField(i).setText("");
            }
            return;
        }
        if (address.indexOf(":") != -1) {
            StringTokenizer addrTokens = new StringTokenizer(address, ":");
            String addrToken = null;
            while (addrTokens.hasMoreTokens()) {
                addrToken = addrTokens.nextToken();
                if (addrToken.indexOf("-") == -1) continue;
                address = addrToken.trim();
            }
        }
        if ((tokens = (tokenizer = new StringTokenizer(address, "-")).countTokens()) != 6) {
            throw new IllegalArgumentException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "MacField.msg.theMACAddressDoesNot"));
        }
        String[] parts = new String[6];
        for (int i = 0; i < parts.length; ++i) {
            String token = tokenizer.nextToken();
            if (!this.isValidIPPart(token)) {
                Object[] obj = new Object[]{token};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "MacField.msg.isNotAValidPart");
                String fm = MessageFormat.format(str, obj);
                throw new IllegalArgumentException(fm);
            }
            parts[i] = token;
        }
        this.setIPParts(parts);
    }

    public String getText() {
        String[] parts = new String[6];
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = this.getField(i).getText();
            if (this.isValidIPPart(parts[i])) continue;
            return "";
        }
        StringBuffer returnStr = new StringBuffer(parts[0]);
        for (int i = 1; i < parts.length; ++i) {
            returnStr.append("-");
            returnStr.append(parts[i]);
        }
        return returnStr.toString();
    }

    public void setIPParts(String[] parts) {
        for (int i = 0; i < 6; ++i) {
            this.getField(i).setText(parts[i]);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int horizontalInset = 2;
        int verticalInset = 2;
        int labelWidth = 8;
        int textFieldWidth = (width - 5 * labelWidth - 2 * horizontalInset) / 6;
        int startX = horizontalInset;
        int fieldHeight = height - verticalInset * 2;
        for (int i = 0; i < 6; ++i) {
            this.getField(i).setBounds(startX, verticalInset, textFieldWidth, fieldHeight);
            startX += textFieldWidth;
            if (i == 5) continue;
            this.getDot(i).setBounds(startX, verticalInset, labelWidth, fieldHeight);
            startX += labelWidth;
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < 6; ++i) {
            this.getField(i).setEnabled(enabled);
        }
        if (enabled) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(SystemColor.control);
        }
    }

    @Override
    public boolean isValid() {
        String[] parts = new String[6];
        for (int i = 0; i < 6; ++i) {
            parts[i] = this.getField(i).getText();
            if (this.isValidIPPart(parts[i])) continue;
            return false;
        }
        if (this.acceptWildChar) {
            boolean flag5 = this.isWildChar[5] = "*".equals(parts[5]);
            boolean flag4 = this.isWildChar[4] = "*".equals(parts[4]);
            boolean flag3 = this.isWildChar[3] = "*".equals(parts[3]);
            if (!flag5 ? flag4 || flag3 : !flag4 && flag3) {
                return false;
            }
        }
        return true;
    }

    public long getValue() {
        long value = 0L;
        for (int i = 0; i < 4; ++i) {
            value = (value << 8) + (long)Integer.parseInt(this.getField(i).getText());
        }
        return value;
    }

    class IPWildPartDocument
    extends IPPartDocument {
        private static final long serialVersionUID = 1L;

        IPWildPartDocument() {
        }

        @Override
        protected boolean isAcceptableIPPart(String valueAsString) {
            if (valueAsString.length() == 1 && valueAsString.equals("*")) {
                return true;
            }
            if (MacField.this.onlyWildCharAllowed) {
                return false;
            }
            return super.isAcceptableIPPart(valueAsString);
        }
    }

    class IPPartDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        IPPartDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String existingValue = super.getText(0, this.getLength());
            Object possibleNewValue = "";
            if (existingValue != null && existingValue.length() > 0) {
                String firstPart = existingValue.substring(0, offs);
                String secondPart = existingValue.substring(offs);
                possibleNewValue = firstPart + str + secondPart;
            } else {
                possibleNewValue = str;
            }
            if (this.isAcceptableIPPart((String)possibleNewValue)) {
                super.insertString(offs, str, a);
            }
        }

        protected boolean isAcceptableIPPart(String valueAsString) {
            if (valueAsString == null || valueAsString.length() == 0) {
                return true;
            }
            if (valueAsString.length() > 2) {
                return false;
            }
            try {
                Integer.parseInt(valueAsString, 16);
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

