/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.logicobject.DeviceObject;
import com.sygate.scm.util.StringUtilities;

public class MacDeviceControlRuleUtil {
    public static final String WILDCHAR = ".*";
    public static final String OLD_WILDCHAR = "*";
    public static final String MAC_USB = "Mac USB";
    public static final String MAC_THUNDERBOLT = "Mac Thunderbolt";

    public static boolean isDuplicatedMacDeviceItem(DeviceObject left, DeviceObject right) {
        if (left == null && right == null) {
            return true;
        }
        return left != null && right != null && left.equals(right) && MacDeviceControlRuleUtil.isConflictWithWildChar(left.getDeviceModel(), right.getDeviceModel()) && MacDeviceControlRuleUtil.isConflictWithWildChar(left.getDeviceVendor(), right.getDeviceVendor()) && MacDeviceControlRuleUtil.isConflictWithWildChar(left.getSerialNumber(), right.getSerialNumber());
    }

    public static boolean isConflictWithWildChar(String regexLeft, String regexRight) {
        if (StringUtilities.isEqualIgnoreCase((String)regexLeft, (String)regexRight)) {
            return true;
        }
        if (StringUtilities.isEmpty((String)regexLeft) && StringUtilities.isEmpty((String)regexRight)) {
            return true;
        }
        return WILDCHAR.equals(regexRight) && StringUtilities.isEmpty((String)regexLeft) || WILDCHAR.equals(regexLeft) && StringUtilities.isEmpty((String)regexRight);
    }
}

