/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.ToolTipManager;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;

public class JPanelWithIconBorder
extends JPanel {
    private static final long serialVersionUID = 1L;

    public JPanelWithIconBorder(String borderTitle, List<JLabel> iconLabelList) {
        final IconTitledBorder iconTitledBorder = new IconTitledBorder(BorderFactory.createEtchedBorder(), borderTitle, iconLabelList);
        Border outer = BorderFactory.createEmptyBorder(4, 6, 4, 6);
        super.setBorder(BorderFactory.createCompoundBorder(outer, iconTitledBorder));
        super.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                Component actionSource;
                Map<JPanel, Map<JLabel, Rectangle>> panelIconLabelLocationMap = iconTitledBorder.getPanelIconLabelLocationMap();
                Map<JLabel, Rectangle> rectangleLabelMap = panelIconLabelLocationMap.get(actionSource = mouseEvent.getComponent());
                if (rectangleLabelMap != null) {
                    boolean overTheIconLabel = false;
                    for (Map.Entry<JLabel, Rectangle> entry : rectangleLabelMap.entrySet()) {
                        Object object;
                        Rectangle iconRectangle = entry.getValue();
                        if (!iconRectangle.contains(mouseEvent.getPoint()) || !((object = mouseEvent.getSource()) instanceof JPanel)) continue;
                        JPanel logPanel = (JPanel)object;
                        JLabel label = entry.getKey();
                        logPanel.setToolTipText(label.getToolTipText());
                        ToolTipManager.sharedInstance().mouseMoved(mouseEvent);
                        overTheIconLabel = true;
                        break;
                    }
                    if (!overTheIconLabel) {
                        ToolTipManager.sharedInstance().mouseExited(mouseEvent);
                    }
                }
            }
        });
    }

    private static class IconTitledBorder
    extends TitledBorder {
        private static final long serialVersionUID = 1L;
        private final JLabel label;
        private List<JLabel> iconLabelList = new ArrayList<JLabel>();
        private Map<JPanel, Map<JLabel, Rectangle>> panelIconLabelLocationMap = new HashMap<JPanel, Map<JLabel, Rectangle>>(4);

        public IconTitledBorder(Border border, String title, List<JLabel> iconLabelList) {
            super(border);
            this.title = title;
            this.border = border;
            this.titleFont = null;
            this.titleColor = null;
            super.setTitleJustification(4);
            super.setTitlePosition(0);
            this.label = new JLabel();
            this.label.setOpaque(false);
            this.label.putClientProperty("html", null);
            if (iconLabelList != null) {
                this.iconLabelList = iconLabelList;
            }
        }

        private JLabel getLabelWithIconBorder(Component c) {
            this.label.setText(super.getTitle());
            this.label.setFont(super.getFont(c));
            this.label.setComponentOrientation(c.getComponentOrientation());
            this.label.setEnabled(c.isEnabled());
            return this.label;
        }

        private int getIconLabelWidth() {
            int iconLabelWidth = 0;
            for (JLabel iconLabel : this.iconLabelList) {
                iconLabelWidth += iconLabel.getPreferredSize().width;
            }
            if (!this.iconLabelList.isEmpty()) {
                iconLabelWidth += (this.iconLabelList.size() - 1) * 4;
                iconLabelWidth += 4;
            }
            return iconLabelWidth;
        }

        @Override
        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            Border border = super.getBorder();
            int edge = border instanceof IconTitledBorder ? 0 : 2;
            int borderX = x + edge;
            int borderY = y + edge;
            int borderW = width - edge - edge;
            int borderH = height - edge - edge;
            int labelY = y;
            JLabel label = this.getLabelWithIconBorder(c);
            Dimension labelPreferredSize = label.getPreferredSize();
            int iconLabelWidth = this.getIconLabelWidth();
            labelPreferredSize.width += iconLabelWidth;
            int labelHeight = labelPreferredSize.height;
            Insets borderInsets = ((AbstractBorder)border).getBorderInsets(c, new Insets(0, 0, 0, 0));
            borderInsets.top = edge + borderInsets.top / 2 - labelHeight / 2;
            if (borderInsets.top < edge) {
                borderY -= borderInsets.top;
                borderH += borderInsets.top;
            } else {
                labelY += borderInsets.top;
            }
            borderInsets.left += edge + 5;
            borderInsets.right += edge + 5;
            int labelX = x;
            int labelW = width - borderInsets.left - borderInsets.right;
            if (labelW > labelPreferredSize.width) {
                labelW = labelPreferredSize.width;
            }
            labelX += borderInsets.left;
            Graphics g2 = g.create();
            if (g2 instanceof Graphics2D) {
                Graphics2D g2d = (Graphics2D)g2;
                Path2D.Float path = new Path2D.Float();
                path.append(new Rectangle(borderX, borderY, borderW, labelY - borderY), false);
                path.append(new Rectangle(borderX, labelY, labelX - borderX - 2, labelHeight), false);
                path.append(new Rectangle(labelX + labelW + 2, labelY, borderX - labelX + borderW - labelW - 2, labelHeight), false);
                path.append(new Rectangle(borderX, labelY + labelHeight, borderW, borderY - labelY + borderH - labelHeight), false);
                g2d.clip(path);
            }
            border.paintBorder(c, g2, borderX, borderY, borderW, borderH);
            g2.dispose();
            g.translate(labelX, labelY);
            label.setSize(labelW, labelHeight);
            label.paint(g);
            g.translate(-labelX, -labelY);
            if (this.iconLabelList.size() > 0) {
                int preItemWidth = label.getPreferredSize().width;
                for (int i = 0; i < this.iconLabelList.size(); ++i) {
                    JLabel iconLabel = this.iconLabelList.get(i);
                    if (iconLabel == null) continue;
                    labelX = labelX + preItemWidth + 4;
                    g.translate(labelX, labelY);
                    iconLabel.setSize(iconLabel.getPreferredSize().width, labelHeight);
                    iconLabel.setHorizontalAlignment(4);
                    preItemWidth = iconLabel.getWidth();
                    iconLabel.paint(g);
                    g.translate(-labelX, -labelY);
                    this.saveIconLabelToCache(labelX, labelY, iconLabel, (JPanel)c);
                }
            }
        }

        private void saveIconLabelToCache(int translateX, int translateY, JLabel iconLabel, JPanel panel) {
            Map<JLabel, Rectangle> rectangleLabelMap = this.panelIconLabelLocationMap.get(panel);
            if (rectangleLabelMap == null) {
                rectangleLabelMap = new HashMap<JLabel, Rectangle>();
                this.panelIconLabelLocationMap.put(panel, rectangleLabelMap);
            }
            Rectangle iconRectangle = new Rectangle(translateX, translateY, iconLabel.getWidth(), iconLabel.getHeight());
            rectangleLabelMap.put(iconLabel, iconRectangle);
        }

        public Map<JPanel, Map<JLabel, Rectangle>> getPanelIconLabelLocationMap() {
            return this.panelIconLabelLocationMap;
        }
    }
}

