/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.BackgroundImageBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class ImageButton
extends JPanel
implements ChangeListener,
ActionListener {
    private static final long serialVersionUID = 1L;
    protected BackgroundImageBorder mNormalBorder;
    protected BackgroundImageBorder mPressedBorder;
    protected BackgroundImageBorder mRolloverBorder;
    protected JButton mButton;

    public ImageButton(String text) {
        super(new BorderLayout());
        this.setOpaque(false);
        this.init(text);
    }

    protected void init(String text) {
        super.setBorder(null);
        this.mButton = new JButton(text);
        this.add((Component)this.mButton, "Center");
        this.mButton.setBorder(null);
        this.mButton.setBorderPainted(false);
        this.mButton.setOpaque(false);
        this.mButton.setContentAreaFilled(false);
        this.mButton.setFocusPainted(false);
        this.mButton.setVerticalTextPosition(3);
        this.mButton.setHorizontalTextPosition(0);
        this.mButton.setHorizontalAlignment(0);
        this.mButton.setCursor(Cursor.getPredefinedCursor(12));
        this.mButton.getModel().addChangeListener(this);
        this.mButton.addActionListener(this);
        this.setCursor(Cursor.getPredefinedCursor(12));
        this.setMinimumSize(this.mButton.getPreferredSize());
    }

    public void setNormalImage(Image image, Insets insets) {
        this.mNormalBorder = new BackgroundImageBorder(image, insets);
        this.updateBorder();
        this.imageChanged(image);
    }

    public void setPressedImage(Image image, Insets insets) {
        this.mPressedBorder = new BackgroundImageBorder(image, insets);
        this.updateBorder();
        this.imageChanged(image);
    }

    public void setRolloverImage(Image image, Insets insets) {
        this.mRolloverBorder = new BackgroundImageBorder(image, insets);
        this.updateBorder();
        this.imageChanged(image);
    }

    @Override
    public void setBorder(Border b) {
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource().equals(this.mButton.getModel())) {
            this.updateBorder();
        }
    }

    protected void updateBorder() {
        ButtonModel model = this.mButton.getModel();
        if (model.isArmed() && model.isPressed()) {
            super.setBorder(this.mPressedBorder);
        } else if (model.isRollover()) {
            super.setBorder(this.mRolloverBorder);
        } else {
            super.setBorder(this.mNormalBorder);
        }
    }

    protected void imageChanged(Image image) {
        this.updateMinimumSize(image);
        this.invalidate();
        this.revalidate();
        this.repaint();
    }

    protected void updateMinimumSize(Image image) {
        this.setMinimumSize(new Dimension(Math.max(this.getMinimumSize().width, image.getWidth(this)), Math.max(this.getMinimumSize().height, image.getHeight(this))));
        this.setPreferredSize(this.getMinimumSize());
    }

    @Override
    public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
        this.updateMinimumSize(img);
        return super.imageUpdate(img, infoflags, x, y, width, height);
    }

    public void setActionCommand(String command) {
        this.mButton.setActionCommand(command);
    }

    public String getActionCommand() {
        return this.mButton.getActionCommand();
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ActionEvent event = new ActionEvent(this, e.getID(), e.getActionCommand(), e.getWhen(), e.getModifiers());
        for (ActionListener l : (ActionListener[])this.listenerList.getListeners(ActionListener.class)) {
            l.actionPerformed(event);
        }
    }
}

