/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.util.IPAddressUtil;
import java.text.MessageFormat;

public class IPv6Validator {
    private static final String PREFIX_SYMBOL = "/";
    private static final int SUCCESS = 0;
    private static final int ERROR_EMPTY = 1;
    private static final int ERROR_PREFIX_NOT_ALLOWED = 2;
    private static final int ERROR_PREFIX_REQUIRED = 3;
    private static final int ERROR_INVALID_PREFIX = 4;
    private static final int ERROR_INCORRECT_ADDRESS_FIELDS = 5;
    private static final int ERROR_INVALID_ADDRESS = 6;
    private static final int MAX_ADDRESS_ENTITIES = 2;
    private static final String[] ERROR_MSGS = new String[]{"", MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPv6Validtor.msg.EmptyIP"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPv6Validtor.msg.PrefixNotAllowed"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPv6Validtor.msg.PrefixRequired"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPv6Validtor.msg.InvalidPrefix"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPv6Validtor.msg.IncorrectAddressFields"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPv6Validtor.msg.InvalidIP")};
    private boolean isPrefixRequired;
    private int lastError;
    private String lastValidatedAddress;
    private String allowedChars = "0123456789ABCDEFabcdef:.";

    public IPv6Validator(boolean prefixRequired) {
        this.isPrefixRequired = prefixRequired;
        this.lastError = 0;
        if (prefixRequired) {
            this.allowedChars = this.allowedChars.concat(PREFIX_SYMBOL);
        }
    }

    public static int compare(String startIP, String endIP) {
        byte[] start = IPAddressUtil.textToNumericFormat((String)startIP);
        byte[] end = IPAddressUtil.textToNumericFormat((String)endIP);
        assert (start.length == end.length);
        for (int i = 0; i < start.length; ++i) {
            int startBits = 0xFF & start[i];
            int endBits = 0xFF & end[i];
            if (startBits > endBits) {
                return 1;
            }
            if (startBits >= endBits) continue;
            return -1;
        }
        return 0;
    }

    public boolean isValid(String address) {
        try {
            String[] fields;
            int prefix;
            String[] addressParts;
            if (address == null || address.length() == 0) {
                this.lastError = 1;
                this.lastValidatedAddress = "";
                return false;
            }
            this.lastValidatedAddress = address;
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                for (int i = 0; i < address.length(); ++i) {
                    if (this.allowedChars.contains("" + address.charAt(i))) continue;
                    this.lastError = 6;
                    return false;
                }
            }
            if ((addressParts = address.split(PREFIX_SYMBOL)).length < 1 || addressParts.length > 2) {
                this.lastError = 6;
                return false;
            }
            boolean isPrefixPresent = address.contains(PREFIX_SYMBOL);
            if (!this.isPrefixRequired) {
                if (isPrefixPresent) {
                    this.lastError = 2;
                    return false;
                }
            } else if (!isPrefixPresent || addressParts.length != 2) {
                this.lastError = 3;
                return false;
            }
            if (addressParts.length == 2 && ((prefix = Integer.parseInt(addressParts[1])) <= 0 || prefix > 128)) {
                this.lastError = 4;
                return false;
            }
            if (addressParts[0].equals("::")) {
                this.lastError = 6;
                return false;
            }
            if (!addressParts[0].contains("::") && (fields = addressParts[0].split(":")).length != 8) {
                this.lastError = 5;
                return false;
            }
            if (!IPAddressUtil.isIPv6LiteralAddress((String)addressParts[0])) {
                this.lastError = 6;
                return false;
            }
        }
        catch (NumberFormatException ex) {
            this.lastError = 6;
            return false;
        }
        this.lastError = 0;
        return true;
    }

    public boolean isInputAcceptable(String currentInput, String possibleNewValue) {
        if (currentInput == null || currentInput.length() == 0) {
            return true;
        }
        currentInput = currentInput.toUpperCase();
        for (int i = 0; i < currentInput.length(); ++i) {
            if (this.allowedChars.contains("" + currentInput.charAt(i))) continue;
            return false;
        }
        if (possibleNewValue.matches(".*/.*/.*")) {
            return false;
        }
        if (possibleNewValue.matches(".*:::.*") || possibleNewValue.matches(".*::.*::.*")) {
            return false;
        }
        if (possibleNewValue.matches("^:\\w.*")) {
            return false;
        }
        if (possibleNewValue.matches(".*/.*:.*")) {
            return false;
        }
        if (possibleNewValue.matches(".*\\w\\w\\w\\w\\w.*")) {
            return false;
        }
        if (!possibleNewValue.matches("^::.*") && possibleNewValue.matches(".*::.*") && possibleNewValue.matches(".*:.+:.+:.+:.+:.+:.+:.*")) {
            return false;
        }
        if (possibleNewValue.matches(".*:.+:.+:.+:.+:.+:.+:.*:.*")) {
            return false;
        }
        return !possibleNewValue.matches("[^:]:/");
    }

    public String getLastErrorString() {
        String str = ERROR_MSGS[this.getLastError()];
        assert (str != null);
        switch (this.getLastError()) {
            case 5: 
            case 6: {
                str = MessageFormat.format(str, this.lastValidatedAddress);
                break;
            }
        }
        return str;
    }

    public int getLastError() {
        return this.lastError;
    }
}

