/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.IPv6Field;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class IPv6SubnetPane
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int NO_ERROR = 0;
    public static final int ERR_WRONG_IP = 1;
    private String errorMessage = "";
    private IPv6Field ipv6Field = new IPv6Field(true);
    private JComponent[][] objs = new JComponent[2][2];

    public IPv6SubnetPane() {
        try {
            this.init();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public String getText() {
        return this.ipv6Field.getText();
    }

    public void setText(String ip) {
        this.ipv6Field.setText(ip);
    }

    public boolean isValidValue() {
        if (!this.ipv6Field.isValidValue()) {
            this.errorMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "SubnetPane.msg.wrongSubnetAddress");
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void requestFocus() {
        this.ipv6Field.requestFocus();
    }

    public JLabel getIpLabel() {
        try {
            return (JLabel)this.objs[0][1];
        }
        catch (Exception e) {
            JOptionPane.showMessageDialog(Manager.frame, "Illegal Casting, please check index", "Casting Error", 0);
            LoggerUtilities.logException((Throwable)e);
            return null;
        }
    }

    public void setLeftLabelSize(Dimension d) {
        this.getIpLabel().setPreferredSize(d);
        this.updateUI();
    }

    public Dimension getLeftLabelSize() {
        return this.getIpLabel().getPreferredSize();
    }

    private void init() throws Exception {
        this.ipv6Field.setPreferredSize(new Dimension(150, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagConstraints gbCon = new GridBagConstraints();
        this.objs[0][0] = new JLabel();
        this.objs[1][0] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "Ipv6SubnetPane.label.subnetExample"));
        JLabel label1 = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "Ipv6SubnetPane.label.subnetAddress"));
        this.objs[0][1] = label1;
        this.objs[1][1] = this.ipv6Field;
        int w = Math.max(label1.getPreferredSize().width, 120);
        label1.setPreferredSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        label1.setMinimumSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        for (int i = 0; i < this.objs.length; ++i) {
            for (int j = 0; j < this.objs[i].length; ++j) {
                gbCon.gridx = i;
                gbCon.gridy = j;
                gbCon.anchor = 17;
                gbCon.weighty = 0.0;
                gbCon.insets = new Insets(0, 0, 2, 10);
                if (i == 1) {
                    gbCon.weightx = 0.5;
                    gbCon.gridwidth = 0;
                    gbCon.fill = 2;
                    gbCon.insets = new Insets(0, 10, 2, 0);
                    if (j == 0 || j == 2) {
                        gbCon.insets = new Insets(5, 10, 0, 0);
                        gbCon.anchor = 16;
                    }
                } else {
                    gbCon.gridwidth = 1;
                    gbCon.weightx = 0.0;
                }
                this.add((Component)this.objs[i][j], gbCon);
            }
        }
    }
}

