/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.ui.util.IPv6Field;
import com.sygate.scm.console.ui.util.IPv6Validator;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class IPv6RangePane
extends JPanel {
    private static final long serialVersionUID = 1L;
    public static final int NO_ERROR = 0;
    public static final int ERR_WRONG_START = 1;
    public static final int ERR_WRONG_END = 2;
    public static final int ERR_END_SMALL = 3;
    private String errorMessage = "";
    private int errorCode = 0;
    private IPv6Field fromIP = new IPv6Field(false);
    private IPv6Field toIP = new IPv6Field(false);
    private JComponent[][] objs = new JComponent[2][4];

    public IPv6RangePane() {
        try {
            this.init();
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public String getText() {
        String from = this.fromIP.getText();
        String to = this.toIP.getText();
        if (from.length() == 0) {
            return to;
        }
        if (to.length() == 0) {
            return from;
        }
        return from + "-" + to;
    }

    public String getFromIP() {
        return this.fromIP.getText();
    }

    public String getToIP() {
        return this.toIP.getText();
    }

    public void setFromIP(String from) {
        this.fromIP.setText(from);
    }

    public void setToIP(String to) {
        this.toIP.setText(to);
    }

    public boolean isValidValue() {
        if (!this.fromIP.isValidValue()) {
            this.errorCode = 1;
            this.errorMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "Ipv6RangePane.msg.wrongStartIP");
            return false;
        }
        if (!this.toIP.isValidValue()) {
            this.errorCode = 2;
            this.errorMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "Ipv6RangePane.msg.wrongEndIP");
            return false;
        }
        if (IPv6Validator.compare(this.fromIP.getText(), this.toIP.getText()) > 0) {
            this.errorCode = 3;
            this.errorMessage = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "Ipv6RangePane.msg.EndIPIsSmaller");
            return false;
        }
        return true;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void requestFocus() {
        switch (this.errorCode) {
            case 1: {
                this.fromIP.requestFocus();
                break;
            }
            case 2: {
                this.toIP.requestFocus();
                break;
            }
            case 3: {
                this.toIP.requestFocus();
                break;
            }
        }
    }

    public void setLabelText(int i, int j, String text) {
        try {
            ((JLabel)this.objs[i][j]).setText(text);
            this.updateUI();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.frame, "Illegal Casting, please check index", "Casting Error", 0);
        }
    }

    public void setLabelSize(int i, int j, int w, int h) {
        try {
            ((JLabel)this.objs[i][j]).setPreferredSize(new Dimension(w, h));
            this.updateUI();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.frame, "Illegal Casting, please check index", "Casting Error", 0);
        }
    }

    public void setLeftLabelSize(Dimension dim) {
        try {
            ((JLabel)this.objs[0][1]).setPreferredSize(dim);
            ((JLabel)this.objs[0][3]).setPreferredSize(dim);
            this.updateUI();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Manager.frame, "Illegal Casting, please check index", "Casting Error", 0);
        }
    }

    public JLabel getStartLabel() {
        try {
            return (JLabel)this.objs[0][1];
        }
        catch (ClassCastException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    public JLabel getEndLabel() {
        try {
            return (JLabel)this.objs[0][3];
        }
        catch (ClassCastException ex) {
            LoggerUtilities.logException((Throwable)ex);
            return null;
        }
    }

    public Dimension getLeftLabelSize() {
        return ((JLabel)this.objs[0][1]).getPreferredSize();
    }

    private void init() throws Exception {
        this.fromIP.setPreferredSize(new Dimension(150, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.toIP.setPreferredSize(new Dimension(150, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        GridBagLayout gbLayout = new GridBagLayout();
        this.setLayout(gbLayout);
        this.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        GridBagConstraints gbCon = new GridBagConstraints();
        this.objs[0][0] = new JLabel();
        this.objs[1][0] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "Ipv6RangePane.label.ipv6Example"));
        JLabel label1 = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "Ipv6RangePane.label.start"));
        this.objs[0][1] = label1;
        this.objs[1][1] = this.fromIP;
        this.objs[0][2] = new JLabel();
        this.objs[1][2] = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "Ipv6RangePane.label.ipv6Example2"));
        JLabel label2 = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "Ipv6RangePane.lable.end"));
        int w = Math.max(label1.getPreferredSize().width, 120);
        w = Math.max(w, label2.getPreferredSize().width);
        label1.setPreferredSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        label1.setMinimumSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        label2.setPreferredSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        label2.setMinimumSize(new Dimension(w, UIUtilities.PREFERRED_TEXTFIELD_HEIGHT));
        this.objs[0][3] = label2;
        this.objs[1][3] = this.toIP;
        for (int i = 0; i < this.objs.length; ++i) {
            for (int j = 0; j < this.objs[i].length; ++j) {
                gbCon.gridx = i;
                gbCon.gridy = j;
                gbCon.anchor = 17;
                gbCon.weighty = 0.0;
                gbCon.insets = new Insets(0, 0, 2, 10);
                if (i == 1) {
                    gbCon.weightx = 0.5;
                    gbCon.gridwidth = 0;
                    gbCon.fill = 2;
                    gbCon.insets = new Insets(0, 10, 2, 0);
                    if (j == 0 || j == 2) {
                        gbCon.insets = new Insets(5, 10, 0, 0);
                        gbCon.anchor = 16;
                    }
                } else {
                    gbCon.gridwidth = 1;
                    gbCon.weightx = 0.0;
                }
                this.add((Component)this.objs[i][j], gbCon);
            }
        }
    }

    public void setEnable(boolean isEnable) {
        this.fromIP.setEnabled(isEnable);
        this.toIP.setEnabled(isEnable);
    }
}

