/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.console.ui.util.IPv6Validator;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.awt.Toolkit;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IPv6Field
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTextField ipv6TextField;
    private boolean allowPrefix = false;
    private IPv6Document ipv6Document;

    public IPv6Field(boolean allowPrefix) {
        this.allowPrefix = allowPrefix;
        this.ipv6Document = new IPv6Document(this.allowPrefix);
        this.initialize();
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.ipv6TextField.setEnabled(enabled);
        if (enabled) {
            this.setBackground(Color.white);
            this.ipv6TextField.setBackground(SystemColor.white);
        } else {
            this.setBackground(SystemColor.control);
            this.ipv6TextField.setBackground(SystemColor.control);
        }
    }

    @Override
    public void requestFocus() {
        this.ipv6TextField.requestFocus();
    }

    public String getText() {
        return this.ipv6TextField.getText();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setText(String address) {
        if (address != null) {
            assert (this.ipv6Document.getIPv6Validtor() != null);
            if (!this.ipv6Document.getIPv6Validtor().isValid(address)) throw new IllegalArgumentException(this.getErrorMessage());
            this.ipv6TextField.setText(address);
            return;
        } else {
            this.ipv6TextField.setText("");
        }
    }

    public boolean isValidValue() {
        assert (this.ipv6Document.getIPv6Validtor() != null);
        return this.ipv6Document.getIPv6Validtor().isValid(this.ipv6TextField.getText());
    }

    public String getErrorMessage() {
        assert (this.ipv6Document.getIPv6Validtor() != null);
        assert (this.ipv6Document.getIPv6Validtor().getLastErrorString() != null);
        return this.ipv6Document.getIPv6Validtor().getLastErrorString();
    }

    private void initialize() {
        this.setLayout(new GridLayout(1, 0));
        this.ipv6TextField = new JTextField(75);
        this.ipv6TextField.setDocument(this.ipv6Document);
        this.add(this.ipv6TextField);
    }

    private static class IPv6Document
    extends PlainDocument {
        private static final long serialVersionUID = 1L;
        private IPv6Validator ipv6Validator;

        public IPv6Document(boolean allowPrefix) {
            this.setIPv6Validtor(new IPv6Validator(allowPrefix));
        }

        public void setIPv6Validtor(IPv6Validator ipv6Validator) {
            this.ipv6Validator = ipv6Validator;
        }

        public IPv6Validator getIPv6Validtor() {
            return this.ipv6Validator;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void insertString(int offs, String str, AttributeSet attr) throws BadLocationException {
            if (str == null) {
                super.insertString(offs, null, attr);
                return;
            }
            str = str.toUpperCase();
            if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                super.insertString(offs, str, attr);
                return;
            }
            String existingValue = super.getText(0, this.getLength());
            Object possibleNewValue = "";
            if (existingValue != null && existingValue.length() > 0) {
                String firstPart = existingValue.substring(0, offs);
                String secondPart = existingValue.substring(offs);
                possibleNewValue = firstPart + str + secondPart;
            } else {
                possibleNewValue = str;
            }
            if (this.getIPv6Validtor().isInputAcceptable(str, (String)possibleNewValue)) {
                super.insertString(offs, str, attr);
                return;
            }
            Toolkit.getDefaultToolkit().beep();
        }
    }
}

