/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

public class IPField
extends JPanel {
    private static final long serialVersionUID = 1L;
    private IPTextField[] fields;
    private JLabel[] dots;
    private static final String loopBackAddr = "127";
    private boolean rangeValidate;

    public IPField() {
        this.initialize();
    }

    public IPField(boolean rangeValidate) {
        this.rangeValidate = rangeValidate;
        this.initialize();
    }

    public String getText() {
        String[] parts = new String[4];
        for (int i = 0; i < 4; ++i) {
            parts[i] = this.getField(i).getText();
            if (this.isValidIPPart(parts[i], true)) continue;
            return "";
        }
        return this.getZeroTrimedString(parts[0]) + "." + this.getZeroTrimedString(parts[1]) + "." + this.getZeroTrimedString(parts[2]) + "." + this.getZeroTrimedString(parts[3]);
    }

    public void setText(String address) throws IllegalArgumentException {
        if (address == null || address.trim().length() == 0) {
            for (int i = 0; i < 4; ++i) {
                this.getField(i).setText("");
            }
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(address, ".");
        int tokens = tokenizer.countTokens();
        if (tokens != 4) {
            throw new IllegalArgumentException(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPField.msg.theIPAddressDoesNotHave"));
        }
        String[] parts = new String[4];
        for (int i = 0; i < 4; ++i) {
            String token = tokenizer.nextToken();
            if (!this.isValidIPPart(token, true)) {
                Object[] obj = new Object[]{token};
                String str = MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPField.msg.isNotValidIP");
                String fm = MessageFormat.format(str, obj);
                throw new IllegalArgumentException(fm);
            }
            parts[i] = token;
        }
        this.setIPParts(parts);
    }

    public void setIPParts(String[] parts) {
        for (int i = 0; i < 4; ++i) {
            this.getField(i).setText(parts[i]);
        }
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        int horizontalInset = 2;
        int verticalInset = 2;
        int labelWidth = 4;
        int textFieldWidth = (width - 3 * labelWidth - 2 * horizontalInset) / 4;
        int startX = horizontalInset;
        int fieldHeight = height - verticalInset * 2;
        for (int i = 0; i < 4; ++i) {
            this.getField(i).setBounds(startX, verticalInset, textFieldWidth, fieldHeight);
            startX += textFieldWidth;
            if (i == 3) continue;
            this.getDot(i).setBounds(startX, verticalInset, labelWidth, fieldHeight);
            startX += labelWidth;
        }
        super.setBounds(x, y, width, height);
    }

    @Override
    public void setBounds(Rectangle r) {
        this.setBounds(r.x, r.y, r.width, r.height);
    }

    @Override
    public void setEnabled(boolean enabled) {
        for (int i = 0; i < 4; ++i) {
            this.getField(i).setEnabled(enabled);
        }
        if (enabled) {
            this.setBackground(Color.white);
        } else {
            this.setBackground(SystemColor.control);
        }
    }

    @Override
    public void requestFocus() {
        this.getField(0).requestFocus();
    }

    @Override
    public boolean isValid() {
        return this.isValid(true);
    }

    public boolean isValid(boolean checkTextLength) {
        String[] parts = new String[4];
        for (int i = 0; i < 4; ++i) {
            parts[i] = this.getField(i).getText();
            if (this.isValidIPPart(parts[i], checkTextLength)) continue;
            return false;
        }
        return true;
    }

    public long getValue() {
        long value = 0L;
        for (int i = 0; i < 4; ++i) {
            value = (value << 8) + (long)Integer.parseInt(this.getField(i).getText());
        }
        return value;
    }

    private void initialize() {
        this.setLayout(null);
        this.setBorder(new JTextField().getBorder());
        this.setBackground(Color.white);
        for (int i = 0; i < 4; ++i) {
            this.add(this.getField(i));
            if (i == 3) continue;
            this.add(this.getDot(i));
        }
    }

    private IPTextField getField(int position) {
        if (this.fields == null) {
            this.fields = new IPTextField[4];
            for (int i = 0; i < 4; ++i) {
                this.fields[i] = new IPTextField(new IPPartDocument(), null, 3, i);
                this.fields[i].setHorizontalAlignment(0);
                this.fields[i].getDocument().addDocumentListener(this.getDocumentListener(i));
                this.fields[i].setOpaque(false);
                this.fields[i].setBorder(null);
            }
        }
        return this.fields[position];
    }

    private JLabel getDot(int position) {
        if (this.dots == null) {
            this.dots = new JLabel[3];
            for (int i = 0; i < 3; ++i) {
                this.dots[i] = this.createNewDot();
            }
        }
        return this.dots[position];
    }

    private void tabToNextPart(int focussedPart, boolean isClearSelection) {
        if (focussedPart != 3) {
            IPTextField field = this.getField(focussedPart + 1);
            field.requestFocus(false);
            if (isClearSelection) {
                field.clearSelection(true);
            }
        }
    }

    private void tabToNextPart(int focussedPart, boolean isClearSelection, boolean validateRange) {
        if (focussedPart == 0) {
            if (this.getField(focussedPart).getText().trim().equals(loopBackAddr)) {
                JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SearchByDlg.errorExcludeLoopBackAddressRangeMsg"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.client.dlg.clientdialog", "SearchByDlg.error"), 0);
            }
            this.tabToNextPart(focussedPart, isClearSelection);
        } else {
            this.tabToNextPart(focussedPart, isClearSelection);
        }
    }

    protected void tabToPreviousPart(int focussedPart, boolean isClearSelection) {
        if (focussedPart != 0) {
            IPTextField field = this.getField(focussedPart - 1);
            field.requestFocus(false);
            if (isClearSelection) {
                field.clearSelection(false);
            }
        }
    }

    private DocumentListener getDocumentListener(final int i) {
        return new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                IPField.this.IPValueChanged(i, e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                IPField.this.IPValueChanged(i, e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                IPField.this.IPValueChanged(i, e);
            }
        };
    }

    private void IPValueChanged(int part, DocumentEvent e) {
        if (part == 3) {
            return;
        }
        int docLength = e.getDocument().getLength();
        switch (docLength) {
            case 3: {
                if (this.rangeValidate) {
                    this.tabToNextPart(part, false, this.rangeValidate);
                    break;
                }
                this.tabToNextPart(part, false);
                break;
            }
        }
    }

    private JLabel createNewDot() {
        JLabel dot = new JLabel(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "IPField.label.dot"));
        dot.setVerticalAlignment(3);
        return dot;
    }

    private String getZeroTrimedString(String orig) {
        while (orig != null && orig.charAt(0) == '0' && orig.length() != 1) {
            orig = orig.substring(1);
        }
        return orig;
    }

    private boolean isValidIPPart(String valueAsString, boolean checkTextLength) {
        if (valueAsString.length() == 0) {
            return !checkTextLength;
        }
        int valueAsInt = -1;
        try {
            valueAsInt = Integer.parseInt(valueAsString);
            return valueAsInt >= 0 && valueAsInt <= 255;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private class IPTextField
    extends JTextField {
        private static final long serialVersionUID = 1L;
        private int position;

        public IPTextField(Document document, String text, int columns, int position) {
            super(document, text, columns);
            this.position = position;
        }

        @Override
        public boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
            JTextField field = (JTextField)e.getSource();
            Caret caret = field.getCaret();
            int code = e.getKeyCode();
            if ((code == 8 || code == 37) && this.position != 0) {
                if (pressed && condition == 0 && caret.getDot() == 0 && caret.getMark() == 0) {
                    IPField.this.tabToPreviousPart(this.position, code == 37);
                    return false;
                }
            } else {
                if ((code == 46 || code == 110) && this.position != 3) {
                    if (pressed && condition == 0 && field.getText().trim().length() > 0 && caret.getDot() == caret.getMark()) {
                        IPField.this.tabToNextPart(this.position, false);
                    }
                    return false;
                }
                if (code == 39 && this.position != 3 && pressed && caret.getDot() == caret.getMark() && caret.getDot() == field.getText().trim().length()) {
                    IPField.this.tabToNextPart(this.position, true);
                    return false;
                }
            }
            return super.processKeyBinding(ks, e, condition, pressed);
        }

        @Override
        public boolean requestFocus(boolean temporary) {
            this.selectAll();
            return super.requestFocus(temporary);
        }

        public void clearSelection(boolean isFirstPosition) {
            int pos = isFirstPosition ? 0 : this.getText().trim().length();
            this.select(pos, pos);
        }
    }

    private static class IPPartDocument
    extends PlainDocument {
        private static final long serialVersionUID = 1L;

        private IPPartDocument() {
        }

        @Override
        public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
            String existingValue = super.getText(0, this.getLength());
            Object possibleNewValue = "";
            if (existingValue != null && existingValue.length() > 0) {
                String firstPart = existingValue.substring(0, offs);
                String secondPart = existingValue.substring(offs);
                possibleNewValue = firstPart + str + secondPart;
            } else {
                possibleNewValue = str;
            }
            if (this.isAcceptableIPPart((String)possibleNewValue)) {
                String strAnsi = Integer.valueOf(str.trim()).toString();
                super.insertString(offs, strAnsi, a);
            } else if (!str.equals(".")) {
                Toolkit.getDefaultToolkit().beep();
            }
        }

        private boolean isAcceptableIPPart(String valueAsString) {
            if (valueAsString == null || valueAsString.length() == 0) {
                return true;
            }
            if (valueAsString.length() > 3) {
                return false;
            }
            int valueAsInt = -1;
            try {
                valueAsInt = Integer.parseInt(valueAsString);
                return valueAsInt >= 0 && valueAsInt <= 255;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }
}

