/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.creamtec.ajaxswing.support.validation.AjaxSwingDocumentValidator;
import java.awt.Toolkit;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class HexNumberDocument
extends PlainDocument
implements AjaxSwingDocumentValidator {
    private static final long serialVersionUID = 1L;
    private long max;

    public HexNumberDocument() {
        this.max = Long.MAX_VALUE;
    }

    public HexNumberDocument(long max) {
        this.max = max;
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (str == null || str.length() == 0) {
            super.insertString(offs, str, a);
            return;
        }
        try {
            long i;
            String text = this.getText(0, this.getLength());
            String newStr = text.substring(0, offs) + str + text.substring(offs);
            if (newStr.equalsIgnoreCase("0") || newStr.equalsIgnoreCase("0x")) {
                super.insertString(offs, str, a);
                return;
            }
            boolean isHex = false;
            if (newStr.startsWith("0x") || newStr.startsWith("0X")) {
                isHex = true;
            }
            if (isHex) {
                String subStr = newStr.substring(2);
                i = Long.parseLong(subStr, 16);
            } else {
                i = Long.parseLong(newStr);
            }
            if (i <= this.max) {
                int pos;
                super.insertString(offs, str, a);
                text = this.getText(0, this.getLength());
                for (pos = 0; pos < this.getLength() - 1 && '0' == text.charAt(pos) && ('0' != text.charAt(pos) || 'x' != text.charAt(pos + 1) && 'X' != text.charAt(pos + 1)); ++pos) {
                }
                this.remove(0, pos);
            } else {
                Toolkit.getDefaultToolkit().beep();
            }
        }
        catch (RuntimeException e) {
            Toolkit.getDefaultToolkit().beep();
        }
        catch (Exception e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    public long getMax() {
        return this.max;
    }

    public HashMap<String, Object> getParams() {
        HashMap<String, Object> validatorParams = new HashMap<String, Object>();
        validatorParams.put("name", "HexNumberDocument");
        validatorParams.put("min", 0);
        validatorParams.put("max", this.max);
        return validatorParams;
    }
}

