/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.AjaxSwingCommonUtil;
import com.sygate.scm.common.ui.ClientAgent;
import com.sygate.scm.common.ui.UIColorUtilities;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.util.URLUtility;
import java.awt.Color;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.html.HTML;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public class HTMLEditorPane
extends JEditorPane {
    private static final long serialVersionUID = 1L;
    private static final MessageResources MSGRES = MessageResources.getInstance();
    private Element highlightedElement = null;

    public HTMLEditorPane() {
        this.init();
        this.attachHighlightListener();
        this.attachClickListener();
    }

    public HTMLEditorPane(HyperlinkListener hyperlinkListener) {
        this.init();
        this.attachHighlightListener();
        this.addHyperlinkListener(hyperlinkListener);
    }

    private void init() {
        this.setEditable(false);
        this.setOpaque(false);
        this.setContentType("text/html");
        HTMLDocument doc = (HTMLDocument)this.getDocument();
        StyleSheet ss = doc.getStyleSheet();
        ss.addRule(".highlight {color: " + UIColorUtilities.colorToString((Color)UIColorUtilities.LINK_HOVER_FOREGROUND) + "; text-decoration: underline; cursor: hand;}");
        this.setDocument(doc);
    }

    private void removeHighlightForElement(Element el) {
        MutableAttributeSet muAttrSet;
        Object o;
        AttributeSet attrs;
        if (null != el && null != (attrs = el.getAttributes()) && null != (o = attrs.getAttribute(HTML.Tag.A)) && o instanceof MutableAttributeSet && (muAttrSet = (MutableAttributeSet)o).getAttribute(HTML.Attribute.CLASS) != null) {
            if (muAttrSet.containsAttribute("noHover", "true")) {
                return;
            }
            muAttrSet.removeAttribute(HTML.Attribute.CLASS);
            this.updateUI();
            this.highlightedElement = null;
        }
    }

    private void attachHighlightListener() {
        MouseAdapter adapter = new MouseAdapter(){

            @Override
            public void mouseExited(MouseEvent me) {
                MutableAttributeSet muAttrSet;
                Object o;
                AttributeSet attrs;
                if (null != HTMLEditorPane.this.highlightedElement && null != (attrs = HTMLEditorPane.this.highlightedElement.getAttributes()) && null != (o = attrs.getAttribute(HTML.Tag.A)) && o instanceof MutableAttributeSet && (muAttrSet = (MutableAttributeSet)o).getAttribute(HTML.Attribute.CLASS) != null) {
                    muAttrSet.removeAttribute(HTML.Attribute.CLASS);
                    HTMLEditorPane.this.updateUI();
                    HTMLEditorPane.this.highlightedElement = null;
                }
            }
        };
        this.addMouseListener(adapter);
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ENTERED) {
                    Object o;
                    AttributeSet attrs;
                    Element el = e.getSourceElement();
                    if (null != el && null != (attrs = el.getAttributes()) && null != (o = attrs.getAttribute(HTML.Tag.A)) && o instanceof MutableAttributeSet) {
                        MutableAttributeSet muAttrSet = (MutableAttributeSet)o;
                        if (muAttrSet.containsAttribute("noHover", "true")) {
                            return;
                        }
                        muAttrSet.addAttribute(HTML.Attribute.CLASS, "highlight");
                        HTMLEditorPane.this.updateUI();
                        HTMLEditorPane.this.highlightedElement = el;
                    }
                } else {
                    HTMLEditorPane.this.removeHighlightForElement(e.getSourceElement());
                }
            }
        });
    }

    private void attachClickListener() {
        this.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    HTMLEditorPane.this.removeHighlightForElement(e.getSourceElement());
                    String strURL = null;
                    if (e.getURL() == null) {
                        return;
                    }
                    strURL = e.getURL().toString();
                    if (AjaxSwingCommonUtil.isAjaxSwingRunning()) {
                        ClientAgent.getCurrentInstance().openInNewTab(strURL);
                        return;
                    }
                    int urlRet = URLUtility.browseURI((String)strURL);
                    String msg = null;
                    switch (urlRet) {
                        case 1: {
                            msg = MSGRES.getString("com.sygate.scm.console.ui.util.uiutil", "BrowseURI.error.ErrorURL");
                            UIUtilities.showErrorDialog(msg);
                            break;
                        }
                        case 3: {
                            msg = MSGRES.getString("com.sygate.scm.console.ui.util.uiutil", "BrowseURI.error.NeedDefaultBrowser");
                            UIUtilities.showErrorDialog(msg);
                            break;
                        }
                        case 2: {
                            msg = MSGRES.getString("com.sygate.scm.console.ui.util.uiutil", "BrowseURI.error.OSCannotSupport");
                            UIUtilities.showErrorDialog(msg);
                            break;
                        }
                    }
                    HTMLEditorPane.this.highlightedElement = null;
                }
            }
        });
    }
}

