/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.ui.util.renderer.CustomTreeCellRenderer;
import com.sygate.scm.util.LoggerUtilities;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GroupTree
extends JTree {
    private static final long serialVersionUID = 1L;

    public GroupTree() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
    }

    public boolean init() throws Exception {
        this.initModel();
        this.initAttrs();
        return true;
    }

    private void initModel() throws Exception {
        DefaultTreeModel treeModel = new DefaultTreeModel(GroupHandler.getGroupsRoot(false, true));
        this.setModel(treeModel);
    }

    private void initAttrs() {
        this.setVisibleRowCount(10);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setCellRenderer(new CustomTreeCellRenderer());
        this.getSelectionModel().setSelectionMode(1);
    }

    public GroupObject getSelectedGroup() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node == null) {
            return null;
        }
        return (GroupObject)node.getUserObject();
    }

    public void setSelected(String groupId) {
        DefaultMutableTreeNode node = this.searchGroup(groupId);
        if (node == null) {
            return;
        }
        TreePath path = new TreePath(node.getPath());
        this.setSelectionPath(path);
    }

    private DefaultMutableTreeNode searchGroup(String groupId) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return null;
        }
        return this.searchGroup(node, groupId);
    }

    private DefaultMutableTreeNode searchGroup(DefaultMutableTreeNode nodeParent, String groupId) {
        if (nodeParent == null) {
            return null;
        }
        if (groupId == null || groupId.length() == 0) {
            return null;
        }
        GroupObject group = (GroupObject)nodeParent.getUserObject();
        if (group.getId().equals(groupId)) {
            return nodeParent;
        }
        if (nodeParent.getChildCount() == 0) {
            return null;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)nodeParent.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            DefaultMutableTreeNode node = this.searchGroup(nodeChild, groupId);
            if (node == null) continue;
            return node;
        }
        return null;
    }
}

