/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.console.handler.GroupHandler;
import com.sygate.scm.console.logicobject.AdminPrivilegeObject;
import com.sygate.scm.console.logicobject.GroupObject;
import com.sygate.scm.console.ui.util.renderer.CustomCheckTreeCellRenderer;
import com.sygate.scm.console.ui.util.renderer.CustomTreeCellRenderer;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public class GroupCheckBoxTree
extends JTree {
    private static final long serialVersionUID = -728750558715142659L;
    public static final int SELECTIONMODE_SINGLE = 0;
    public static final int SELECTIONMODE_INCLUDECHILDREN_SELECTED = 1;
    public static final int SELECTIONMODE_INCLUDECHILDREN_UNSELECTED = 2;
    public static final int SELECTIONMODE_INCLUDECHILDREN_SELECTEDORUNSELECTED = 3;
    public static final int SELECTIONMODE_INCLUDECHILDREN_ALLORNONE = 4;
    protected static final int CHECKMODE_SELECTED = 1;
    protected static final int CHECKMODE_UNSELECTED = 0;
    protected static final int CHECKMODE_TOGGLED = -1;
    private static final int NO_ACCESS_ALL = -1;
    private static final int NO_ACCESS_SELF = 0;
    private static final int HAS_ACCESS_SELF = 1;
    private int selectionMode = 0;
    private boolean enabledPopupMenu = true;
    private String domainId = null;
    public static final String PROPERTYCHANGE_CHECK = "check";
    public static final int DISABLE_MULTIPLE_SELECTION = 5;
    private DefaultMutableTreeNode currentSelectedNode;
    private boolean m_isAllSelected = false;
    ArrayList<String> m_listAllowed = new ArrayList();
    ArrayList<String> m_listDisallowed = new ArrayList();

    public static GroupCheckBoxTree newInstanceForSearchClient() {
        return new SearchClientGroupCheckBoxTree();
    }

    public GroupCheckBoxTree() {
        try {
            this.jbInit();
            this.setShowsRootHandles(true);
            this.putClientProperty("JTree.lineStyle", "Angled");
            ToolTipManager.sharedInstance().registerComponent(this);
        }
        catch (Exception ex) {
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    private void jbInit() throws Exception {
    }

    public boolean init(String domainId, boolean checkAdminPrivilege, boolean isMove) throws Exception {
        this.domainId = domainId;
        DefaultMutableTreeNode rootNode = this.getTreeNode(domainId, checkAdminPrivilege);
        if (rootNode == null) {
            return false;
        }
        DefaultTreeModel treeModel = new DefaultTreeModel(rootNode);
        this.setModel(treeModel);
        if (isMove) {
            this.setCellRenderer(new CustomTreeCellRenderer());
            this.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent ex) {
                    GroupCheckBoxTree.this.treeValueChanged();
                }
            });
        } else {
            this.setCellRenderer(new CustomCheckTreeCellRenderer());
            this.addMouseListener(new NodeSelectionListener(this));
        }
        return true;
    }

    DefaultMutableTreeNode getTreeNode(String domainId, boolean checkAdminPrivilege) throws ConsoleException {
        DefaultMutableTreeNode rootNode = GroupHandler.getGroups(false, domainId, checkAdminPrivilege, true);
        return rootNode;
    }

    public void setRootSelectable(boolean selectable) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return;
        }
        GroupObject group = (GroupObject)node.getUserObject();
        group.setDirectiveSelectable(selectable);
        ((DefaultTreeModel)this.getModel()).nodeChanged(node);
    }

    public boolean isSameDomain(String domainId) {
        if (domainId == null || domainId.length() < 1) {
            return false;
        }
        return domainId.equals(this.domainId);
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public boolean isPopupMenuEnabled() {
        return this.enabledPopupMenu;
    }

    public void setPopupMenuEnabled(boolean enabled) {
        this.enabledPopupMenu = enabled;
    }

    public DefaultMutableTreeNode searchGroup(String groupId) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return null;
        }
        return this.searchGroup(node, groupId);
    }

    private DefaultMutableTreeNode searchGroup(DefaultMutableTreeNode nodeParent, String groupId) {
        if (nodeParent == null) {
            return null;
        }
        if (groupId == null || groupId.length() == 0) {
            return null;
        }
        GroupObject group = (GroupObject)nodeParent.getUserObject();
        if (group.getId().equals(groupId)) {
            return nodeParent;
        }
        if (nodeParent.getChildCount() == 0) {
            return null;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)nodeParent.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            DefaultMutableTreeNode node = this.searchGroup(nodeChild, groupId);
            if (node == null) continue;
            return node;
        }
        return null;
    }

    public boolean setSelectedAll(boolean isSelected, boolean checkSelectable) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return false;
        }
        boolean result = this.setSelectedAll(node, isSelected, checkSelectable);
        return result;
    }

    private boolean fireSelectionChange(GroupObject group, boolean isSelected, boolean checkSelectable) {
        return this.fireSelectionChange(group, isSelected, checkSelectable, true);
    }

    private boolean fireSelectionChange(GroupObject group, boolean isSelected, boolean checkSelectable, boolean checkEnableUI) {
        if (checkSelectable && !group.canDirectiveSelectable()) {
            System.out.println("GroupCheckBoxTree>> fireSelectionChange: NOT Selectable! group=" + group.getName());
            return false;
        }
        if (checkEnableUI && !group.isEnabledUI()) {
            System.out.println("GroupCheckBoxTree>> fireSelectionChange: NO EnabledUI! group=" + group.getName());
            return false;
        }
        System.out.println("GroupCheckBoxTree>> fireSelectionChange: isSelected=" + isSelected + ", group=" + group.getName());
        group.setSelected(isSelected);
        PropertyChangeListener[] listeners = this.getPropertyChangeListeners(PROPERTYCHANGE_CHECK);
        if (listeners != null) {
            for (PropertyChangeListener listener : listeners) {
                listener.propertyChange(new PropertyChangeEvent(this, PROPERTYCHANGE_CHECK, group, group));
            }
        }
        return true;
    }

    private boolean setSelectedAll(DefaultMutableTreeNode nodeParent, boolean isSelected, boolean checkSelectable) {
        if (nodeParent == null) {
            return false;
        }
        GroupObject group = (GroupObject)nodeParent.getUserObject();
        if (this.fireSelectionChange(group, isSelected, checkSelectable)) {
            ((DefaultTreeModel)this.getModel()).nodeChanged(nodeParent);
        }
        if (nodeParent.getChildCount() == 0) {
            return true;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)nodeParent.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            this.setSelectedAll(nodeChild, isSelected, checkSelectable);
        }
        return true;
    }

    public boolean setSelected(boolean isSelected, String groupId, boolean checkSelectable) {
        return this.setSelected(isSelected, groupId, checkSelectable, false);
    }

    public boolean setSelected(boolean isSelected, String groupId, boolean checkSelectable, boolean checkEnableUI) {
        DefaultMutableTreeNode node = this.searchGroup(groupId);
        if (node == null) {
            return false;
        }
        GroupObject group = (GroupObject)node.getUserObject();
        if (this.fireSelectionChange(group, isSelected, checkSelectable, checkEnableUI)) {
            this.currentSelectedNode = node;
            ((DefaultTreeModel)this.getModel()).nodeChanged(node);
        }
        return true;
    }

    public boolean setSelected(ArrayList<String> list, boolean checkSelectable) {
        return this.setSelected(list, checkSelectable, false);
    }

    public boolean setSelected(ArrayList<String> list, boolean checkSelectable, boolean checkEnableUI) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            String groupId = list.get(i);
            this.setSelected(true, groupId, checkSelectable, checkEnableUI);
        }
        return true;
    }

    public boolean getSelectedObject(ArrayList<GroupObject> list, boolean filterOutRoot) {
        if (list == null) {
            return false;
        }
        list.clear();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return false;
        }
        this.m_isAllSelected = true;
        if (!filterOutRoot) {
            this.getSelectedObjectFromNode(node, list);
        }
        this.getSelectedObjectFromParent(node, list);
        if (list.size() == 0) {
            this.m_isAllSelected = false;
        }
        return this.m_isAllSelected;
    }

    public boolean getSelection(ArrayList<String> list, boolean filterOutRoot, boolean checkEnableUI) {
        if (list == null) {
            return false;
        }
        list.clear();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return false;
        }
        this.m_isAllSelected = true;
        if (!filterOutRoot) {
            this.getSelectionFromNode(node, list, checkEnableUI);
        }
        this.getSelectionFromParent(node, list, checkEnableUI);
        if (list.size() == 0) {
            this.m_isAllSelected = false;
        }
        return this.m_isAllSelected;
    }

    private boolean getSelectionFromNode(DefaultMutableTreeNode node, ArrayList<String> resultList, boolean checkEnableUI) {
        GroupObject group;
        Object nodeObject = node.getUserObject();
        if (nodeObject instanceof GroupObject && (group = (GroupObject)nodeObject).isSelected() && group.isEnabledUI() && checkEnableUI) {
            resultList.add(group.getId());
            return true;
        }
        return false;
    }

    private boolean getSelectionFromParent(DefaultMutableTreeNode node, ArrayList<String> resultList, boolean checkEnableUI) {
        if (node == null) {
            return false;
        }
        if (resultList == null) {
            return false;
        }
        if (node.getChildCount() == 0) {
            return false;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            this.getSelectionFromNode(nodeChild, resultList, checkEnableUI);
            this.getSelectionFromParent(nodeChild, resultList, checkEnableUI);
        }
        return true;
    }

    private void getSelectedObjectFromNode(DefaultMutableTreeNode node, ArrayList<GroupObject> resultList) {
        GroupObject group;
        Object nodeObject = node.getUserObject();
        if (nodeObject instanceof GroupObject && (group = (GroupObject)nodeObject).isSelected()) {
            resultList.add(group);
            return;
        }
        this.m_isAllSelected = false;
    }

    private void getSelectedObjectFromParent(DefaultMutableTreeNode node, ArrayList<GroupObject> resultList) {
        if (node == null) {
            return;
        }
        if (resultList == null) {
            return;
        }
        if (node.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            this.getSelectedObjectFromNode(nodeChild, resultList);
            this.getSelectedObjectFromParent(nodeChild, resultList);
        }
    }

    public boolean getAllTreeObject(ArrayList<GroupObject> list, boolean filterOutRoot) {
        if (list == null) {
            return false;
        }
        list.clear();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return false;
        }
        if (!filterOutRoot) {
            this.getObjectFromNode(node, list);
        }
        this.getObjectFromParent(node, list);
        return true;
    }

    private boolean getObjectFromNode(DefaultMutableTreeNode node, ArrayList<GroupObject> resultList) {
        Object nodeObject = node.getUserObject();
        if (nodeObject instanceof GroupObject) {
            GroupObject group = (GroupObject)nodeObject;
            resultList.add(group);
            return true;
        }
        return false;
    }

    private boolean getObjectFromParent(DefaultMutableTreeNode node, ArrayList<GroupObject> resultList) {
        if (node == null) {
            return false;
        }
        if (resultList == null) {
            return false;
        }
        if (node.getChildCount() == 0) {
            return false;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            this.getObjectFromNode(nodeChild, resultList);
            this.getObjectFromParent(nodeChild, resultList);
        }
        return true;
    }

    public ArrayList<String> getAllowedList() {
        return this.m_listAllowed;
    }

    public ArrayList<String> getDisallowedList() {
        return this.m_listDisallowed;
    }

    public boolean parseAllowedAndDisallowedLists() {
        this.m_listAllowed = new ArrayList();
        this.m_listDisallowed = new ArrayList();
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return false;
        }
        this.m_isAllSelected = true;
        this.parseAllowedAndDisallowedLists(node, -1);
        return this.m_isAllSelected;
    }

    private void parseAllowedAndDisallowedLists(DefaultMutableTreeNode node, int parentFlag) {
        if (node == null) {
            return;
        }
        int currentFlag = -1;
        GroupObject group = (GroupObject)node.getUserObject();
        if (group.isSelected()) {
            if (parentFlag == -1 || parentFlag == 0) {
                this.m_listAllowed.add(group.getId());
            }
            currentFlag = 1;
        } else {
            if (parentFlag == -1 || parentFlag == 1) {
                this.m_listDisallowed.add(group.getId());
            }
            currentFlag = 0;
            this.m_isAllSelected = false;
        }
        if (node.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            this.parseAllowedAndDisallowedLists(nodeChild, currentFlag);
        }
    }

    public boolean updateTreeNodeVisibility(AdminPrivilegeObject privilegeObj) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return false;
        }
        GroupObject group = (GroupObject)node.getUserObject();
        int constraint = privilegeObj.getGroupConstraint(group.getId(), 0);
        this.updateTreeNodeVisibility(node, privilegeObj, constraint != 1);
        return true;
    }

    private void updateTreeNodeVisibility(DefaultMutableTreeNode node, AdminPrivilegeObject privilegeObj, boolean isParentAccessible) {
        if (node == null) {
            return;
        }
        GroupObject group = (GroupObject)node.getUserObject();
        int accessRight = this.getAccessRightToGroup(node, privilegeObj, isParentAccessible);
        System.out.println("GroupCheckBoxTree>> updateTreeNodeVisibility: Update group=" + group.getName() + "  " + accessRight);
        switch (accessRight) {
            case -1: {
                if (!node.isRoot()) {
                    ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
                    System.out.println("GroupCheckBoxTree>> updateTreeNodeVisibility:   remove group=" + group.getName());
                }
                return;
            }
            case 0: {
                group.setEnabledUI(false);
                group.setAccessible(false);
                System.out.println("GroupCheckBoxTree>> updateTreeNodeVisibility:   disableUI group=" + group.getName());
                ((DefaultTreeModel)this.getModel()).nodeChanged(node);
                break;
            }
            default: {
                group.setEnabledUI(true);
                System.out.println("GroupCheckBoxTree>> updateTreeNodeVisibility:   enableUI group=" + group.getName());
                ((DefaultTreeModel)this.getModel()).nodeChanged(node);
            }
        }
        int i = node.getChildCount();
        while (--i >= 0) {
            DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getChildAt(i);
            this.updateTreeNodeVisibility(nodeChild, privilegeObj, accessRight == 1);
        }
    }

    private int getAccessRightToGroup(DefaultMutableTreeNode node, AdminPrivilegeObject privilegeObj, boolean isParentAccessible) {
        int i;
        String groupId = ((GroupObject)node.getUserObject()).getId();
        ArrayList<String> listAllowed = privilegeObj.getAllowedClientGroupList();
        ArrayList<String> listDisallowed = privilegeObj.getDisallowedClientGroupList();
        ArrayList<String> listReadOnly = privilegeObj.getReadOnlyClientGroupList();
        for (i = 0; i < listAllowed.size(); ++i) {
            if (!groupId.equals(listAllowed.get(i))) continue;
            return 1;
        }
        if (listReadOnly != null) {
            for (i = 0; i < listReadOnly.size(); ++i) {
                if (!groupId.equals(listReadOnly.get(i))) continue;
                return 1;
            }
        }
        if (listDisallowed != null) {
            for (i = 0; i < listDisallowed.size(); ++i) {
                boolean hasAccess = groupId.equals(listDisallowed.get(i));
                if (!hasAccess && isParentAccessible) continue;
                int j = node.getChildCount();
                while (--j >= 0) {
                    DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getChildAt(j);
                    int accessRight = this.getAccessRightToGroup(nodeChild, privilegeObj, false);
                    if (accessRight != -1) {
                        return 0;
                    }
                    nodeChild = nodeChild.getNextSibling();
                }
                return -1;
            }
        }
        return isParentAccessible ? 1 : -1;
    }

    public void expandAll() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        this.expandNodeAndChildren(node);
    }

    private void expandNodeAndChildren(DefaultMutableTreeNode node) {
        TreePath path = new TreePath(node.getPath());
        this.expandPath(path);
        if (node.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            this.expandNodeAndChildren(nodeChild);
        }
    }

    public boolean setCheckable(boolean checkable) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        if (node == null) {
            return false;
        }
        boolean result = this.setCheckable(node, checkable);
        return result;
    }

    private boolean setCheckable(DefaultMutableTreeNode nodeParent, boolean checkable) {
        if (nodeParent == null) {
            return false;
        }
        GroupObject group = (GroupObject)nodeParent.getUserObject();
        group.setEnabledUI(checkable);
        ((DefaultTreeModel)this.getModel()).nodeChanged(nodeParent);
        if (nodeParent.getChildCount() == 0) {
            return true;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)nodeParent.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            this.setCheckable(nodeChild, checkable);
        }
        return true;
    }

    protected void doCheck(DefaultMutableTreeNode node, int checkMode, boolean checkEnabled, boolean checkSelectable) {
        switch (this.selectionMode) {
            case 0: {
                this.checkInSingle(node, checkMode, checkEnabled, checkSelectable);
                break;
            }
            case 1: {
                this.checkIncludeChildrenSelected(node, checkMode, checkEnabled, checkSelectable);
                break;
            }
            case 2: {
                this.checkIncludeChildrenUnselected(node, checkMode, checkEnabled, checkSelectable);
                break;
            }
            case 3: {
                this.checkIncludeChildrenSelectedOrUnselected(node, checkMode, checkEnabled, checkSelectable);
                break;
            }
            case 4: {
                this.checkIncludeChildrenAllOrNone(node, checkMode, checkEnabled, checkSelectable);
                break;
            }
            case 5: {
                if (this.currentSelectedNode != null) {
                    this.checkInSingle(this.currentSelectedNode, 0, checkEnabled, checkSelectable);
                }
                this.checkInSingle(node, checkMode, checkEnabled, checkSelectable);
                this.currentSelectedNode = node;
                break;
            }
            default: {
                throw new IllegalStateException("Fell through switch statement with unexpected case:" + this.selectionMode);
            }
        }
    }

    protected int checkInSingle(DefaultMutableTreeNode node, int checkMode, boolean checkEnabled, boolean checkSelectable) {
        if (node == null) {
            return -1;
        }
        GroupObject groupObject = (GroupObject)node.getUserObject();
        if (!checkEnabled || checkEnabled && groupObject.isEnabledUI()) {
            switch (checkMode) {
                case 1: {
                    this.fireSelectionChange(groupObject, true, checkSelectable);
                    break;
                }
                case 0: {
                    this.fireSelectionChange(groupObject, false, checkSelectable);
                    break;
                }
                case -1: {
                    this.fireSelectionChange(groupObject, !groupObject.isSelected(), checkSelectable);
                    break;
                }
                default: {
                    throw new IllegalStateException("Fell through switch statement with unexpected case:" + checkMode);
                }
            }
            ((DefaultTreeModel)this.getModel()).nodeChanged(node);
        }
        return groupObject.isSelected() ? 1 : 0;
    }

    protected void checkIncludeChildrenSelected(DefaultMutableTreeNode node, int checkMode, boolean checkEnabled, boolean checkSelectable) {
        int result = this.checkInSingle(node, checkMode, checkEnabled, checkSelectable);
        if (result == 1) {
            this.checkChildren(node, true, checkEnabled, checkSelectable);
        }
    }

    protected void checkIncludeChildrenUnselected(DefaultMutableTreeNode node, int checkMode, boolean checkEnabled, boolean checkSelectable) {
        int result = this.checkInSingle(node, checkMode, checkEnabled, checkSelectable);
        if (result == 0) {
            this.checkChildren(node, false, checkEnabled, checkSelectable);
        }
    }

    protected void checkIncludeChildrenSelectedOrUnselected(DefaultMutableTreeNode node, int checkMode, boolean checkEnabled, boolean checkSelectable) {
        int result = this.checkInSingle(node, checkMode, checkEnabled, checkSelectable);
        if (result == 1) {
            this.checkChildren(node, true, checkEnabled, checkSelectable);
        } else if (result == 0) {
            this.checkChildren(node, false, checkEnabled, checkSelectable);
        }
    }

    protected void checkIncludeChildrenAllOrNone(DefaultMutableTreeNode node, int checkMode, boolean checkEnabled, boolean checkSelectable) {
        int result = this.checkInSingle(node, checkMode, checkEnabled, checkSelectable);
        if (result == 1) {
            this.checkChildren(node, true, checkEnabled, checkSelectable);
        }
        if (result == 0) {
            for (DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent(); parent != null; parent = (DefaultMutableTreeNode)parent.getParent()) {
                this.check(parent, 0, false, checkEnabled, checkSelectable);
            }
        }
    }

    protected void checkChildren(DefaultMutableTreeNode node, boolean checked, boolean checkEnabled, boolean checkSelectable) {
        if (node == null) {
            return;
        }
        if (node.getChildCount() == 0) {
            return;
        }
        for (DefaultMutableTreeNode nodeChild = (DefaultMutableTreeNode)node.getFirstChild(); nodeChild != null; nodeChild = nodeChild.getNextSibling()) {
            GroupObject groupObject = (GroupObject)nodeChild.getUserObject();
            if ((!checkEnabled || checkEnabled && groupObject.isEnabledUI()) && this.fireSelectionChange(groupObject, checked, checkSelectable)) {
                ((DefaultTreeModel)this.getModel()).nodeChanged(nodeChild);
            }
            this.checkChildren(nodeChild, checked, checkEnabled, checkSelectable);
        }
    }

    protected void check(DefaultMutableTreeNode node, int checkMode, boolean includeChildren, boolean checkEnabled, boolean checkSelectable) {
        if (node == null) {
            return;
        }
        GroupObject groupObject = (GroupObject)node.getUserObject();
        if (!checkEnabled || checkEnabled && groupObject.isEnabledUI()) {
            switch (checkMode) {
                case 1: {
                    this.fireSelectionChange(groupObject, true, checkSelectable);
                    break;
                }
                case 0: {
                    this.fireSelectionChange(groupObject, false, checkSelectable);
                    break;
                }
                case -1: {
                    this.fireSelectionChange(groupObject, !groupObject.isSelected(), checkSelectable);
                    break;
                }
                default: {
                    throw new IllegalStateException("Fell through switch statement with unexpected case:" + checkMode);
                }
            }
            ((DefaultTreeModel)this.getModel()).nodeChanged(node);
        }
        if (includeChildren) {
            this.checkChildren(node, groupObject.isSelected(), checkEnabled, checkSelectable);
        }
    }

    private void treeValueChanged() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getLastSelectedPathComponent();
        if (node == null) {
            return;
        }
        GroupObject group = (GroupObject)node.getUserObject();
        if (group != null) {
            this.doCheck(node, -1, false, true);
        }
    }

    static class SearchClientGroupCheckBoxTree
    extends GroupCheckBoxTree {
        private static final long serialVersionUID = -7951064248633867411L;

        SearchClientGroupCheckBoxTree() {
        }

        @Override
        DefaultMutableTreeNode getTreeNode(String domainId, boolean checkAdminPrivilege) throws ConsoleException {
            return GroupHandler.getGroups(false, domainId, checkAdminPrivilege, false);
        }
    }

    class NodeSelectionListener
    extends MouseAdapter {
        JTree tree;

        NodeSelectionListener(JTree tree) {
            this.tree = tree;
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            int y;
            if (!this.tree.isEnabled()) {
                return;
            }
            int x = event.getX();
            int row = this.tree.getRowForLocation(x, y = event.getY());
            TreePath path = this.tree.getPathForRow(row);
            if (path == null) {
                return;
            }
            Rectangle rectangle = this.tree.getRowBounds(row);
            int startX = rectangle.x;
            CustomCheckTreeCellRenderer renderer = (CustomCheckTreeCellRenderer)this.tree.getCellRenderer();
            int width = renderer.getCheckBoxWidth();
            int endX = startX + width;
            if (x < startX || x > endX) {
                return;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            GroupObject groupObject = (GroupObject)node.getUserObject();
            if (!groupObject.isEnabledUI()) {
                return;
            }
            if (groupObject.canDirectiveSelectable()) {
                if (GroupCheckBoxTree.this.currentSelectedNode == null) {
                    GroupCheckBoxTree.this.currentSelectedNode = node;
                }
                GroupCheckBoxTree.this.doCheck(node, -1, false, true);
            }
            if (row == 0) {
                this.tree.revalidate();
                this.tree.repaint();
            }
        }

        @Override
        public void mousePressed(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        @Override
        public void mouseReleased(MouseEvent event) {
            this.maybeShowPopup(event);
        }

        private void maybeShowPopup(MouseEvent event) {
            if (!GroupCheckBoxTree.this.enabledPopupMenu) {
                return;
            }
            int selRow = this.tree.getRowForLocation(event.getX(), event.getY());
            if (selRow == -1) {
                return;
            }
            this.tree.setSelectionRow(selRow);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (event.isPopupTrigger()) {
                GroupObject group = (GroupObject)node.getUserObject();
                if (group == null) {
                    return;
                }
                JPopupMenu popup = this.setupPopupMenu(group);
                if (popup != null) {
                    popup.show(event.getComponent(), event.getX(), event.getY());
                }
            }
        }

        private JPopupMenu setupPopupMenu(GroupObject group) {
            JPopupMenu popup = new JPopupMenu();
            JMenuItem menuItem = new JMenuItem(group.isSelected() ? MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "GroupCheckBoxTree.menu.unselect") : MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "GroupCheckBoxTree.menu.select"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    NodeSelectionListener.this.menuActionPerformed(event);
                }
            });
            popup.add(menuItem);
            menuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "GroupCheckBoxTree.menu.selectThisAndAllSubgroups"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    NodeSelectionListener.this.menuActionPerformed(event);
                }
            });
            popup.add(menuItem);
            menuItem = new JMenuItem(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "GroupCheckBoxTree.menu.unselectThisAndAllSubgroups"));
            menuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent event) {
                    NodeSelectionListener.this.menuActionPerformed(event);
                }
            });
            popup.add(menuItem);
            return popup;
        }

        private void menuActionPerformed(ActionEvent event) {
            JMenuItem source = (JMenuItem)event.getSource();
            String item = source.getText();
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getLastSelectedPathComponent();
            if (node == null) {
                return;
            }
            if (MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "GroupCheckBoxTree.menu.unselect").equals(item)) {
                GroupCheckBoxTree.this.check(node, 0, false, true, true);
            } else if (MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "GroupCheckBoxTree.menu.select").equals(item)) {
                GroupCheckBoxTree.this.check(node, 1, false, true, true);
            } else if (MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "GroupCheckBoxTree.menu.unselectThisAndAllSubgroups").equals(item)) {
                GroupCheckBoxTree.this.check(node, 0, true, true, true);
            } else if (MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "GroupCheckBoxTree.menu.selectThisAndAllSubgroups").equals(item)) {
                GroupCheckBoxTree.this.check(node, 1, true, true, true);
            }
        }
    }
}

