/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.AlwaysEnabledDescriptionTextArea;
import com.sygate.scm.console.ui.util.AlwaysEnabledJComboBox;
import com.sygate.scm.console.ui.util.ComponentFilter;
import com.sygate.scm.console.ui.util.ReadOnlyUtils;
import com.sygate.scm.console.ui.util.StripesTable;
import java.awt.Component;
import java.awt.event.KeyListener;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JViewport;
import javax.swing.table.JTableHeader;

public class EnabledComponentFilter {

    static class HighlightReadOnlyComponentFilter
    extends IncludedComponentFilter {
        HighlightReadOnlyComponentFilter() {
        }

        @Override
        protected Class<?>[] includedClasses() {
            return new Class[]{JRadioButton.class, JCheckBox.class};
        }

        @Override
        public void doFilter(Component c, boolean readOnly) {
            if (this.accept(c)) {
                ReadOnlyUtils.setEnabledAndHighlight(c, !readOnly);
            }
        }
    }

    static class JListFilter
    implements ComponentFilter {
        JListFilter() {
        }

        @Override
        public boolean accept(Component c) {
            return c instanceof JList;
        }

        @Override
        public void doFilter(Component c, boolean readOnly) {
            if (this.accept(c)) {
                JList l = (JList)c;
                if (readOnly) {
                    for (KeyListener listener : l.getKeyListeners()) {
                        l.removeKeyListener(listener);
                    }
                }
            }
        }
    }

    static class AlwaysEnabledJComboBoxFilter
    implements ComponentFilter {
        AlwaysEnabledJComboBoxFilter() {
        }

        @Override
        public boolean accept(Component c) {
            return c instanceof AlwaysEnabledJComboBox;
        }

        @Override
        public void doFilter(Component c, boolean readOnly) {
            if (this.accept(c)) {
                ((AlwaysEnabledJComboBox)c).setEditable(!readOnly);
            }
        }
    }

    static class AlwaysEnabledButtonFilter
    implements ComponentFilter {
        AlwaysEnabledButtonFilter() {
        }

        @Override
        public boolean accept(Component c) {
            return c instanceof AlwaysEnabledButton;
        }

        @Override
        public void doFilter(Component c, boolean readOnly) {
            if (this.accept(c)) {
                ((AlwaysEnabledButton)c).setChildWindowReadOnly(readOnly);
            }
        }
    }

    static abstract class IncludedComponentFilter
    implements ComponentFilter {
        IncludedComponentFilter() {
        }

        public boolean imply(Component target) {
            if (target == null) {
                return false;
            }
            boolean result = false;
            for (Class<?> clazz : this.includedClasses()) {
                if (!clazz.isInstance(target)) continue;
                result = true;
                break;
            }
            return result;
        }

        @Override
        public boolean accept(Component c) {
            return this.imply(c);
        }

        @Override
        public void doFilter(Component c, boolean readOnly) {
            if (this.accept(c)) {
                c.setEnabled(!readOnly);
            }
        }

        protected abstract Class<?>[] includedClasses();
    }

    static abstract class ExcludedComponentFilter
    implements ComponentFilter {
        ExcludedComponentFilter() {
        }

        public boolean imply(Component target) {
            if (target == null) {
                return false;
            }
            boolean result = false;
            for (Class<?> clazz : this.excludedClasses()) {
                if (!clazz.isInstance(target)) continue;
                result = true;
                break;
            }
            return result;
        }

        @Override
        public boolean accept(Component c) {
            return !this.imply(c);
        }

        @Override
        public void doFilter(Component c, boolean readOnly) {
            if (this.accept(c)) {
                c.setEnabled(!readOnly);
            }
        }

        protected abstract Class<?>[] excludedClasses();
    }

    static class AlwaysEnabledComponentFilter
    extends ExcludedComponentFilter {
        AlwaysEnabledComponentFilter() {
        }

        @Override
        protected Class<?>[] excludedClasses() {
            return new Class[]{AlwaysEnabledButton.class, AlwaysEnabledJComboBox.class, AlwaysEnabledDescriptionTextArea.class, JLabel.class, JTabbedPane.class, JRootPane.class, JDialog.class, JRadioButton.class, JCheckBox.class, JScrollBar.class, JTableHeader.class, JScrollPane.class, JPanel.class, JLayeredPane.class, JViewport.class, JList.class, StripesTable.class};
        }
    }
}

