/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.schema.ObjReference;
import com.sygate.scm.common.configobject.schema.SemConfigRoot;
import com.sygate.scm.common.configobject.schema.SemDomain;
import com.sygate.scm.common.configobject.schema.SemDomainArray;
import com.sygate.scm.console.ConsoleMain;
import com.sygate.scm.console.ui.util.CheckListRenderer;
import com.sygate.scm.console.ui.util.CheckableItem;
import com.sygate.scm.console.util.DataobjectManager;
import com.sygate.scm.util.LoggerUtilities;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JList;

public class DomainCheckBoxList
extends JList<CheckableItem> {
    private static final long serialVersionUID = 1L;

    public DomainCheckBoxList() {
        try {
            this.jbInit();
        }
        catch (Exception e) {
            LoggerUtilities.logException((Throwable)e);
        }
    }

    private void jbInit() throws Exception {
        this.setModel(new DefaultListModel());
        this.setCellRenderer(new CheckListRenderer(this));
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (!DomainCheckBoxList.this.isEnabled()) {
                    return;
                }
                System.out.println(e.getSource());
                int index = DomainCheckBoxList.this.locationToIndex(e.getPoint());
                if (index < 0) {
                    return;
                }
                CheckListRenderer renderer = (CheckListRenderer)DomainCheckBoxList.this.getCellRenderer();
                int checkWidth = renderer.getCheckBoxWidth();
                int eventX = e.getPoint().x;
                int startX = DomainCheckBoxList.this.indexToLocation((int)index).x;
                if (eventX >= startX && eventX <= startX + checkWidth) {
                    CheckableItem item;
                    item.setSelected(!(item = (CheckableItem)DomainCheckBoxList.this.getModel().getElementAt(index)).isSelected());
                    Rectangle rect = DomainCheckBoxList.this.getCellBounds(index, index);
                    DomainCheckBoxList.this.repaint(rect);
                }
            }
        });
    }

    public boolean getSelection(ArrayList<String> list) {
        boolean isAllSelected = true;
        DefaultListModel listModel = (DefaultListModel)this.getModel();
        int size = listModel.getSize();
        for (int i = 0; i < size; ++i) {
            CheckableItem item = (CheckableItem)listModel.get(i);
            if (item.isSelected()) {
                list.add(item.getId());
                continue;
            }
            isAllSelected = false;
        }
        return isAllSelected;
    }

    public void init(boolean isAllSelected) {
        this.setCellRenderer(new CheckListRenderer(this));
        DefaultListModel listModel = (DefaultListModel)this.getModel();
        ImageIcon rootIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("locationroot.gif")));
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            SemDomainArray domainArray = semConfigRoot.getSemDomainArray();
            for (int i = 0; i < domainArray.getObjReferenceCount(); ++i) {
                ObjReference reference = domainArray.getObjReference(i);
                SemDomain semDomain = (SemDomain)data.getObjectByGUID("SemDomain", reference.getTargetId());
                if (semDomain == null) continue;
                CheckableItem item = new CheckableItem(semDomain.getName(), semDomain.getId());
                item.setIcon(rootIcon);
                item.setSelected(isAllSelected);
                listModel.addElement(item);
            }
        }
        catch (Exception ex) {
            System.out.println("DomainCheckBoxList>> init: Exception...");
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void init(ArrayList<String> selectedDomainList) {
        this.setCellRenderer(new CheckListRenderer(this));
        DefaultListModel listModel = (DefaultListModel)this.getModel();
        ImageIcon rootIcon = new ImageIcon(Toolkit.getDefaultToolkit().getImage(ConsoleMain.class.getResource("locationroot.gif")));
        try {
            DataobjectManager data = DataobjectManager.getInstance();
            SemConfigRoot semConfigRoot = data.getSemConfigRoot();
            SemDomainArray domainArray = semConfigRoot.getSemDomainArray();
            for (int i = 0; i < domainArray.getObjReferenceCount(); ++i) {
                ObjReference reference = domainArray.getObjReference(i);
                SemDomain semDomain = (SemDomain)data.getObjectByGUID("SemDomain", reference.getTargetId());
                if (semDomain == null) continue;
                CheckableItem item = new CheckableItem(semDomain.getName(), semDomain.getId());
                item.setIcon(rootIcon);
                boolean isSelected = false;
                if (selectedDomainList != null) {
                    for (int j = 0; j < selectedDomainList.size(); ++j) {
                        String id = selectedDomainList.get(j);
                        if (id == null || !id.equals(semDomain.getId())) continue;
                        isSelected = true;
                        break;
                    }
                }
                item.setSelected(isSelected);
                listModel.addElement(item);
            }
        }
        catch (Exception ex) {
            System.out.println("DomainCheckBoxList>> init: Exception...");
            LoggerUtilities.logException((Throwable)ex);
        }
    }

    public void remove(String domainId) {
        DefaultListModel listModel = (DefaultListModel)this.getModel();
        int size = listModel.getSize();
        for (int i = 0; i < size; ++i) {
            CheckableItem item = (CheckableItem)listModel.get(i);
            if (!item.getId().equals(domainId)) continue;
            listModel.removeElement(item);
            break;
        }
    }

    public void setSelectAll(boolean selected) {
        DefaultListModel listModel = (DefaultListModel)this.getModel();
        int size = listModel.getSize();
        for (int i = 0; i < size; ++i) {
            CheckableItem item = (CheckableItem)listModel.get(i);
            item.setSelected(selected);
        }
        this.updateUI();
    }
}

