/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.configobject.TopLevelObject;
import com.sygate.scm.common.configobject.schema.SemSite;
import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.handler.Manager;
import com.sygate.scm.console.logicobject.ServerObject;
import com.sygate.scm.console.ui.server.dlg.ServerSynchronizePanel;
import com.sygate.scm.console.ui.util.DialogBase;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.ConsoleException;
import com.sygate.scm.console.util.ConsoleLogger;
import com.sygate.scm.console.util.DataobjectManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.text.MessageFormat;

public class DirectoryServersDlg
extends DialogBase {
    private static final long serialVersionUID = -5674146876865328320L;
    private ServerObject server;
    private boolean showSchedule;
    private ServerSynchronizePanel syncPanel;

    public DirectoryServersDlg(ServerObject server, boolean readOnly, boolean showSchedule) {
        super(Manager.getFrame(), MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "DirectoryServersDlg.title.DirectoryServers"), server), true);
        this.server = server;
        this.showSchedule = showSchedule;
        this.initialize();
        this.syncPanel.setModel(server);
        if (readOnly) {
            this.setReadOnlyStatus();
        }
        UiUtilities.centerComponent((Component)this);
        this.setVisible(true);
    }

    private void initialize() {
        this.syncPanel = new ServerSynchronizePanel(this.readOnly, this.showSchedule);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)UIUtilities.createScrollPaneWithoutBoard(this.syncPanel), "Center");
        this.getContentPane().add((Component)this.getButtonPanel(), "South");
        this.pack();
    }

    @Override
    protected boolean isHelpButtonShown() {
        return false;
    }

    @Override
    protected void commit() {
        block2: {
            this.syncPanel.updateModel();
            SemSite semSite = this.server.getParentSite();
            try {
                DataobjectManager.getInstance().updateObject("Merge", (TopLevelObject)semSite);
                ConsoleLogger.logAdminEvent(16389, MessageFormat.format(MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "DirectoryServersDlg.ServerNamed"), this.server.getName()));
            }
            catch (ConsoleException ce) {
                if (!ce.needRelogin()) break block2;
                Manager.getFrame().showLoginPanel();
            }
        }
    }

    @Override
    protected void setReadOnlyStatus() {
        UIUtilities.setContainerStatus(this.syncPanel, false);
        this.resetOKButton(false);
    }
}

