/*
 * Decompiled with CFR 0.152.
 */
package com.sygate.scm.console.ui.util;

import com.sygate.scm.common.i18n.MessageResources;
import com.sygate.scm.common.ui.UiUtilities;
import com.sygate.scm.console.help.ContentSensitiveHelpPage;
import com.sygate.scm.console.help.HelpUtil;
import com.sygate.scm.console.ui.FeedbackMenuBar;
import com.sygate.scm.console.ui.util.AlwaysEnabledButton;
import com.sygate.scm.console.ui.util.UIUtilities;
import com.sygate.scm.console.util.Env;
import com.sygate.scm.console.util.ScmProperties;
import com.sygate.scm.console.util.UIText;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;

public abstract class DialogBase
extends JDialog
implements ContentSensitiveHelpPage {
    private static final long serialVersionUID = -739139511009554672L;
    protected JButton jBOk = new JButton(UIText.get(3584));
    protected JButton jBCancel = new AlwaysEnabledButton(UIText.get(512));
    protected JButton jBHelp = new AlwaysEnabledButton(UIText.get(1792));
    protected boolean isOk;
    protected boolean readOnly = false;
    protected boolean hasHelp;
    protected boolean allowSave = true;
    public static final String OK_BUTON_NAME = "OK";
    public static final String CANCEL_BUTON_NAME = "CANCEL";
    public static final String HELP_BUTON_NAME = "HELP";

    public DialogBase(JFrame parent, String title, boolean modal, boolean hasHelp) {
        super(parent, title, modal);
        this.hasHelp = hasHelp;
        this.setDefaultCloseOperation(2);
        if (this.hasHelp) {
            KeyStroke helpKey = KeyStroke.getKeyStroke(112, 0);
            String helpActionKey = "Context-Sensitive Help";
            ((JComponent)this.getContentPane()).getInputMap(2).put(helpKey, helpActionKey);
            ((JComponent)this.getContentPane()).getActionMap().put(helpActionKey, new HelpAction());
        }
        this.getRootPane().registerKeyboardAction(e -> {
            if (this.jBCancel.isEnabled()) {
                this.cancel();
            }
        }, KeyStroke.getKeyStroke(27, 0), 2);
        if (ScmProperties.isFeedbackEnabled()) {
            this.setJMenuBar(new FeedbackMenuBar(this.getClass().getSimpleName(), this));
        }
    }

    public DialogBase(JFrame parent, String title, boolean modal) {
        this(parent, title, modal, true);
    }

    @Override
    public boolean isResizable() {
        return true;
    }

    public JButton getOkButton() {
        return this.jBOk;
    }

    protected void setBackgroundColorForAllPanels(Component comp) {
        if (comp == null) {
            return;
        }
        if (comp instanceof JPanel || comp instanceof JCheckBox || comp instanceof JSplitPane) {
            comp.setBackground(new JPanel().getBackground());
        }
        if (comp instanceof Container) {
            Container container = (Container)comp;
            int count = container.getComponentCount();
            for (int i = 0; i < count; ++i) {
                Component c = container.getComponent(i);
                this.setBackgroundColorForAllPanels(c);
            }
        }
    }

    @Override
    public void pack() {
        if (!Env.isUnitTest()) {
            super.pack();
            Rectangle screenRect = UiUtilities.getFreeScreenBouds((Component)this);
            Dimension maxSize = UiUtilities.getMaxScreenDimension((Component)this);
            int scrHeight = maxSize.height;
            int scrWidth = maxSize.width;
            if (this.getHeight() > scrHeight) {
                this.setSize(this.getWidth(), scrHeight);
                this.setLocation(this.getX(), screenRect.y);
            }
            if (this.getWidth() > scrWidth) {
                this.setSize(scrWidth, this.getHeight());
                this.setLocation(screenRect.x, this.getY());
            }
        }
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readOnly = readOnly;
        this.setReadOnlyStatus();
    }

    @Override
    public void setVisible(boolean b) {
        if (Env.isUnitTest()) {
            this.isOk = false;
        } else {
            if (b) {
                this.isOk = false;
            }
            super.setVisible(b);
        }
    }

    public boolean isOk() {
        if (Env.isUnitTest()) {
            this.ok();
        }
        return this.isOk;
    }

    public boolean isAllowSave() {
        return this.allowSave;
    }

    public void setAllowSave(boolean allowSave) {
        this.allowSave = allowSave;
    }

    protected boolean ok() {
        if (!Env.isUnitTest() && !this.isValidate()) {
            return false;
        }
        if (this.isAllowSave()) {
            this.isOk = true;
            this.commit();
            this.dispose();
            return true;
        }
        this.setAllowSave(true);
        return false;
    }

    protected void cancel() {
        this.isOk = false;
        this.dispose();
    }

    protected void help() {
        HelpUtil.showHelpOrErrDlg(this.getContentSensitiveHelpToken());
    }

    @Override
    public String getContentSensitiveHelpToken() {
        System.err.println("Dialog:  " + this.getClass().getName());
        return null;
    }

    protected void commit() {
    }

    protected boolean isValidate() {
        return true;
    }

    protected boolean validateInputNoScriptParams(String inputToValidate) {
        if (inputToValidate != null && !UIUtilities.validateNoScriptParams(inputToValidate)) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "DialogBase.noScriptOrHtmlParams"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.error"), 0);
            return false;
        }
        return true;
    }

    protected boolean validateInputNoHTMLParams(String inputToValidate) {
        if (inputToValidate != null && !UIUtilities.validateNoHtmlParams(inputToValidate)) {
            JOptionPane.showMessageDialog(this, MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "DialogBase.noScriptOrHtmlParams"), MessageResources.getInstance().getString("com.sygate.scm.console.ui.util.uiutil", "UIUtilities.error"), 0);
            return false;
        }
        return true;
    }

    protected boolean validateInputFullCheck(String inputToValidate) {
        return this.validateInputNoScriptParams(inputToValidate) && this.validateInputNoHTMLParams(inputToValidate);
    }

    protected JPanel getButtonPanel() {
        return this.getButtonPanel(0, 4, true);
    }

    protected JPanel getButtonPanel(int directory, int alignment, boolean isFitButtons) {
        JPanel buttonPanel = new JPanel();
        buttonPanel.putClientProperty("cssClass", "dialogBaseButtonPanel");
        ArrayList<JButton> buttonList = new ArrayList<JButton>();
        if (this.isOkButtonShown()) {
            buttonList.add(this.initOkButton());
            UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBOk);
        }
        if (this.isCancelButtonShown()) {
            buttonList.add(this.initCancelButton());
            if (!this.isOkButtonShown()) {
                UiUtilities.setDefaultButton((RootPaneContainer)this, (JButton)this.jBCancel);
            }
        }
        if (this.isHelpButtonShown()) {
            buttonList.add(this.initHelpButton());
        }
        UIUtilities.layoutButtonPanel(buttonPanel, buttonList.toArray(new JButton[0]), directory, alignment, isFitButtons);
        this.jBOk.setEnabled(this.isOkButtonActive());
        return buttonPanel;
    }

    protected boolean isOkButtonActive() {
        return true;
    }

    protected boolean isOkButtonShown() {
        return true;
    }

    protected boolean isCancelButtonShown() {
        return true;
    }

    protected boolean isHelpButtonShown() {
        return this.hasHelp;
    }

    protected String getOkButtonText() {
        return null;
    }

    protected String getCancelButtonText() {
        return null;
    }

    protected String getHelpButtonText() {
        return null;
    }

    private JButton initOkButton() {
        this.jBOk.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBase.this.ok();
            }
        });
        String okText = this.getOkButtonText();
        if (okText != null) {
            this.jBOk.setText(okText);
        }
        return this.jBOk;
    }

    private JButton initCancelButton() {
        this.jBCancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBase.this.cancel();
            }
        });
        String cancelText = this.getCancelButtonText();
        if (cancelText != null) {
            this.jBCancel.setText(cancelText);
        }
        return this.jBCancel;
    }

    protected JButton initHelpButton() {
        this.jBHelp.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DialogBase.this.help();
            }
        });
        String helpText = this.getHelpButtonText();
        if (helpText != null) {
            this.jBHelp.setText(helpText);
        }
        return this.jBHelp;
    }

    public void resetOKButton(boolean b) {
        this.jBOk.setEnabled(b);
    }

    protected Container[] readOnlyContainers() {
        return new Container[0];
    }

    protected void setReadOnlyStatus() {
        if (this.isReadOnly()) {
            UIUtilities.disableAllComponents(this.readOnlyContainers());
            this.resetOKButton(false);
            this.jBCancel.setEnabled(true);
            this.jBHelp.setEnabled(true);
        }
    }

    private class HelpAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private HelpAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DialogBase.this.help();
        }
    }
}

